/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.Splash;
import net.sourceforge.plantuml.dot.GraphvizUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.stats.StatsUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;

public class PlantUmlTask
extends Task {
    private String dir = null;
    private final Option option = new Option();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<FileList> filelists = new ArrayList<FileList>();
    private AtomicInteger nbFiles = new AtomicInteger(0);
    private ExecutorService executorService;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFilelist(FileList list) {
        this.filelists.add(list);
    }

    public void execute() throws BuildException {
        if (this.option.isSplash()) {
            Splash.createSplash();
        }
        this.log("Starting PlantUML");
        try {
            File error;
            if (this.dir != null) {
                Iterator<FileList> error2 = this.processingSingleDirectory(new File(this.dir));
                this.eventuallyFailfast((File)((Object)error2));
            }
            for (FileSet fileSet : this.filesets) {
                error = this.manageFileSet(fileSet);
                this.eventuallyFailfast(error);
            }
            for (FileList fileList : this.filelists) {
                error = this.manageFileList(fileList);
                this.eventuallyFailfast(error);
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                if (this.option.isSplash()) {
                    Splash.disposeSplash();
                }
            }
            this.log("Nb images generated: " + this.nbFiles.get());
        }
        catch (IOException e) {
            Logme.error(e);
            throw new BuildException(e.toString());
        }
        catch (InterruptedException e) {
            Logme.error(e);
            throw new BuildException(e.toString());
        }
    }

    private void eventuallyFailfast(File error) throws IOException {
        if (error != null && this.option.isFailfastOrFailfast2()) {
            this.log("Error in file " + error.getCanonicalPath());
            throw new BuildException("Error in file " + error.getCanonicalPath());
        }
    }

    private File manageFileList(FileList fl) throws IOException, InterruptedException {
        String[] srcFiles;
        File fromDir = fl.getDir(this.getProject());
        for (String src : srcFiles = fl.getFiles(this.getProject())) {
            File f = new File(fromDir, src);
            boolean error = this.processingSingleFile(f);
            if (!error) continue;
            return f;
        }
        return null;
    }

    private File manageFileSet(FileSet fs) throws IOException, InterruptedException {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File fromDir = fs.getDir(this.getProject());
        String[] srcFiles = ds.getIncludedFiles();
        String[] srcDirs = ds.getIncludedDirectories();
        for (String src : srcFiles) {
            File f = new File(fromDir, src);
            boolean error = this.processingSingleFile(f);
            if (!error) continue;
            return f;
        }
        for (String src : srcDirs) {
            File dir = new File(fromDir, src);
            File errorFile = this.processingSingleDirectory(dir);
            if (errorFile == null) continue;
            return errorFile;
        }
        return null;
    }

    private boolean processingSingleFile(final File f) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isVerbose()) {
            this.log("Processing " + f.getAbsolutePath());
        }
        final SourceFileReader sourceFileReader = new SourceFileReader(Defines.createWithFileName(f), f, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
        if (this.option.isCheckOnly()) {
            return sourceFileReader.hasError();
        }
        if (this.executorService == null) {
            return this.doFile(f, sourceFileReader);
        }
        Splash.incTotal(1);
        this.executorService.submit(new Callable<Boolean>(){
            final /* synthetic */ PlantUmlTask this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Boolean call() throws Exception {
                return this.this$0.doFile(f, sourceFileReader);
            }
        });
        return false;
    }

    private boolean doFile(File f, SourceFileReader sourceFileReader) throws IOException, InterruptedException {
        List<GeneratedImage> result = sourceFileReader.getGeneratedImages();
        boolean error = false;
        for (GeneratedImage g2 : result) {
            if (OptionFlags.getInstance().isVerbose()) {
                this.myLog(g2 + " " + g2.getDescription());
            }
            this.nbFiles.addAndGet(1);
            if (g2.lineErrorRaw() == -1) continue;
            error = true;
        }
        Splash.incDone(error);
        if (error) {
            this.myLog("Error: " + f.getCanonicalPath());
        }
        return error && this.option.isFailfastOrFailfast2();
    }

    private synchronized void myLog(String s2) {
        this.log(s2);
    }

    private File processingSingleDirectory(File dir) throws IOException, InterruptedException {
        if (!dir.exists()) {
            String s2 = "The file " + dir.getAbsolutePath() + " does not exists.";
            this.log(s2);
            throw new BuildException(s2);
        }
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                boolean error;
                if (!f.isFile() || !this.fileToProcess(f.getName()) || !(error = this.processingSingleFile(f))) continue;
                return f;
            }
        }
        return null;
    }

    private boolean fileToProcess(String name) {
        return name.matches(Option.getPattern());
    }

    public void setDir(String s2) {
        this.dir = s2;
    }

    public void setOutput(String s2) {
        this.option.setOutputDir(new File(s2));
    }

    public void setCharset(String s2) {
        this.option.setCharset(s2);
    }

    public void setConfig(String s2) {
        try {
            this.option.initConfig(s2);
        }
        catch (IOException e) {
            this.log("Error reading " + s2);
        }
    }

    public void setKeepTmpFiles(String s2) {
    }

    public void setDebugSvek(String s2) {
        if ("true".equalsIgnoreCase(s2)) {
            this.option.setDebugSvek(true);
        }
    }

    public void setVerbose(String s2) {
        if ("true".equalsIgnoreCase(s2)) {
            OptionFlags.getInstance().setVerbose(true);
        }
    }

    public void setFormat(String s2) {
        if ("scxml".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SCXML));
        }
        if ("xmi".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
        }
        if ("xmi:argo".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
        }
        if ("xmi:script".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_SCRIPT));
        }
        if ("xmi:start".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
        }
        if ("eps".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
        }
        if ("braille".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.BRAILLE_PNG));
        }
        if ("pdf".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
        }
        if ("latex".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX));
        }
        if ("latex:nopreamble".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX_NO_PREAMBLE));
        }
        if ("eps:text".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
        }
        if ("svg".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
        }
        if ("txt".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
        }
        if ("utxt".equalsIgnoreCase(s2)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
        }
    }

    public void setGraphvizDot(String s2) {
        GraphvizUtils.setDotExecutable(s2);
    }

    public void setNbThread(String s2) {
        int nbThreads;
        if (s2 != null && s2.matches("\\d+")) {
            this.option.setNbThreads(Integer.parseInt(s2));
            nbThreads = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(nbThreads);
        }
        if ("auto".equalsIgnoreCase(s2)) {
            this.option.setNbThreads(Option.defaultNbThreads());
            nbThreads = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(nbThreads);
        }
    }

    public void setNbThreads(String s2) {
        this.setNbThread(s2);
    }

    public void setFailFast(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        this.option.setFailfast(flag2);
    }

    public void setFailFast2(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        this.option.setFailfast2(flag2);
    }

    public void setCheckOnly(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        this.option.setCheckOnly(flag2);
    }

    public void setOverwrite(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        OptionFlags.getInstance().setOverwrite(flag2);
    }

    public void setFileSeparator(String s2) {
        OptionFlags.getInstance().setFileSeparator(s2);
    }

    public void setHtmlStats(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        StatsUtils.setHtmlStats(flag2);
    }

    public void setXmlStats(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        StatsUtils.setXmlStats(flag2);
    }

    public void setRealTimeStats(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        StatsUtils.setRealTimeStats(flag2);
    }

    public void setEnableStats(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        OptionFlags.getInstance().setEnableStats(flag2);
    }

    public void setSplash(String s2) {
        boolean flag2 = "true".equalsIgnoreCase(s2) || "yes".equalsIgnoreCase(s2) || "on".equalsIgnoreCase(s2);
        this.option.setSplash(flag2);
    }
}

