/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jcckit;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.jcckit.PSystemJcckit;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.utils.Log;

public class PSystemJcckitFactory
extends PSystemBasicFactory<PSystemJcckit> {
    private StringBuilder data;
    private int width;
    private int height;

    public PSystemJcckitFactory() {
        super(DiagramType.JCCKIT);
    }

    @Override
    public PSystemJcckit initDiagram(UmlSource source, String startLine) {
        this.data = null;
        this.width = 640;
        this.height = 400;
        this.extractDimension(startLine);
        this.data = new StringBuilder();
        return this.createSystem(source);
    }

    private void extractDimension(String startLine) {
        Pattern2 p = MyPattern.cmpile("\\((\\d+),(\\d+)\\)");
        Matcher2 m4 = p.matcher(startLine);
        boolean ok = m4.find();
        if (ok) {
            this.width = Integer.parseInt(m4.group(1));
            this.height = Integer.parseInt(m4.group(2));
        }
    }

    String getDimension() {
        return "" + this.width + "-" + this.height;
    }

    private PSystemJcckit createSystem(UmlSource source) {
        Properties p = new Properties();
        try {
            String tmp = this.data.toString();
            StringReader sr = new StringReader(tmp);
            p.load(sr);
        }
        catch (IOException e) {
            Log.error("Error " + e);
            Logme.error(e);
            return null;
        }
        return new PSystemJcckit(source, p, this.width, this.height);
    }

    @Override
    public PSystemJcckit executeLine(UmlSource source, PSystemJcckit system, String line) {
        if (system == null && line.startsWith("jcckit")) {
            this.data = new StringBuilder();
            this.extractDimension(line);
            return this.createSystem(source);
        }
        if (this.data == null) {
            return null;
        }
        this.data.append(StringUtils.trin(line));
        this.data.append("\n");
        return this.createSystem(source);
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return null;
    }
}

