/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.project.GanttStyle;
import net.sourceforge.plantuml.project.LoadPlanable;
import net.sourceforge.plantuml.project.OpenClose;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;

public class TimeHeaderParameters
implements GanttStyle {
    private final Map<Day, HColor> colorDays;
    private final double scale;
    private final Day min;
    private final Day max;
    private final HColorSet colorSet;
    private final GanttStyle ganttStyle;
    private final Locale locale;
    private final OpenClose openClose;
    private final Map<DayOfWeek, HColor> colorDaysOfWeek;
    private final Set<Day> verticalSeparatorBefore;
    private final boolean hideSaturdayAndSunday;

    public TimeHeaderParameters(Map<Day, HColor> colorDays, double scale, Day min2, Day max, HColorSet colorSet, Locale locale, OpenClose openClose, Map<DayOfWeek, HColor> colorDaysOfWeek, Set<Day> verticalSeparatorBefore, GanttStyle ganttStyle, boolean hideSaturdayAndSunday) {
        this.colorDays = colorDays;
        this.scale = scale;
        this.min = min2;
        this.max = max;
        this.colorSet = Objects.requireNonNull(colorSet);
        this.ganttStyle = ganttStyle;
        this.locale = locale;
        this.openClose = openClose;
        this.colorDaysOfWeek = colorDaysOfWeek;
        this.verticalSeparatorBefore = verticalSeparatorBefore;
        this.hideSaturdayAndSunday = hideSaturdayAndSunday;
    }

    public HColor getColor(Day wink) {
        return this.colorDays.get(wink);
    }

    public HColor getColor(DayOfWeek dayOfWeek) {
        return this.colorDaysOfWeek.get((Object)dayOfWeek);
    }

    public final double getScale() {
        return this.scale;
    }

    public final Day getMin() {
        return this.min;
    }

    public final Day getMax() {
        return this.max;
    }

    public final HColorSet getColorSet() {
        return this.colorSet;
    }

    public final Style getTimelineStyle() {
        return this.getStyle(SName.timeline);
    }

    public final Style getClosedStyle() {
        return this.getStyle(SName.closed);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final LoadPlanable getLoadPlanable() {
        return this.openClose;
    }

    public Day getStartingDay() {
        return this.openClose.getStartingDay();
    }

    public final Set<Day> getVerticalSeparatorBefore() {
        return this.verticalSeparatorBefore;
    }

    public final UGraphic forVerticalSeparator(UGraphic ug) {
        Style style = this.getStyle(SName.verticalSeparator);
        HColor color = style.value(PName.LineColor).asColor(this.getColorSet());
        UStroke stroke = style.getStroke();
        return ug.apply(color).apply(stroke);
    }

    @Override
    public final Style getStyle(SName param1, SName param2) {
        return this.ganttStyle.getStyle(param1, param2);
    }

    @Override
    public Style getStyle(SName param) {
        return this.ganttStyle.getStyle(param);
    }

    public double getCellWidth(StringBounder stringBounder) {
        double w = this.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return w * 1.6;
    }

    public boolean isHideSaturdayAndSunday() {
        return this.hideSaturdayAndSunday;
    }
}

