/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderMonthly
extends TimeHeaderCalendar {
    private final Map<Day, String> nameDays;

    private double getH1(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble() + 2.0;
        return h2;
    }

    private double getH2(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble() + 2.0;
        return this.getH1(stringBounder) + h2;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH2(stringBounder) + 1.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        double h2 = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble();
        return h1 + h2 + 5.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    public TimeHeaderMonthly(StringBounder stringBounder, TimeHeaderParameters thParam, Map<Day, String> nameDays, Day printStart) {
        super(thParam, new TimeScaleCompressed(thParam.getCellWidth(stringBounder), thParam.getStartingDay(), thParam.getScale(), printStart));
        this.nameDays = nameDays;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        double h1 = this.getH1(ug.getStringBounder());
        double h2 = this.getH2(ug.getStringBounder());
        this.drawMonths(ug.apply(UTranslate.dy(h1)));
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h1);
        this.drawHline(ug, h2);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        double h2 = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble();
        this.drawMonths(ug);
        this.drawYears(ug.apply(UTranslate.dy(h2 + 2.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, h2 + 2.0);
        this.drawHline(ug, h1 + 2.0 + h2 + 2.0);
    }

    private void drawYears(UGraphic ug) {
        double h1 = this.thParam.getStyle(SName.timeline, SName.year).value(PName.FontSize).asDouble();
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h1 + 2.0);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.getMax().increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getEndingPosition(this.getMax()), 0.0, h1 + 2.0);
    }

    private void drawMonths(UGraphic ug) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble();
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, h2 + 2.0);
                if (last != null) {
                    this.printMonth(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.getMax().increment());
        if (x1 > lastChange) {
            this.printMonth(ug, last, lastChange, x1);
        }
        this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getEndingPosition(this.getMax()), 0.0, h2 + 2.0);
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.month, "" + monthYear.year(), true, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.day, monthYear.shortName(this.locale()), false, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.day, monthYear.longName(this.locale()), false, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 6.0;
            return h2;
        }
        return 0.0;
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.getMin();
            while (wink.compareTo(this.getMax().increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(SName.month, name, false, this.openFontColor());
                    double h2 = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight(ug.getStringBounder());
                    double y2 = this.getFullHeaderHeight(ug.getStringBounder());
                    double position = this.getH2(ug.getStringBounder());
                    label.drawU(ug.apply(new UTranslate(x1, position)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }
}

