/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.log.Logme;

public class Cypher {
    private static final Pattern p = Pattern.compile("[\\p{L}\\p{N}]+");
    private final SecureRandom rnd = new SecureRandom();
    private final Map<String, String> convert = new HashMap<String, String>();
    private final Set<String> except = new HashSet<String>();
    private final List<String> words = new ArrayList<String>();

    public Cypher() {
        InputStream is = Cypher.class.getResourceAsStream("words.txt");
        if (is != null) {
            try {
                String s2;
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((s2 = br.readLine()) != null) {
                    if (!s2.matches("[a-z]+")) continue;
                    this.words.add(s2);
                }
                is.close();
            }
            catch (Exception e) {
                Logme.error(e);
            }
        }
        Collections.shuffle(this.words, this.rnd);
    }

    public synchronized String cypher(String s2) {
        Matcher m4 = p.matcher(s2);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            String word = m4.group(0);
            m4.appendReplacement(sb, this.changeWord(word));
        }
        m4.appendTail(sb);
        return sb.toString();
    }

    private String changeWord(String word) {
        String lower = word.toLowerCase();
        if (this.except.contains(lower) || lower.matches("^([a-f0-9]{3}|[a-f0-9]{6})$")) {
            return word;
        }
        String res = this.convert.get(word);
        if (res != null) {
            return res;
        }
        int len = word.length();
        if (len < 4) {
            len = 4;
        }
        while (this.convert.containsValue(res = this.buildRandomWord(len))) {
        }
        this.convert.put(word, res);
        return res;
    }

    private String buildRandomWord(int len) {
        Iterator<String> it = this.words.iterator();
        while (it.hasNext()) {
            String s2 = it.next();
            if (s2.length() != len) continue;
            it.remove();
            return s2;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char letter = (char)(97 + this.rnd.nextInt(26));
            sb.append(letter);
        }
        return sb.toString();
    }

    public void addException(String word) {
        if (this.words.contains(word = word.toLowerCase())) {
            System.err.println("CypherWarning:" + word);
            this.words.remove(word);
        }
        this.except.add(word);
    }
}

