/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigOperatorAtom;
import org.scilab.forge.jlatexmath.BreakMarkAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.CumulativeScriptsAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.FormulaNotFoundException;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.JavaFontRenderingAtom;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.MathAtom;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.UnderscoreAtom;

public class TeXParser {
    TeXFormula formula;
    private StringBuffer parseString;
    private int pos;
    private int spos;
    private int line;
    private int col;
    private int len;
    private int group;
    private boolean insertion;
    private int atIsLetter;
    private boolean arrayMode;
    private boolean ignoreWhiteSpace = true;
    private boolean isPartial;
    private boolean autoNumberBreaking;
    private static final char ESCAPE = '\\';
    private static final char L_GROUP = '{';
    private static final char R_GROUP = '}';
    private static final char L_BRACK = '[';
    private static final char R_BRACK = ']';
    private static final char DOLLAR = '$';
    private static final char DQUOTE = '\"';
    private static final char PERCENT = '%';
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    private static final char SUB_SCRIPT = '_';
    private static final char SUPER_SCRIPT = '^';
    private static final char PRIME = '\'';
    private static final char BACKPRIME = '\u2035';
    private static final char DEGRE = '\u00b0';
    private static final char SUPZERO = '\u2070';
    private static final char SUPONE = '\u00b9';
    private static final char SUPTWO = '\u00b2';
    private static final char SUPTHREE = '\u00b3';
    private static final char SUPFOUR = '\u2074';
    private static final char SUPFIVE = '\u2075';
    private static final char SUPSIX = '\u2076';
    private static final char SUPSEVEN = '\u2077';
    private static final char SUPEIGHT = '\u2078';
    private static final char SUPNINE = '\u2079';
    private static final char SUPPLUS = '\u207a';
    private static final char SUPMINUS = '\u207b';
    private static final char SUPEQUAL = '\u207c';
    private static final char SUPLPAR = '\u207d';
    private static final char SUPRPAR = '\u207e';
    private static final char SUPN = '\u207f';
    private static final char SUBZERO = '\u2080';
    private static final char SUBONE = '\u2081';
    private static final char SUBTWO = '\u2082';
    private static final char SUBTHREE = '\u2083';
    private static final char SUBFOUR = '\u2084';
    private static final char SUBFIVE = '\u2085';
    private static final char SUBSIX = '\u2086';
    private static final char SUBSEVEN = '\u2087';
    private static final char SUBEIGHT = '\u2088';
    private static final char SUBNINE = '\u2089';
    private static final char SUBPLUS = '\u208a';
    private static final char SUBMINUS = '\u208b';
    private static final char SUBEQUAL = '\u208c';
    private static final char SUBLPAR = '\u208d';
    private static final char SUBRPAR = '\u208e';
    protected static boolean isLoading = false;
    private static final Set<String> unparsedContents = new HashSet<String>(6);

    public TeXParser(String parseString, TeXFormula formula) {
        this(parseString, formula, true);
    }

    public TeXParser(boolean isPartial, String parseString, TeXFormula formula) {
        this(parseString, formula, false);
        this.isPartial = isPartial;
        this.firstpass();
    }

    public TeXParser(boolean isPartial, String parseString, TeXFormula formula, boolean firstpass) {
        this.formula = formula;
        this.isPartial = isPartial;
        if (parseString != null) {
            this.parseString = new StringBuffer(parseString);
            this.len = parseString.length();
            this.pos = 0;
            if (firstpass) {
                this.firstpass();
            }
        } else {
            this.parseString = null;
            this.pos = 0;
            this.len = 0;
        }
    }

    public TeXParser(String parseString, TeXFormula formula, boolean firstpass) {
        this(false, parseString, formula, firstpass);
    }

    public TeXParser(boolean isPartial, String parseString, ArrayOfAtoms aoa, boolean firstpass) {
        this(isPartial, parseString, (TeXFormula)aoa, firstpass);
        this.arrayMode = true;
    }

    public TeXParser(boolean isPartial, String parseString, ArrayOfAtoms aoa, boolean firstpass, boolean space) {
        this(isPartial, parseString, (TeXFormula)aoa, firstpass, space);
        this.arrayMode = true;
    }

    public TeXParser(String parseString, ArrayOfAtoms aoa, boolean firstpass) {
        this(false, parseString, (TeXFormula)aoa, firstpass);
    }

    public TeXParser(boolean isPartial, String parseString, TeXFormula formula, boolean firstpass, boolean space) {
        this(isPartial, parseString, formula, firstpass);
        this.ignoreWhiteSpace = space;
    }

    public TeXParser(String parseString, TeXFormula formula, boolean firstpass, boolean space) {
        this(false, parseString, formula, firstpass);
        this.ignoreWhiteSpace = space;
    }

    public void reset(String latex) {
        this.parseString = new StringBuffer(latex);
        this.len = this.parseString.length();
        this.formula.root = null;
        this.pos = 0;
        this.spos = 0;
        this.line = 0;
        this.col = 0;
        this.group = 0;
        this.insertion = false;
        this.atIsLetter = 0;
        this.arrayMode = false;
        this.ignoreWhiteSpace = true;
        this.firstpass();
    }

    public boolean getIsPartial() {
        return this.isPartial;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.pos - this.col - 1;
    }

    public Atom getLastAtom() {
        Atom at = this.formula.root;
        if (at instanceof RowAtom) {
            return ((RowAtom)at).getLastAtom();
        }
        this.formula.root = null;
        return at;
    }

    public Atom getFormulaAtom() {
        Atom at = this.formula.root;
        this.formula.root = null;
        return at;
    }

    public void addAtom(Atom at) {
        this.formula.add(at);
    }

    public void makeAtLetter() {
        ++this.atIsLetter;
    }

    public void makeAtOther() {
        --this.atIsLetter;
    }

    public boolean isAtLetter() {
        return this.atIsLetter != 0;
    }

    public boolean isArrayMode() {
        return this.arrayMode;
    }

    public void setArrayMode(boolean arrayMode) {
        this.arrayMode = arrayMode;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public boolean isMathMode() {
        return this.ignoreWhiteSpace;
    }

    public int getPos() {
        return this.pos;
    }

    public int rewind(int n) {
        this.pos -= n;
        return this.pos;
    }

    public String getStringFromCurrentPos() {
        return this.parseString.substring(this.pos);
    }

    public void finish() {
        this.pos = this.parseString.length();
    }

    public void addRow() throws ParseException {
        if (!this.arrayMode) {
            throw new ParseException("You can add a row only in array mode !");
        }
        ((ArrayOfAtoms)this.formula).addRow();
    }

    /*
     * Unable to fully structure code
     */
    private void firstpass() throws ParseException {
        block52: {
            if (this.len == 0) break block52;
            block42: while (this.pos < this.len) {
                ch = this.parseString.charAt(this.pos);
                switch (ch) {
                    case '\\': {
                        spos = this.pos;
                        com = this.getCommand();
                        if (!"newcommand".equals(com) && !"renewcommand".equals(com)) ** GOTO lbl23
                        args = this.getOptsArgs(2, 2);
                        mac = MacroInfo.Commands.get(com);
                        try {
                            mac.invoke(this, args);
                        }
                        catch (ParseException e) {
                            if (this.isPartial) ** GOTO lbl18
                            throw e;
                        }
lbl18:
                        // 2 sources

                        this.parseString.delete(spos, this.pos);
                        this.len = this.parseString.length();
                        this.pos = spos;
                        continue block42;
lbl23:
                        // 1 sources

                        if (NewCommandMacro.isMacro(com)) {
                            mac = MacroInfo.Commands.get(com);
                            args = this.getOptsArgs(mac.nbArgs, mac.hasOptions != false ? 1 : 0);
                            args[0] = com;
                            try {
                                this.parseString.replace(spos, this.pos, (String)mac.invoke(this, args));
                            }
                            catch (ParseException e) {
                                if (!this.isPartial) {
                                    throw e;
                                }
                                spos += com.length() + 1;
                            }
                            this.len = this.parseString.length();
                            this.pos = spos;
                            continue block42;
                        }
                        if ("begin".equals(com)) {
                            args = this.getOptsArgs(1, 0);
                            mac = MacroInfo.Commands.get(args[1] + "@env");
                            if (mac == null) {
                                if (this.isPartial) continue block42;
                                throw new ParseException("Unknown environment: " + args[1] + " at position " + this.getLine() + ":" + this.getCol());
                            }
                            try {
                                optarg = this.getOptsArgs(mac.nbArgs - 1, 0);
                                grp = this.getGroup("\\begin{" + args[1] + "}", "\\end{" + args[1] + "}");
                                expr = "{\\makeatletter \\" + args[1] + "@env";
                                for (i = 1; i <= mac.nbArgs - 1; ++i) {
                                    expr = expr + "{" + optarg[i] + "}";
                                }
                                expr = expr + "{" + grp + "}\\makeatother}";
                                this.parseString.replace(spos, this.pos, expr);
                                this.len = this.parseString.length();
                                this.pos = spos;
                                continue block42;
                            }
                            catch (ParseException e) {
                                if (this.isPartial) continue block42;
                                throw e;
                            }
                        }
                        if ("makeatletter".equals(com)) {
                            ++this.atIsLetter;
                            continue block42;
                        }
                        if ("makeatother".equals(com)) {
                            --this.atIsLetter;
                            continue block42;
                        }
                        if (!TeXParser.unparsedContents.contains(com)) continue block42;
                        this.getOptsArgs(1, 0);
                        continue block42;
                    }
                    case '%': {
                        ++this.pos;
                        while (this.pos < this.len && (chr = this.parseString.charAt(this.pos++)) != '\r' && chr != '\n') {
                        }
                        if (this.pos < this.len) {
                            --this.pos;
                        }
                        this.parseString.replace(spos, this.pos, "");
                        this.len = this.parseString.length();
                        this.pos = spos;
                        continue block42;
                    }
                    case '\u00b0': {
                        this.parseString.replace(this.pos, this.pos + 1, "^\\circ");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b2': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{2}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b3': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{3}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u00b9': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{1}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2070': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{0}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2074': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{4}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2075': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{5}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2076': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{6}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2077': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{7}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2078': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{8}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2079': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{9}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207a': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{+}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207b': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{-}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207c': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{=}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207d': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{(}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207e': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{)}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u207f': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsup{n}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2082': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{2}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2083': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{3}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2081': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{1}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2080': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{0}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2084': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{4}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2085': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{5}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2086': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{6}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2087': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{7}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2088': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{8}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u2089': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{9}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208a': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{+}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208b': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{-}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208c': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{=}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208d': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{(}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                    case '\u208e': {
                        this.parseString.replace(this.pos, this.pos + 1, "\\jlatexmathcumsub{)}");
                        this.len = this.parseString.length();
                        ++this.pos;
                        continue block42;
                    }
                }
                ++this.pos;
            }
            this.pos = 0;
            this.len = this.parseString.length();
        }
    }

    public void parse() throws ParseException {
        if (this.len != 0) {
            block15: while (this.pos < this.len) {
                char ch = this.parseString.charAt(this.pos);
                block0 : switch (ch) {
                    case '\n': {
                        ++this.line;
                        this.col = this.pos;
                    }
                    case '\t': 
                    case '\r': {
                        ++this.pos;
                        break;
                    }
                    case ' ': {
                        ++this.pos;
                        if (this.ignoreWhiteSpace) continue block15;
                        this.formula.add(new SpaceAtom());
                        this.formula.add(new BreakMarkAtom());
                        while (this.pos < this.len && (ch = this.parseString.charAt(this.pos)) == ' ' && ch == '\t') {
                            if (ch != '\r') break block0;
                            ++this.pos;
                        }
                        continue block15;
                    }
                    case '$': {
                        ++this.pos;
                        if (this.ignoreWhiteSpace) continue block15;
                        int style = 2;
                        boolean doubleDollar = false;
                        if (this.parseString.charAt(this.pos) == '$') {
                            style = 0;
                            doubleDollar = true;
                            ++this.pos;
                        }
                        this.formula.add(new MathAtom(new TeXFormula((TeXParser)this, (String)this.getDollarGroup((char)'$'), (boolean)false).root, style));
                        if (!doubleDollar || this.parseString.charAt(this.pos) != '$') continue block15;
                        ++this.pos;
                        break;
                    }
                    case '\\': {
                        Atom at = this.processEscape();
                        this.formula.add(at);
                        if (this.arrayMode && at instanceof HlineAtom) {
                            ((ArrayOfAtoms)this.formula).addRow();
                        }
                        if (!this.insertion) continue block15;
                        this.insertion = false;
                        break;
                    }
                    case '{': {
                        Atom atom = this.getArgument();
                        if (atom != null) {
                            atom.type = 0;
                        }
                        this.formula.add(atom);
                        break;
                    }
                    case '}': {
                        --this.group;
                        ++this.pos;
                        if (this.group == -1) {
                            throw new ParseException("Found a closing '}' without an opening '{'!");
                        }
                        return;
                    }
                    case '^': {
                        this.formula.add(this.getScripts(ch));
                        break;
                    }
                    case '_': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(this.getScripts(ch));
                            break;
                        }
                        this.formula.add(new UnderscoreAtom());
                        ++this.pos;
                        break;
                    }
                    case '&': {
                        if (!this.arrayMode) {
                            throw new ParseException("Character '&' is only available in array mode !");
                        }
                        ((ArrayOfAtoms)this.formula).addCol();
                        ++this.pos;
                        break;
                    }
                    case '\'': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.formula.add(this.convertCharacter('\'', true));
                        }
                        ++this.pos;
                        break;
                    }
                    case '\u2035': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("backprime")));
                        } else {
                            this.formula.add(this.convertCharacter('\u2035', true));
                        }
                        ++this.pos;
                        break;
                    }
                    case '\"': {
                        if (this.ignoreWhiteSpace) {
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                            this.formula.add(new CumulativeScriptsAtom(this.getLastAtom(), null, SymbolAtom.get("prime")));
                        } else {
                            this.formula.add(this.convertCharacter('\'', true));
                            this.formula.add(this.convertCharacter('\'', true));
                        }
                        ++this.pos;
                        break;
                    }
                    default: {
                        this.formula.add(this.convertCharacter(ch, false));
                        ++this.pos;
                    }
                }
            }
        }
        if (this.formula.root == null && !this.arrayMode) {
            this.formula.add(new EmptyAtom());
        }
    }

    private Atom getScripts(char f) throws ParseException {
        Atom at;
        ++this.pos;
        Atom first = this.getArgument();
        Atom second = null;
        char s = '\u0000';
        if (this.pos < this.len) {
            s = this.parseString.charAt(this.pos);
        }
        if (f == '^' && s == '^') {
            second = first;
            first = null;
        } else if (f == '_' && s == '^') {
            ++this.pos;
            second = this.getArgument();
        } else if (f == '^' && s == '_') {
            ++this.pos;
            second = first;
            first = this.getArgument();
        } else if (f == '^' && s != '_') {
            second = first;
            first = null;
        }
        if (this.formula.root instanceof RowAtom) {
            at = ((RowAtom)this.formula.root).getLastAtom();
        } else if (this.formula.root == null) {
            at = new PhantomAtom(new CharAtom('M', "mathnormal"), false, true, true);
        } else {
            at = this.formula.root;
            this.formula.root = null;
        }
        if (at.getRightType() == 1) {
            return new BigOperatorAtom(at, first, second);
        }
        if (at instanceof OverUnderDelimiter) {
            if (((OverUnderDelimiter)at).isOver()) {
                if (second != null) {
                    ((OverUnderDelimiter)at).addScript(second);
                    return new ScriptsAtom(at, first, null);
                }
            } else if (first != null) {
                ((OverUnderDelimiter)at).addScript(first);
                return new ScriptsAtom(at, null, second);
            }
        }
        return new ScriptsAtom(at, first, second);
    }

    public String getDollarGroup(char openclose) throws ParseException {
        char ch;
        int spos = this.pos;
        do {
            if ((ch = this.parseString.charAt(this.pos++)) != '\\') continue;
            ++this.pos;
        } while (this.pos < this.len && ch != openclose);
        if (ch == openclose) {
            return this.parseString.substring(spos, this.pos - 1);
        }
        return this.parseString.substring(spos, this.pos);
    }

    public String getGroup(char open, char close) throws ParseException {
        if (this.pos == this.len) {
            return null;
        }
        char ch = this.parseString.charAt(this.pos);
        if (this.pos < this.len && ch == open) {
            int group = 1;
            int spos = this.pos;
            while (this.pos < this.len - 1 && group != 0) {
                ++this.pos;
                ch = this.parseString.charAt(this.pos);
                if (ch == open) {
                    ++group;
                    continue;
                }
                if (ch == close) {
                    --group;
                    continue;
                }
                if (ch != '\\' || this.pos == this.len - 1) continue;
                ++this.pos;
            }
            ++this.pos;
            if (group != 0) {
                return this.parseString.substring(spos + 1, this.pos);
            }
            return this.parseString.substring(spos + 1, this.pos - 1);
        }
        throw new ParseException("missing '" + open + "'!");
    }

    public String getGroup(String open, String close) throws ParseException {
        int group = 1;
        int ol = open.length();
        int cl = close.length();
        boolean lastO = this.isValidCharacterInCommand(open.charAt(ol - 1));
        boolean lastC = this.isValidCharacterInCommand(close.charAt(cl - 1));
        int oc = 0;
        int cc = 0;
        int startC = 0;
        char prev = '\u0000';
        StringBuffer buf = new StringBuffer();
        while (this.pos < this.len && group != 0) {
            char c = this.parseString.charAt(this.pos);
            if (prev != '\\' && c == ' ') {
                while (this.pos < this.len && this.parseString.charAt(this.pos++) == ' ') {
                    buf.append(' ');
                }
                c = this.parseString.charAt(--this.pos);
                if (this.isValidCharacterInCommand(prev) && this.isValidCharacterInCommand(c)) {
                    cc = 0;
                    oc = 0;
                }
            }
            oc = c == open.charAt(oc) ? ++oc : 0;
            if (c == close.charAt(cc)) {
                if (cc == 0) {
                    startC = this.pos;
                }
                ++cc;
            } else {
                cc = 0;
            }
            if (this.pos + 1 < this.len) {
                char c1 = this.parseString.charAt(this.pos + 1);
                if (oc == ol) {
                    if (!lastO || !this.isValidCharacterInCommand(c1)) {
                        ++group;
                    }
                    oc = 0;
                }
                if (cc == cl) {
                    if (!lastC || !this.isValidCharacterInCommand(c1)) {
                        --group;
                    }
                    cc = 0;
                }
            } else {
                if (oc == ol) {
                    ++group;
                    oc = 0;
                }
                if (cc == cl) {
                    --group;
                    cc = 0;
                }
            }
            prev = c;
            buf.append(c);
            ++this.pos;
        }
        if (group != 0) {
            if (this.isPartial) {
                return buf.toString();
            }
            throw new ParseException("The token " + open + " must be closed by " + close);
        }
        return buf.substring(0, buf.length() - this.pos + startC);
    }

    public Atom getArgument() throws ParseException {
        this.skipWhiteSpace();
        if (this.pos >= this.len) {
            return new EmptyAtom();
        }
        char ch = this.parseString.charAt(this.pos);
        if (ch == '{') {
            TeXFormula tf = new TeXFormula();
            TeXFormula sformula = this.formula;
            this.formula = tf;
            ++this.pos;
            ++this.group;
            this.parse();
            this.formula = sformula;
            if (this.formula.root == null) {
                RowAtom at = new RowAtom();
                at.add(tf.root);
                return at;
            }
            return tf.root;
        }
        if (ch == '\\') {
            Atom at = this.processEscape();
            if (this.insertion) {
                this.insertion = false;
                return this.getArgument();
            }
            return at;
        }
        Atom at = this.convertCharacter(ch, true);
        ++this.pos;
        return at;
    }

    public String getOverArgument() throws ParseException {
        String str;
        if (this.pos == this.len) {
            return null;
        }
        int ogroup = 1;
        char ch = '\u0000';
        int spos = this.pos;
        while (this.pos < this.len && ogroup != 0) {
            ch = this.parseString.charAt(this.pos);
            switch (ch) {
                case '{': {
                    ++ogroup;
                    break;
                }
                case '&': {
                    if (ogroup != 1) break;
                    --ogroup;
                    break;
                }
                case '}': {
                    --ogroup;
                    break;
                }
                case '\\': {
                    ++this.pos;
                    if (this.pos < this.len && this.parseString.charAt(this.pos) == '\\' && ogroup == 1) {
                        --ogroup;
                        --this.pos;
                        break;
                    }
                    if (this.pos >= this.len - 1 || this.parseString.charAt(this.pos) != 'c' || this.parseString.charAt(this.pos + 1) != 'r' || ogroup != 1) break;
                    --ogroup;
                    --this.pos;
                }
            }
            ++this.pos;
        }
        if (ogroup >= 2) {
            throw new ParseException("Illegal end,  missing '}' !");
        }
        if (ogroup == 0) {
            str = this.parseString.substring(spos, this.pos - 1);
        } else {
            str = this.parseString.substring(spos, this.pos);
            ch = '\u0000';
        }
        if (ch == '&' || ch == '\\' || ch == '}') {
            --this.pos;
        }
        return str;
    }

    public float[] getLength() throws ParseException {
        if (this.pos == this.len) {
            return null;
        }
        boolean ogroup = true;
        int ch = 0;
        this.skipWhiteSpace();
        int spos = this.pos;
        while (this.pos < this.len && ch != 32) {
            ch = this.parseString.charAt(this.pos++);
        }
        this.skipWhiteSpace();
        return SpaceAtom.getLength(this.parseString.substring(spos, this.pos - 1));
    }

    public Atom convertCharacter(char c, boolean oneChar) throws ParseException {
        if (this.ignoreWhiteSpace) {
            if (c >= '\u03b1' && c <= '\u03c9') {
                return SymbolAtom.get(TeXFormula.symbolMappings[c]);
            }
            if (c >= '\u0391' && c <= '\u03a9') {
                return new TeXFormula((String)TeXFormula.symbolFormulaMappings[c]).root;
            }
        }
        if (!((c = TeXParser.convertToRomanNumber(c)) >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            String symbolName;
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (!isLoading && !DefaultTeXFont.loadedAlphabets.contains(block)) {
                DefaultTeXFont.addAlphabet(DefaultTeXFont.registeredAlphabets.get(block));
            }
            if ((symbolName = TeXFormula.symbolMappings[c]) == null && (TeXFormula.symbolFormulaMappings == null || TeXFormula.symbolFormulaMappings[c] == null)) {
                TeXFormula.FontInfos fontInfos = null;
                boolean isLatin = Character.UnicodeBlock.BASIC_LATIN.equals(block);
                if (isLatin && TeXFormula.isRegisteredBlock(Character.UnicodeBlock.BASIC_LATIN) || !isLatin) {
                    fontInfos = TeXFormula.getExternalFont(block);
                }
                if (fontInfos != null) {
                    if (oneChar) {
                        return new JavaFontRenderingAtom(Character.toString(c), fontInfos);
                    }
                    int start = this.pos++;
                    int end = this.len - 1;
                    while (this.pos < this.len) {
                        c = this.parseString.charAt(this.pos);
                        if (!Character.UnicodeBlock.of(c).equals(block)) {
                            end = --this.pos;
                            break;
                        }
                        ++this.pos;
                    }
                    return new JavaFontRenderingAtom(this.parseString.substring(start, end + 1), fontInfos);
                }
                if (!this.isPartial) {
                    throw new ParseException("Unknown character : '" + Character.toString(c) + "' (or " + c + ")");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\text{(Unknown char ").append((int)c).append((String)")}").toString()).root), null, Color.RED);
            }
            if (!this.ignoreWhiteSpace && TeXFormula.symbolTextMappings[c] != null) {
                return SymbolAtom.get(TeXFormula.symbolTextMappings[c]).setUnicode(c);
            }
            if (TeXFormula.symbolFormulaMappings != null && TeXFormula.symbolFormulaMappings[c] != null) {
                return new TeXFormula((String)TeXFormula.symbolFormulaMappings[c]).root;
            }
            try {
                return SymbolAtom.get(symbolName);
            }
            catch (SymbolNotFoundException e) {
                throw new ParseException("The character '" + Character.toString(c) + "' was mapped to an unknown symbol with the name '" + symbolName + "'!", e);
            }
        }
        TeXFormula.FontInfos fontInfos = TeXFormula.externalFontMap.get(Character.UnicodeBlock.BASIC_LATIN);
        if (fontInfos != null) {
            if (oneChar) {
                return new JavaFontRenderingAtom(Character.toString(c), fontInfos);
            }
            int start = this.pos++;
            int end = this.len - 1;
            while (this.pos < this.len) {
                c = this.parseString.charAt(this.pos);
                if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    end = --this.pos;
                    break;
                }
                ++this.pos;
            }
            return new JavaFontRenderingAtom(this.parseString.substring(start, end + 1), fontInfos);
        }
        return new CharAtom(c, this.formula.textStyle);
    }

    private String getCommand() {
        String com;
        int spos = ++this.pos;
        char ch = '\u0000';
        while (this.pos < this.len && ((ch = this.parseString.charAt(this.pos)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || this.atIsLetter != 0 && ch == '@')) {
            ++this.pos;
        }
        if (ch == '\u0000') {
            return "";
        }
        if (this.pos == spos) {
            ++this.pos;
        }
        if ("cr".equals(com = this.parseString.substring(spos, this.pos)) && this.pos < this.len && this.parseString.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return com;
    }

    private Atom processEscape() throws ParseException {
        this.spos = this.pos;
        String command = this.getCommand();
        if (command.length() == 0) {
            return new EmptyAtom();
        }
        if (MacroInfo.Commands.get(command) != null) {
            return this.processCommands(command);
        }
        try {
            return TeXFormula.get((String)command).root;
        }
        catch (FormulaNotFoundException e) {
            try {
                return SymbolAtom.get(command);
            }
            catch (SymbolNotFoundException symbolNotFoundException) {
                if (!this.isPartial) {
                    throw new ParseException("Unknown symbol or command or predefined TeXFormula: '" + command + "'");
                }
                return new ColorAtom(new RomanAtom(new TeXFormula((String)new StringBuilder().append((String)"\\backslash ").append((String)command).toString()).root), null, Color.RED);
            }
        }
    }

    private void insert(int beg, int end, String formula) {
        this.parseString.replace(beg, end, formula);
        this.len = this.parseString.length();
        this.pos = beg;
        this.insertion = true;
    }

    public String[] getOptsArgs(int nbArgs, int opts) {
        String[] args = new String[nbArgs + 10 + 1];
        if (nbArgs != 0) {
            if (opts == 1) {
                try {
                    for (int j = nbArgs + 1; j < nbArgs + 11; ++j) {
                        this.skipWhiteSpace();
                        args[j] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException e) {
                    args[j] = null;
                }
            }
            this.skipWhiteSpace();
            try {
                args[1] = this.getGroup('{', '}');
            }
            catch (ParseException e) {
                if (this.parseString.charAt(this.pos) != '\\') {
                    args[1] = "" + this.parseString.charAt(this.pos);
                    ++this.pos;
                }
                args[1] = this.getCommandWithArgs(this.getCommand());
            }
            if (opts == 2) {
                try {
                    for (int j = nbArgs + 1; j < nbArgs + 11; ++j) {
                        this.skipWhiteSpace();
                        args[j] = this.getGroup('[', ']');
                    }
                }
                catch (ParseException e) {
                    args[j] = null;
                }
            }
            for (int i = 2; i <= nbArgs; ++i) {
                this.skipWhiteSpace();
                try {
                    args[i] = this.getGroup('{', '}');
                    continue;
                }
                catch (ParseException e) {
                    if (this.parseString.charAt(this.pos) != '\\') {
                        args[i] = "" + this.parseString.charAt(this.pos);
                        ++this.pos;
                        continue;
                    }
                    args[i] = this.getCommandWithArgs(this.getCommand());
                }
            }
            if (this.ignoreWhiteSpace) {
                this.skipWhiteSpace();
            }
        }
        return args;
    }

    private String getCommandWithArgs(String command) {
        if (command.equals("left")) {
            return this.getGroup("\\left", "\\right");
        }
        MacroInfo mac = MacroInfo.Commands.get(command);
        if (mac != null) {
            String arg_t;
            int j;
            int mac_opts = 0;
            if (mac.hasOptions) {
                mac_opts = mac.posOpts;
            }
            String[] mac_args = this.getOptsArgs(mac.nbArgs, mac_opts);
            StringBuffer mac_arg = new StringBuffer("\\");
            mac_arg.append(command);
            for (j = 0; j < mac.posOpts; ++j) {
                arg_t = mac_args[mac.nbArgs + j + 1];
                if (arg_t == null) continue;
                mac_arg.append("[").append(arg_t).append("]");
            }
            for (j = 0; j < mac.nbArgs; ++j) {
                arg_t = mac_args[j + 1];
                if (arg_t == null) continue;
                mac_arg.append("{").append(arg_t).append("}");
            }
            return mac_arg.toString();
        }
        return "\\" + command;
    }

    private Atom processCommands(String command) throws ParseException {
        MacroInfo mac = MacroInfo.Commands.get(command);
        int opts = 0;
        if (mac.hasOptions) {
            opts = mac.posOpts;
        }
        String[] args = this.getOptsArgs(mac.nbArgs, opts);
        args[0] = command;
        if (NewCommandMacro.isMacro(command)) {
            String ret = (String)mac.invoke(this, args);
            this.insert(this.spos, this.pos, ret);
            return null;
        }
        return (Atom)mac.invoke(this, args);
    }

    public final boolean isValidName(String com) {
        if (com == null || "".equals(com)) {
            return false;
        }
        char c = '\u0000';
        if (com.charAt(0) == '\\') {
            int len = com.length();
            for (int pos = 1; pos < len && (Character.isLetter(c = com.charAt(pos)) || this.atIsLetter != 0 && c == '@'); ++pos) {
            }
        } else {
            return false;
        }
        return Character.isLetter(c);
    }

    public final boolean isValidCharacterInCommand(char ch) {
        return Character.isLetter(ch) || this.atIsLetter != 0 && ch == '@';
    }

    private final void skipWhiteSpace() {
        char c;
        while (this.pos < this.len && ((c = this.parseString.charAt(this.pos)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            if (c == '\n') {
                ++this.line;
                this.col = this.pos;
            }
            ++this.pos;
        }
    }

    private static char convertToRomanNumber(char c) {
        if (c == '\u066b') {
            return '.';
        }
        if ('\u0660' <= c && c <= '\u0669') {
            return (char)(c - 1584);
        }
        if ('\u06f0' <= c && c <= '\u06f9') {
            return (char)(c - 1728);
        }
        if ('\u0966' <= c && c <= '\u096f') {
            return (char)(c - 2358);
        }
        if ('\u09e6' <= c && c <= '\u09ef') {
            return (char)(c - 2486);
        }
        if ('\u0a66' <= c && c <= '\u0a6f') {
            return (char)(c - 2614);
        }
        if ('\u0ae6' <= c && c <= '\u0aef') {
            return (char)(c - 2742);
        }
        if ('\u0b66' <= c && c <= '\u0b6f') {
            return (char)(c - 2870);
        }
        if ('\u0c66' <= c && c <= '\u0c6f') {
            return (char)(c - 3126);
        }
        if ('\u0d66' <= c && c <= '\u0d6f') {
            return (char)(c - 3382);
        }
        if ('\u0e50' <= c && c <= '\u0e59') {
            return (char)(c - 3616);
        }
        if ('\u0ed0' <= c && c <= '\u0ed9') {
            return (char)(c - 3744);
        }
        if ('\u0f20' <= c && c <= '\u0f29') {
            return (char)(c - 3728);
        }
        if ('\u1040' <= c && c <= '\u1049') {
            return (char)(c - 4112);
        }
        if ('\u17e0' <= c && c <= '\u17e9') {
            return (char)(c - 6064);
        }
        if ('\u1810' <= c && c <= '\u1819') {
            return (char)(c - 6112);
        }
        if ('\u1b50' <= c && c <= '\u1b59') {
            return (char)(c - 6944);
        }
        if ('\u1bb0' <= c && c <= '\u1bb9') {
            return (char)(c - 7040);
        }
        if ('\u1c40' <= c && c <= '\u1c49') {
            return (char)(c - 7184);
        }
        if ('\u1c50' <= c && c <= '\u1c59') {
            return (char)(c - 7200);
        }
        if ('\ua8d0' <= c && c <= '\ua8d9') {
            return (char)(c - 43168);
        }
        return c;
    }

    static {
        unparsedContents.add("jlmDynamic");
        unparsedContents.add("jlmText");
        unparsedContents.add("jlmTextit");
        unparsedContents.add("jlmTextbf");
        unparsedContents.add("jlmTextitbf");
        unparsedContents.add("jlmExternalFont");
    }
}

