/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorExAdapter;

public class MaximumModalDepthFinder
extends OWLObjectVisitorExAdapter<Integer> {
    @Nonnull
    private static final Integer _1 = MaximumModalDepthFinder.i(1);

    @Nonnull
    static Integer i(int b) {
        return b;
    }

    public MaximumModalDepthFinder() {
        super(MaximumModalDepthFinder.i(0));
    }

    @Override
    public Integer visit(OWLSubClassOfAxiom axiom) {
        int subClassModalDepth = axiom.getSubClass().accept(this);
        int superClassModalDepth = axiom.getSuperClass().accept(this);
        return MaximumModalDepthFinder.i(Math.max(subClassModalDepth, superClassModalDepth));
    }

    @Override
    public Integer visit(OWLOntology ontology) {
        int max = 0;
        for (OWLAxiom oWLAxiom : ontology.getLogicalAxioms()) {
            int depth = oWLAxiom.accept(this);
            if (depth <= max) continue;
            max = depth;
        }
        return MaximumModalDepthFinder.i(max);
    }

    @Override
    public Integer visit(OWLObjectIntersectionOf ce) {
        int max = 0;
        for (OWLClassExpression op : ce.getOperands()) {
            int depth = op.accept(this);
            if (depth <= max) continue;
            max = depth;
        }
        return MaximumModalDepthFinder.i(max);
    }

    @Override
    public Integer visit(OWLObjectUnionOf ce) {
        int max = 0;
        for (OWLClassExpression op : ce.getOperands()) {
            int depth = op.accept(this);
            if (depth <= max) continue;
            max = depth;
        }
        return MaximumModalDepthFinder.i(max);
    }

    @Override
    public Integer visit(OWLObjectComplementOf ce) {
        return ce.getOperand().accept(this);
    }

    @Override
    public Integer visit(OWLObjectSomeValuesFrom ce) {
        return MaximumModalDepthFinder.i(1 + ((OWLClassExpression)ce.getFiller()).accept(this));
    }

    @Override
    public Integer visit(OWLObjectAllValuesFrom ce) {
        return MaximumModalDepthFinder.i(1 + ((OWLClassExpression)ce.getFiller()).accept(this));
    }

    @Override
    public Integer visit(OWLDisjointClassesAxiom axiom) {
        int max = 0;
        for (OWLClassExpression ce : axiom.getClassExpressions()) {
            int depth = ce.accept(this);
            if (depth <= max) continue;
            max = depth;
        }
        return MaximumModalDepthFinder.i(max);
    }

    @Override
    public Integer visit(OWLDataPropertyDomainAxiom axiom) {
        return axiom.getDomain().accept(this);
    }

    @Override
    public Integer visit(OWLObjectMinCardinality ce) {
        return MaximumModalDepthFinder.i(1 + ((OWLClassExpression)ce.getFiller()).accept(this));
    }

    @Override
    public Integer visit(OWLObjectPropertyDomainAxiom axiom) {
        return axiom.getDomain().accept(this);
    }

    @Override
    public Integer visit(OWLObjectExactCardinality ce) {
        return MaximumModalDepthFinder.i(1 + ((OWLClassExpression)ce.getFiller()).accept(this));
    }

    @Override
    public Integer visit(OWLObjectMaxCardinality ce) {
        return MaximumModalDepthFinder.i(1 + ((OWLClassExpression)ce.getFiller()).accept(this));
    }

    @Override
    public Integer visit(OWLObjectHasSelf ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataSomeValuesFrom ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataAllValuesFrom ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataHasValue ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataMinCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataExactCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLDataMaxCardinality ce) {
        return _1;
    }

    @Override
    public Integer visit(OWLClassAssertionAxiom axiom) {
        return axiom.getClassExpression().accept(this);
    }

    @Override
    public Integer visit(OWLEquivalentClassesAxiom axiom) {
        int max = 0;
        for (OWLClassExpression ce : axiom.getClassExpressions()) {
            int depth = ce.accept(this);
            if (depth <= max) continue;
            max = depth;
        }
        return MaximumModalDepthFinder.i(max);
    }
}

