/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_WS = "Samoa";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "arab\u0173";
        final String metaValue_hy = "arm\u0117n\u0173";
        final String metaValue_bn = "bengal\u0173";
        final String metaValue_bug = "buginez\u0173";
        final String metaValue_chr = "\u010deroki\u0173";
        final String metaValue_cop = "kopt\u0173";
        final String metaValue_ka = "gruzin\u0173";
        final String metaValue_got = "got\u0173";
        final String metaValue_el = "graik\u0173";
        final String metaValue_gu = "gud\u017earat\u0173";
        final String metaValue_he = "hebraj\u0173";
        final String metaValue_jv = "javie\u010di\u0173";
        final String metaValue_ja = "japon\u0173";
        final String metaValue_km = "khmer\u0173";
        final String metaValue_kn = "kanad\u0173";
        final String metaValue_ko = "kor\u0117jie\u010di\u0173";
        final String metaValue_lo = "laosie\u010di\u0173";
        final String metaValue_la = "lotyn\u0173";
        final String metaValue_ml = "malajali\u0173";
        final String metaValue_mn = "mongol\u0173";
        final String metaValue_my = "birmie\u010di\u0173";
        final String metaValue_nqo = "enko";
        final String metaValue_si = "sinhal\u0173";
        final String metaValue_su = "sund\u0173";
        final String metaValue_syr = "sir\u0173";
        final String metaValue_ta = "tamil\u0173";
        final String metaValue_te = "telug\u0173";
        final String metaValue_tl = "tagalog\u0173";
        final String metaValue_th = "taj\u0173";
        final String metaValue_bo = "tibetie\u010di\u0173";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "001", "pasaulis" },
            { "002", "Afrika" },
            { "003", "\u0160iaur\u0117s Amerika" },
            { "005", "Piet\u0173 Amerika" },
            { "009", "Okeanija" },
            { "011", "Vakar\u0173 Afrika" },
            { "013", "Centrin\u0117 Amerika" },
            { "014", "Ryt\u0173 Afrika" },
            { "015", "\u0160iaur\u0117s Afrika" },
            { "017", "Vidurio Afrika" },
            { "018", "Pietin\u0117 Afrika" },
            { "019", "Amerika" },
            { "021", "\u0160iaurin\u0117 Amerika" },
            { "029", "Karibai" },
            { "030", "Ryt\u0173 Azija" },
            { "034", "Piet\u0173 Azija" },
            { "035", "Pietry\u010di\u0173 Azija" },
            { "039", "Piet\u0173 Europa" },
            { "053", "Australazija" },
            { "054", "Melanezija" },
            { "057", "Mikronezijos regionas" },
            { "061", "Polinezija" },
            { "142", "Azija" },
            { "143", "Centrin\u0117 Azija" },
            { "145", "Vakar\u0173 Azija" },
            { "150", "Europa" },
            { "151", "Ryt\u0173 Europa" },
            { "154", "\u0160iaur\u0117s Europa" },
            { "155", "Vakar\u0173 Europa" },
            { "202", "U\u017esachario Afrika" },
            { "419", "Lotyn\u0173 Amerika" },
            { "AC", "Dangun \u017dengimo sala" },
            { "AD", "Andora" },
            { "AE", "Jungtiniai Arab\u0173 Emyratai" },
            { "AF", "Afganistanas" },
            { "AG", "Antigva ir Barbuda" },
            { "AI", "Angilija" },
            { "AL", "Albanija" },
            { "AM", "Arm\u0117nija" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Amerikos Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Aland\u0173 Salos" },
            { "AZ", "Azerbaid\u017eanas" },
            { "BA", "Bosnija ir Hercegovina" },
            { "BB", "Barbadosas" },
            { "BD", "Banglade\u0161as" },
            { "BE", "Belgija" },
            { "BF", "Burkina Fasas" },
            { "BG", "Bulgarija" },
            { "BH", "Bahreinas" },
            { "BI", "Burundis" },
            { "BJ", "Beninas" },
            { "BL", "Sen Bartelemi" },
            { "BM", "Bermuda" },
            { "BN", "Brun\u0117jus" },
            { "BO", "Bolivija" },
            { "BQ", "Karib\u0173 Nyderlandai" },
            { "BR", "Brazilija" },
            { "BS", "Bahamos" },
            { "BT", "Butanas" },
            { "BV", "Buv\u0117 Sala" },
            { "BW", "Botsvana" },
            { "BY", "Baltarusija" },
            { "BZ", "Belizas" },
            { "CA", "Kanada" },
            { "CC", "Kokos\u0173 (Kilingo) Salos" },
            { "CD", "Kongas-Kin\u0161asa" },
            { "CF", "Centrin\u0117s Afrikos Respublika" },
            { "CG", "Kongas-Brazavilis" },
            { "CH", "\u0160veicarija" },
            { "CI", "Dramblio Kaulo Krantas" },
            { "CK", "Kuko Salos" },
            { "CL", "\u010cil\u0117" },
            { "CM", "Kamer\u016bnas" },
            { "CN", "Kinija" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertono sala" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "\u017daliasis Ky\u0161ulys" },
            { "CW", "Kiurasao" },
            { "CX", "Kal\u0117d\u0173 Sala" },
            { "CY", "Kipras" },
            { "CZ", "\u010cekija" },
            { "DE", "Vokietija" },
            { "DG", "Diego Garsija" },
            { "DJ", "D\u017eibutis" },
            { "DK", "Danija" },
            { "DM", "Dominika" },
            { "DO", "Dominikos Respublika" },
            { "DZ", "Al\u017eyras" },
            { "EA", "Seuta ir Melila" },
            { "EC", "Ekvadoras" },
            { "EE", "Estija" },
            { "EG", "Egiptas" },
            { "EH", "Vakar\u0173 Sachara" },
            { "ER", "Eritr\u0117ja" },
            { "ES", "Ispanija" },
            { "ET", "Etiopija" },
            { "EU", "Europos S\u0105junga" },
            { "EZ", "euro zona" },
            { "FI", "Suomija" },
            { "FJ", "Fid\u017eis" },
            { "FK", "Folklando Salos" },
            { "FM", "Mikronezija" },
            { "FO", "Farer\u0173 Salos" },
            { "FR", "Pranc\u016bzija" },
            { "GA", "Gabonas" },
            { "GB", "Jungtin\u0117 Karalyst\u0117" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Pranc\u016bzijos Gviana" },
            { "GG", "Gernsis" },
            { "GH", "Gana" },
            { "GI", "Gibraltaras" },
            { "GL", "Grenlandija" },
            { "GM", "Gambija" },
            { "GN", "Gvin\u0117ja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Pusiaujo Gvin\u0117ja" },
            { "GR", "Graikija" },
            { "GS", "Piet\u0173 D\u017eord\u017eija ir Piet\u0173 Sandvi\u010do salos" },
            { "GT", "Gvatemala" },
            { "GU", "Guamas" },
            { "GW", "Bisau Gvin\u0117ja" },
            { "GY", "Gajana" },
            { "HK", "Ypatingasis Administracinis Kinijos Regionas Honkongas" },
            { "HM", "Herdo ir Makdonaldo Salos" },
            { "HN", "Hond\u016bras" },
            { "HR", "Kroatija" },
            { "HT", "Haitis" },
            { "HU", "Vengrija" },
            { "IC", "Kanar\u0173 salos" },
            { "ID", "Indonezija" },
            { "IE", "Airija" },
            { "IL", "Izraelis" },
            { "IM", "Meno Sala" },
            { "IN", "Indija" },
            { "IO", "Indijos Vandenyno Brit\u0173 Sritis" },
            { "IQ", "Irakas" },
            { "IR", "Iranas" },
            { "IS", "Islandija" },
            { "IT", "Italija" },
            { "JE", "D\u017eersis" },
            { "JM", "Jamaika" },
            { "JO", "Jordanija" },
            { "JP", "Japonija" },
            { "KE", "Kenija" },
            { "KG", "Kirgizija" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribatis" },
            { "KM", "Komorai" },
            { "KN", "Sent Kitsas ir Nevis" },
            { "KP", "\u0160iaur\u0117s Kor\u0117ja" },
            { "KR", "Piet\u0173 Kor\u0117ja" },
            { "KW", "Kuveitas" },
            { "KY", "Kaiman\u0173 Salos" },
            { "KZ", "Kazachstanas" },
            { "LA", "Laosas" },
            { "LB", "Libanas" },
            { "LC", "Sent Lusija" },
            { "LI", "Lichten\u0161teinas" },
            { "LK", "\u0160ri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesotas" },
            { "LT", "Lietuva" },
            { "LU", "Liuksemburgas" },
            { "LV", "Latvija" },
            { "LY", "Libija" },
            { "MA", "Marokas" },
            { "MC", "Monakas" },
            { "MD", "Moldova" },
            { "ME", "Juodkalnija" },
            { "MF", "Sen Martenas" },
            { "MG", "Madagaskaras" },
            { "MH", "Mar\u0161alo Salos" },
            { "MK", "\u0160iaur\u0117s Makedonija" },
            { "ML", "Malis" },
            { "MM", "Mianmaras (Birma)" },
            { "MN", "Mongolija" },
            { "MO", "Ypatingasis Administracinis Kinijos Regionas Makao" },
            { "MP", "Marianos \u0160iaurin\u0117s Salos" },
            { "MQ", "Martinika" },
            { "MR", "Mauritanija" },
            { "MS", "Montseratas" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "MV", "Maldyvai" },
            { "MW", "Malavis" },
            { "MX", "Meksika" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambikas" },
            { "NA", "Namibija" },
            { "NC", "Naujoji Kaledonija" },
            { "NE", "Nigeris" },
            { "NF", "Norfolko sala" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragva" },
            { "NL", "Nyderlandai" },
            { "NO", "Norvegija" },
            { "NP", "Nepalas" },
            { "NR", "Nauru" },
            { "NU", "Niuj\u0117" },
            { "NZ", "Naujoji Zelandija" },
            { "OM", "Omanas" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Pranc\u016bzijos Polinezija" },
            { "PG", "Papua Naujoji Gvin\u0117ja" },
            { "PH", "Filipinai" },
            { "PK", "Pakistanas" },
            { "PL", "Lenkija" },
            { "PM", "Sen Pjeras ir Mikelonas" },
            { "PN", "Pitkerno salos" },
            { "PR", "Puerto Rikas" },
            { "PS", "Palestinos teritorija" },
            { "PT", "Portugalija" },
            { "PW", "Palau" },
            { "PY", "Paragvajus" },
            { "QA", "Kataras" },
            { "QO", "Nuo\u0161ali Okeanija" },
            { "RE", "Reunjonas" },
            { "RO", "Rumunija" },
            { "RS", "Serbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "SA", "Saudo Arabija" },
            { "SB", "Saliamono Salos" },
            { "SC", "Sei\u0161eliai" },
            { "SD", "Sudanas" },
            { "SE", "\u0160vedija" },
            { "SG", "Singap\u016bras" },
            { "SH", "\u0160v. Elenos Sala" },
            { "SI", "Slov\u0117nija" },
            { "SJ", "Svalbardas ir Janas Majenas" },
            { "SK", "Slovakija" },
            { "SL", "Siera Leon\u0117" },
            { "SM", "San Marinas" },
            { "SN", "Senegalas" },
            { "SO", "Somalis" },
            { "SR", "Surinamas" },
            { "SS", "Piet\u0173 Sudanas" },
            { "ST", "San Tom\u0117 ir Prinsip\u0117" },
            { "SV", "Salvadoras" },
            { "SX", "Sint Martenas" },
            { "SY", "Sirija" },
            { "SZ", "Svazilandas" },
            { "TA", "Tristano da Kunjos" },
            { "TC", "Terkso ir Kaikoso Salos" },
            { "TD", "\u010cadas" },
            { "TF", "Pranc\u016bzijos Piet\u0173 sritys" },
            { "TG", "Togas" },
            { "TH", "Tailandas" },
            { "TJ", "Tad\u017eikija" },
            { "TK", metaValue_TK },
            { "TL", "Ryt\u0173 Timoras" },
            { "TM", "Turkm\u0117nistanas" },
            { "TN", "Tunisas" },
            { "TO", "Tonga" },
            { "TR", "Turkija" },
            { "TT", "Trinidadas ir Tobagas" },
            { "TV", metaValue_TV },
            { "TW", "Taivanas" },
            { "TZ", "Tanzanija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Jungtini\u0173 Valstij\u0173 Ma\u017eosios Tolimosios Salos" },
            { "UN", "Jungtin\u0117s Tautos" },
            { "US", "Jungtin\u0117s Valstijos" },
            { "UY", "Urugvajus" },
            { "UZ", "Uzbekistanas" },
            { "VA", "Vatikano Miesto Valstyb\u0117" },
            { "VC", "\u0160ventasis Vincentas ir Grenadinai" },
            { "VE", "Venesuela" },
            { "VG", "Did\u017eiosios Britanijos Mergeli\u0173 Salos" },
            { "VI", "Jungtini\u0173 Valstij\u0173 Mergeli\u0173 Salos" },
            { "VN", "Vietnamas" },
            { "VU", "Vanuatu" },
            { "WF", "Volisas ir Fut\u016bna" },
            { "WS", metaValue_WS },
            { "XA", "pseudo A" },
            { "XB", "pseudo B" },
            { "XK", "Kosovas" },
            { "YE", "Jemenas" },
            { "YT", "Majotas" },
            { "ZA", "Piet\u0173 Afrika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabv\u0117" },
            { "ZZ", "ne\u017einoma sritis" },
            { "aa", "afar\u0173" },
            { "ab", "abchaz\u0173" },
            { "ae", "avest\u0173" },
            { "af", "afrikan\u0173" },
            { "ak", "akan\u0173" },
            { "am", "amhar\u0173" },
            { "an", "aragones\u0173" },
            { "ar", metaValue_ar },
            { "as", "asam\u0173" },
            { "av", "avarik\u0173" },
            { "ay", "aimar\u0173" },
            { "az", "azerbaid\u017eanie\u010di\u0173" },
            { "ba", "ba\u0161kir\u0173" },
            { "be", "baltarusi\u0173" },
            { "bg", "bulgar\u0173" },
            { "bi", "bislama" },
            { "bm", "bambar\u0173" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton\u0173" },
            { "bs", "bosni\u0173" },
            { "ca", "katalon\u0173" },
            { "ce", "\u010de\u010d\u0117n\u0173" },
            { "ch", "\u010damor\u0173" },
            { "co", "korsikie\u010di\u0173" },
            { "cr", "kry" },
            { "cs", "\u010dek\u0173" },
            { "cu", "ba\u017enytin\u0117 slav\u0173" },
            { "cv", "\u010diuva\u0161\u0173" },
            { "cy", "val\u0173" },
            { "da", "dan\u0173" },
            { "de", "vokie\u010di\u0173" },
            { "dv", "diveh\u0173" },
            { "dz", "botij\u0173" },
            { "ee", "evi\u0173" },
            { "el", metaValue_el },
            { "en", "angl\u0173" },
            { "eo", "esperanto" },
            { "es", "ispan\u0173" },
            { "et", "est\u0173" },
            { "eu", "bask\u0173" },
            { "fa", "pers\u0173" },
            { "ff", "fulah\u0173" },
            { "fi", "suomi\u0173" },
            { "fj", "fid\u017ei\u0173" },
            { "fo", "farer\u0173" },
            { "fr", "pranc\u016bz\u0173" },
            { "fy", "vakar\u0173 fryz\u0173" },
            { "ga", "airi\u0173" },
            { "gd", "\u0161kot\u0173 (g\u0117l\u0173)" },
            { "gl", "galis\u0173" },
            { "gn", "gvarani\u0173" },
            { "gu", metaValue_gu },
            { "gv", "menie\u010di\u0173" },
            { "ha", "haus\u0173" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "kroat\u0173" },
            { "ht", "Hai\u010dio" },
            { "hu", "vengr\u0173" },
            { "hy", metaValue_hy },
            { "hz", "herer\u0173" },
            { "ia", "tarpin\u0117" },
            { "id", "indonezie\u010di\u0173" },
            { "ie", "interkalba" },
            { "ig", "igb\u0173" },
            { "ii", "si\u010duan ji" },
            { "ik", "inupiak\u0173" },
            { "io", "ido" },
            { "is", "island\u0173" },
            { "it", "ital\u0173" },
            { "iu", "inukitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "kikuj\u0173" },
            { "kj", "kuaniama" },
            { "kk", "kazach\u0173" },
            { "kl", "kalalisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri\u0173" },
            { "ks", "ka\u0161myr\u0173" },
            { "ku", "kurd\u0173" },
            { "kv", "komi" },
            { "kw", "korn\u0173" },
            { "ky", "kirgiz\u0173" },
            { "la", metaValue_la },
            { "lb", "liuksemburgie\u010di\u0173" },
            { "lg", "ganda" },
            { "li", "limburgie\u010di\u0173" },
            { "ln", "ngal\u0173" },
            { "lo", metaValue_lo },
            { "lt", "lietuvi\u0173" },
            { "lu", "luba katanga" },
            { "lv", "latvi\u0173" },
            { "mg", "malagas\u0173" },
            { "mh", "Mar\u0161alo Sal\u0173" },
            { "mi", "maori\u0173" },
            { "mk", "makedon\u0173" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marat\u0173" },
            { "ms", "malajie\u010di\u0173" },
            { "mt", "maltie\u010di\u0173" },
            { "my", metaValue_my },
            { "na", "naur\u0173" },
            { "nb", "norveg\u0173 bukmolas" },
            { "nd", "\u0161iaur\u0117s ndebel\u0173" },
            { "ne", "nepalie\u010di\u0173" },
            { "ng", "ndong\u0173" },
            { "nl", "oland\u0173" },
            { "nn", "naujoji norveg\u0173" },
            { "no", "norveg\u0173" },
            { "nr", "piet\u0173 ndebele" },
            { "nv", "navaj\u0173" },
            { "ny", "nianj\u0173" },
            { "oc", "o\u010ditar\u0173" },
            { "oj", "ojibva" },
            { "om", "orom\u0173" },
            { "or", "odij\u0173" },
            { "os", "osetin\u0173" },
            { "pa", "pend\u017eab\u0173" },
            { "pi", "pali" },
            { "pl", "lenk\u0173" },
            { "ps", "pu\u0161t\u016bn\u0173" },
            { "pt", "portugal\u0173" },
            { "qu", "ke\u010duj\u0173" },
            { "rm", "retoroman\u0173" },
            { "rn", "rundi" },
            { "ro", "rumun\u0173" },
            { "ru", "rus\u0173" },
            { "rw", "kinjaruand\u0173" },
            { "sa", "sanskritas" },
            { "sc", "sardinie\u010di\u0173" },
            { "sd", "sind\u0173" },
            { "se", "\u0161iaur\u0117s sami\u0173" },
            { "sg", "sango" },
            { "sh", "serb\u0173-kroat\u0173" },
            { "si", metaValue_si },
            { "sk", "slovak\u0173" },
            { "sl", "slov\u0117n\u0173" },
            { "sm", metaValue_WS },
            { "sn", "\u0161on\u0173" },
            { "so", "somalie\u010di\u0173" },
            { "sq", "alban\u0173" },
            { "sr", "serb\u0173" },
            { "ss", "svat\u0173" },
            { "st", "piet\u0173 Soto" },
            { "su", metaValue_su },
            { "sv", "\u0161ved\u0173" },
            { "sw", "suahili\u0173" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tad\u017eik\u0173" },
            { "th", metaValue_th },
            { "ti", "tigraj\u0173" },
            { "tk", "turkm\u0117n\u0173" },
            { "tl", metaValue_tl },
            { "tn", "tsvan\u0173" },
            { "to", "tongan\u0173" },
            { "tr", "turk\u0173" },
            { "ts", "tsong\u0173" },
            { "tt", "totori\u0173" },
            { "tw", "tvi" },
            { "ty", "taitie\u010di\u0173" },
            { "ug", "uig\u016br\u0173" },
            { "uk", "ukrainie\u010di\u0173" },
            { "ur", "urd\u0173" },
            { "uz", "uzbek\u0173" },
            { "ve", "vend\u0173" },
            { "vi", "vietnamie\u010di\u0173" },
            { "vo", "volapiuko" },
            { "wa", "valon\u0173" },
            { "wo", "volof\u0173" },
            { "xh", "kos\u0173" },
            { "yi", "jidi\u0161" },
            { "yo", "jorub\u0173" },
            { "za", "chuang" },
            { "zh", "kin\u0173" },
            { "zu", "zul\u0173" },
            { "ace", "a\u010dinez\u0173" },
            { "ach", "akoli\u0173" },
            { "ada", "adangm\u0173" },
            { "ady", "adyg\u0117j\u0173" },
            { "aeb", "Tuniso arab\u0173" },
            { "afh", "afrihili" },
            { "agq", "aghem\u0173" },
            { "ain", "ain\u0173" },
            { "akk", "akadian\u0173" },
            { "akz", "alabamie\u010di\u0173" },
            { "ale", "aleut\u0173" },
            { "aln", "alban\u0173 kalbos geg\u0173 tarm\u0117" },
            { "alt", "piet\u0173 Altajaus" },
            { "ang", "senoji angl\u0173" },
            { "ann", "obol\u0173" },
            { "anp", "angik\u0173" },
            { "arc", "aramaik\u0173" },
            { "arn", "mapudungun\u0173" },
            { "aro", "araon\u0173" },
            { "arp", "arapah\u0173" },
            { "arq", "Al\u017eyro arab\u0173" },
            { "ars", "arab\u0173 najdi" },
            { "arw", "aravak\u0173" },
            { "ary", "Maroko arab\u0173" },
            { "arz", "Egipto arab\u0173" },
            { "asa", "asu" },
            { "ase", "Amerikos \u017eenkl\u0173 kalba" },
            { "ast", "asturian\u0173" },
            { "atj", "atikamek\u0173" },
            { "avk", "kotava" },
            { "awa", "avadhi" },
            { "bal", "balu\u010di" },
            { "ban", "balie\u010di\u0173" },
            { "bar", "bavar\u0173" },
            { "bas", "bas\u0173" },
            { "bax", "bamun\u0173" },
            { "bbc", "batak toba" },
            { "bbj", "ghomal\u0173" },
            { "bej", "b\u0117j\u0173" },
            { "bem", "bemb\u0173" },
            { "bew", "betavi" },
            { "bez", "ben\u0173" },
            { "bfd", "bafut\u0173" },
            { "bfq", "badaga" },
            { "bgc", "harijanvi" },
            { "bgn", "vakar\u0173 belud\u017ei\u0173" },
            { "bho", "bau\u010dpuri" },
            { "bik", "bikol\u0173" },
            { "bin", "bini" },
            { "bjn", "band\u017ear\u0173" },
            { "bkm", "kom\u0173" },
            { "bla", "siksik\u0173" },
            { "bpy", "bi\u0161nuprijos" },
            { "bqi", "bakhtiari" },
            { "bra", "braj\u0173" },
            { "brh", "brahuj\u0173" },
            { "brx", "bodo" },
            { "bss", "ak\u016bs\u0173" },
            { "bua", "buriat\u0173" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumb\u0173" },
            { "cad", "kado" },
            { "car", "karib\u0173" },
            { "cay", "kaij\u016bg\u0173" },
            { "cch", "atsam\u0173" },
            { "ccp", "\u010cakma" },
            { "ceb", "sebuan\u0173" },
            { "cgg", "\u010dig\u0173" },
            { "chb", "\u010dib\u010d\u0173" },
            { "chg", "\u010dagat\u0173" },
            { "chk", "\u010dukes\u0173" },
            { "chm", "mari\u0173" },
            { "chn", "\u010dinuk \u017eargonas" },
            { "cho", "\u010doktau" },
            { "chp", "\u010dipv\u0117j\u0173" },
            { "chr", metaValue_chr },
            { "chy", "\u010dajen\u0173" },
            { "ckb", "sorani\u0173 kurd\u0173" },
            { "clc", "\u010dilkotin\u0173" },
            { "cop", metaValue_cop },
            { "cps", "capiznon" },
            { "crg", "metis\u0173" },
            { "crh", "Krymo turk\u0173" },
            { "crj", "pietry\u010di\u0173 kri" },
            { "crk", "supraprastinta kri" },
            { "crl", "\u0161iaur\u0117s ryt\u0173 kri" },
            { "crm", "muskri" },
            { "crr", "pamlik\u0173" },
            { "crs", "Sei\u0161eli\u0173 kreol\u0173 ir pranc\u016bz\u0173" },
            { "csb", "ka\u0161ub\u0173" },
            { "csw", "pelkyn\u0173 kri" },
            { "dak", "dakot\u0173" },
            { "dar", "dargva" },
            { "dav", "tait\u0173" },
            { "del", "delavero" },
            { "den", "slave" },
            { "dgr", "dogrib\u0173" },
            { "din", "dink\u0173" },
            { "dje", "zarm\u0173" },
            { "doi", "dogri" },
            { "dsb", "\u017eemutini\u0173 sorb\u0173" },
            { "dtp", "centrinio Dusuno" },
            { "dua", "dual\u0173" },
            { "dum", "Vidurio Vokietijos" },
            { "dyo", "d\u017eiola-foni" },
            { "dyu", "dyul\u0173" },
            { "dzg", "dazag\u0173" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "ital\u0173 kalbos Emilijos tarm\u0117" },
            { "egy", "senov\u0117s egiptie\u010di\u0173" },
            { "eka", "ekajuk" },
            { "elx", "elamit\u0173" },
            { "enm", "Vidurio Anglijos" },
            { "esu", "centrin\u0117s Aliaskos jupik\u0173" },
            { "ewo", "evondo" },
            { "ext", "ispan\u0173 kalbos Ekstremad\u016bros tarm\u0117" },
            { "fan", "fang\u0173" },
            { "fat", "fanti" },
            { "fil", "filipinie\u010di\u0173" },
            { "fit", "suomi\u0173 kalbos Tornedalio tarm\u0117" },
            { "fon", "fon" },
            { "frc", "kad\u017eun\u0173 pranc\u016bz\u0173" },
            { "frm", "Vidurio Pranc\u016bzijos" },
            { "fro", "senoji pranc\u016bz\u0173" },
            { "frp", "arpitano" },
            { "frr", "\u0161iaurini\u0173 fryz\u0173" },
            { "frs", "ryt\u0173 fryz\u0173" },
            { "fur", "friuli\u0173" },
            { "gaa", "ga" },
            { "gag", "gaga\u016bz\u0173" },
            { "gan", "kin\u0173 kalbos dziangsi tarm\u0117" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gbz", "zoroastr\u0173 dari" },
            { "gez", "gyz" },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "Vidurio Auk\u0161tosios Vokietijos" },
            { "goh", "senoji Auk\u0161tosios Vokietijos" },
            { "gom", "Goa konkani\u0173" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "senov\u0117s graik\u0173" },
            { "gsw", "\u0160veicarijos vokie\u010di\u0173" },
            { "guc", "vaj\u0173" },
            { "gur", "frafra" },
            { "guz", "gusi" },
            { "gwi", "gvi\u010dino" },
            { "hai", "haido" },
            { "hak", "kin\u0173 kalbos hak\u0173 tarm\u0117" },
            { "haw", "havajie\u010di\u0173" },
            { "hax", "Piet\u0173 Haidos" },
            { "hif", "Fid\u017eio hindi" },
            { "hil", "hiligainon\u0173" },
            { "hit", "hitit\u0173" },
            { "hmn", "hmong" },
            { "hsb", "auk\u0161tutini\u0173 sorb\u0173" },
            { "hsn", "kin\u0173 kalbos hunano tarm\u0117" },
            { "hup", "hupa" },
            { "hur", "halkomelem\u0173" },
            { "iba", "iban" },
            { "ibb", "ibibij\u0173" },
            { "ikt", "vakar\u0173 kanadie\u010di\u0173 inuktitutas" },
            { "ilo", "ilok\u0173" },
            { "inh", "ingu\u0161\u0173" },
            { "izh", "ingr\u0173" },
            { "jam", "Jamaikos kreol\u0173 angl\u0173" },
            { "jbo", "loiban" },
            { "jgo", "ngomb\u0173" },
            { "jmc", "ma\u010dam\u0173" },
            { "jpr", "jud\u0117j\u0173 pers\u0173" },
            { "jrb", "jud\u0117j\u0173 arab\u0173" },
            { "jut", "dan\u0173 kalbos jut\u0173 tarm\u0117" },
            { "kaa", "karakalpak\u0173" },
            { "kab", "kebail\u0173" },
            { "kac", "ka\u010din\u0173" },
            { "kaj", "ju" },
            { "kam", "kemb\u0173" },
            { "kaw", "kavi\u0173" },
            { "kbd", "kabardin\u0173" },
            { "kbl", "kanemb\u0173" },
            { "kcg", "tyap" },
            { "kde", "makond\u0173" },
            { "kea", "\u017daliojo Ky\u0161ulio kreol\u0173" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kasi" },
            { "kho", "kotanez\u0173" },
            { "khq", "kojra \u010dini" },
            { "khw", "khovar\u0173" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin\u0173" },
            { "kmb", "kimbundu" },
            { "koi", "komi\u0173-permi\u0173" },
            { "kok", "konkani\u0173" },
            { "kos", "kosrean\u0173" },
            { "kpe", "kpeli\u0173" },
            { "krc", "kara\u010diaj\u0173 balkarijos" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karel\u0173" },
            { "kru", "kuruk" },
            { "ksb", "\u0161ambal\u0173" },
            { "ksf", "baf\u0173" },
            { "ksh", "kologn\u0173" },
            { "kum", "kumik\u0173" },
            { "kut", "kutenai" },
            { "kwk", "kvakval\u0173" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "landa" },
            { "lam", "lamba" },
            { "lez", "lezgin\u0173" },
            { "lfn", "naujoji frank\u0173 kalba" },
            { "lij", "lig\u016br\u0173" },
            { "lil", "liluet\u0173" },
            { "liv", "lyvi\u0173" },
            { "lkt", "lakot\u0173" },
            { "lmo", "lombard\u0173" },
            { "lol", "mong\u0173" },
            { "lou", "Luizianos kreol\u0173" },
            { "loz", "lozi\u0173" },
            { "lrc", "\u0161iaur\u0117s luri" },
            { "lsm", "sami\u0173" },
            { "ltg", "latgali\u0173" },
            { "lua", "luba lulua" },
            { "lui", "luiseno" },
            { "lun", "Lundos" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luja" },
            { "lzh", "klasikin\u0117 kin\u0173" },
            { "lzz", "laz" },
            { "mad", "madurez\u0173" },
            { "maf", "maf\u0173" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "Makasaro" },
            { "man", "manding\u0173" },
            { "mas", "masaj\u0173" },
            { "mde", "mab\u0173" },
            { "mdf", "mok\u0161a" },
            { "mdr", "mandar\u0173" },
            { "men", "mende" },
            { "mer", "mer\u0173" },
            { "mfe", "morisij\u0173" },
            { "mga", "Vidurio Airijos" },
            { "mgh", "makua-maeto" },
            { "mgo", "meta" },
            { "mic", "mikmak\u0173" },
            { "min", "minangkabau" },
            { "mnc", "man\u010du" },
            { "mni", "manipuri\u0173" },
            { "moe", "montanj\u0173" },
            { "moh", "mohok" },
            { "mos", "mosi" },
            { "mrj", "vakar\u0173 mari" },
            { "mua", "mundang\u0173" },
            { "mul", "kelios kalbos" },
            { "mus", "kryk\u0173" },
            { "mwl", "mirandez\u0173" },
            { "mwr", "marvari" },
            { "mwv", "mentavai" },
            { "mye", "mjen\u0173" },
            { "myv", "erzyj\u0173" },
            { "mzn", "mazenderani\u0173" },
            { "nan", "kin\u0173 kalbos piet\u0173 min\u0173 tarm\u0117" },
            { "nap", "neapolie\u010di\u0173" },
            { "naq", "nama" },
            { "nds", "\u017demutin\u0117s Vokietijos" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niujie\u010di\u0173" },
            { "njo", "ao naga" },
            { "nmg", "kvasi\u0173" },
            { "nnh", "ngiemb\u016bn\u0173" },
            { "nog", "nog\u0173" },
            { "non", "senoji nors\u0173" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0161iaur\u0117s Soto" },
            { "nus", "nuer\u0173" },
            { "nwc", "klasikin\u0117 nevari" },
            { "nym", "niamvezi" },
            { "nyn", "niankol\u0173" },
            { "nyo", "nior\u0173" },
            { "nzi", "nzima" },
            { "ojb", "\u0161iaur\u0117s vakar\u0173 od\u017eibvi\u0173" },
            { "ojc", "ojibv\u0173" },
            { "ojs", "od\u017ei kri" },
            { "ojw", "vakar\u0173 od\u017eibvi\u0173" },
            { "oka", "okanagan\u0173" },
            { "osa", "osage" },
            { "ota", "osman\u0173 turk\u0173" },
            { "pag", "pangasinan\u0173" },
            { "pal", "vidurin\u0117 pers\u0173 kalba" },
            { "pam", "pampang\u0173" },
            { "pap", "papiamento" },
            { "pau", "palaulie\u010di\u0173" },
            { "pcd", "pikard\u0173" },
            { "pcm", "Nigerijos pid\u017ein\u0173" },
            { "pdc", "Pensilvanijos vokie\u010di\u0173" },
            { "pdt", "vokie\u010di\u0173 kalbos \u017eemai\u010di\u0173 tarm\u0117" },
            { "peo", "senoji pers\u0173" },
            { "pfl", "vokie\u010di\u0173 kalbos Pfalco tarm\u0117" },
            { "phn", "finikie\u010di\u0173" },
            { "pis", "pid\u017ein\u0173" },
            { "pms", "ital\u0173 kalbos Pjemonto tarm\u0117" },
            { "pnt", "Ponto" },
            { "pon", "Ponap\u0117s" },
            { "pqm", "Maliset-Pasamakvod\u017eio" },
            { "prg", "pr\u016bs\u0173" },
            { "pro", "senov\u0117s provansal\u0173" },
            { "quc", "ki\u010di\u0173" },
            { "qug", "\u010cimboraso auk\u0161tum\u0173 ke\u010duj\u0173" },
            { "raj", "Rad\u017eastano" },
            { "rap", "rapanui" },
            { "rar", "rarotongan\u0173" },
            { "rgn", "ital\u0173 kalbos Romanijos tarm\u0117" },
            { "rhg", "rochind\u017ea" },
            { "rif", "rif\u0173" },
            { "rof", "rombo" },
            { "rom", "rom\u0173" },
            { "rtm", "rotuman\u0173" },
            { "rue", "rusin\u0173" },
            { "rug", "Rovianos" },
            { "rup", "aromani\u0173" },
            { "rwk", "rua" },
            { "sad", "sandavi\u0173" },
            { "sah", "jakut\u0173" },
            { "sam", "samar\u0117j\u0173 arami\u0173" },
            { "saq", "samb\u016br\u0173" },
            { "sas", "sasak" },
            { "sat", "santali\u0173" },
            { "saz", "saura\u0161tr\u0173" },
            { "sba", "ngambaj\u0173" },
            { "sbp", "sang\u0173" },
            { "scn", "sicilie\u010di\u0173" },
            { "sco", "\u0161kot\u0173" },
            { "sdc", "sasares\u0173 sardin\u0173" },
            { "sdh", "piet\u0173 kurd\u0173" },
            { "see", "senec\u0173" },
            { "seh", "sen\u0173" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "kojraboro seni" },
            { "sga", "senoji airi\u0173" },
            { "sgs", "\u017eemai\u010di\u0173" },
            { "shi", "tachelhit\u0173" },
            { "shn", "\u0161an" },
            { "shu", "chadian arab\u0173" },
            { "sid", "sidam\u0173" },
            { "slh", "piet\u0173 lushusid\u0173" },
            { "sli", "silezie\u010di\u0173 \u017eemai\u010di\u0173" },
            { "sly", "selajar\u0173" },
            { "sma", "piet\u0173 sami\u0173" },
            { "smj", "Liuleo sami\u0173" },
            { "smn", "Inario sami\u0173" },
            { "sms", "Skolto sami\u0173" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "serer\u0173" },
            { "ssy", "saho" },
            { "stq", "Saterlendo fryz\u0173" },
            { "str", "Sali\u0161o s\u0105siaurio" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "\u0161umer\u0173" },
            { "swb", "komor\u0173" },
            { "syc", "klasikin\u0117 sir\u0173" },
            { "syr", metaValue_syr },
            { "szl", "silezie\u010di\u0173" },
            { "tce", "piet\u0173 tu\u010don\u0173" },
            { "tcy", "tul\u0173" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "Tereno" },
            { "tet", "tetum" },
            { "tgx", "tagi\u0161\u0173" },
            { "tht", "taltan\u0173" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", metaValue_TK },
            { "tkr", "tsakur\u0173" },
            { "tlh", "klingon\u0173" },
            { "tli", "tlingit\u0173" },
            { "tly", "taly\u0161\u0173" },
            { "tmh", "tama\u0161ek" },
            { "tog", "niasa tong\u0173" },
            { "tok", "Toki Pona" },
            { "tpi", "Papua pid\u017ein\u0173" },
            { "tru", "turoyo" },
            { "trv", "Taroko" },
            { "tsd", "tsakon\u0173" },
            { "tsi", "tsim\u0161ian" },
            { "ttm", "\u0161iaur\u0117s tutson\u0173" },
            { "ttt", "musulmon\u0173 tat\u0173" },
            { "tum", "tumbuk\u0173" },
            { "tvl", metaValue_TV },
            { "twq", "tasavak\u0173" },
            { "tyv", "tuvi\u0173" },
            { "tzm", "Centrinio Maroko tamazit\u0173" },
            { "udm", "udmurt\u0173" },
            { "uga", "ugarit\u0173" },
            { "umb", "umbundu" },
            { "und", "ne\u017einoma kalba" },
            { "vai", metaValue_vai },
            { "vec", "venet\u0173" },
            { "vep", "veps\u0173" },
            { "vls", "vakar\u0173 flamand\u0173" },
            { "vmf", "pagrindin\u0117 frankon\u0173" },
            { "vot", "Votik" },
            { "vro", "veru" },
            { "vun", "vunjo" },
            { "wae", "valser\u0173" },
            { "wal", "valamo" },
            { "war", "varai" },
            { "was", "Va\u0161o" },
            { "wbp", "valrpiri" },
            { "wuu", "kin\u0173 kalbos vu tarm\u0117" },
            { "xal", "kalmuk\u0173" },
            { "xmf", "megrel\u0173" },
            { "xog", "sog\u0173" },
            { "yao", "jao" },
            { "yap", "japez\u0173" },
            { "yav", "jangben\u0173" },
            { "ybb", "jemb\u0173" },
            { "yrl", "njengatu" },
            { "yue", "kin\u0173 kalbos Kantono tarm\u0117" },
            { "zap", "zapotek\u0173" },
            { "zbl", "BLISS simboli\u0173" },
            { "zea", "zeland\u0173" },
            { "zen", "zenaga" },
            { "zgh", "standartin\u0117 Maroko tamazigt\u0173" },
            { "zun", "Zuni" },
            { "zxx", "n\u0117ra kalbinio turinio" },
            { "zza", "zaza" },
            { "Adlm", "ADLAM" },
            { "Afak", "Afaka" },
            { "Aghb", "Kaukazo Albanijos" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastalik" },
            { "Armi", "imperin\u0117 aramaik\u0173" },
            { "Armn", metaValue_hy },
            { "Avst", "avestano" },
            { "Bali", "Balie\u010di\u0173" },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "\u201eBliss\u201c simboliai" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "brailio" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", "\u010dakma" },
            { "Cans", "suvienodinti Kanados aborigen\u0173 silabiniai" },
            { "Cari", "kari\u0173" },
            { "Cham", "\u010dam" },
            { "Cher", metaValue_chr },
            { "Cirt", "kirt" },
            { "Copt", metaValue_cop },
            { "Cprt", "kipro" },
            { "Cyrl", "kirilica" },
            { "Cyrs", "senoji ba\u017enytin\u0117 slav\u0173 kirilica" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseretas" },
            { "Dupl", "Duploj\u0117 stenografija" },
            { "Egyd", "Egipto liaudies" },
            { "Egyh", "Egipto \u017eyni\u0173" },
            { "Egyp", "egipto hieroglifai" },
            { "Elba", "Elbasano" },
            { "Ethi", "etiop\u0173" },
            { "Geok", "gruzin\u0173 kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitik" },
            { "Goth", metaValue_got },
            { "Gran", "Granta" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuki" },
            { "Hanb", "hanb\u0173" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanuno" },
            { "Hans", "supaprastinti" },
            { "Hant", "tradiciniai" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "Anatolijaus hieroglifai" },
            { "Hmng", "pahav hmong" },
            { "Hrkt", "katakana / hiragana" },
            { "Hung", "senasis vengr\u0173" },
            { "Inds", "indus" },
            { "Ital", "senasis ital\u0173" },
            { "Jamo", "Jamo simboliai" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "kajah li" },
            { "Kana", "katakana" },
            { "Khar", "karo\u0161ti" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "Kpel\u0173" },
            { "Kthi", "kaithi" },
            { "Lana", "lana" },
            { "Laoo", metaValue_lo },
            { "Latf", "fraktur lotyn\u0173" },
            { "Latg", "g\u0117l\u0173 lotyn\u0173" },
            { "Latn", metaValue_la },
            { "Lepc", "lep\u010da" },
            { "Limb", "limbu" },
            { "Lina", "linijiniai A" },
            { "Linb", "linijiniai B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "lician" },
            { "Lydi", "lidian" },
            { "Mahj", "Mahad\u017eani" },
            { "Mand", "mand\u0117j\u0173" },
            { "Mani", "mani\u010d\u0173" },
            { "Maya", "mal\u0173 hieroglifai" },
            { "Mend", "Mende" },
            { "Merc", "Merojit\u0173 rankra\u0161tinis" },
            { "Mero", "meroitik" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "m\u016bn" },
            { "Mroo", "Mro" },
            { "Mtei", "meitei majek" },
            { "Mymr", metaValue_my },
            { "Narb", "Senasis \u0161iaur\u0117s arab\u0173" },
            { "Nbat", "Nabat\u0117j\u0173" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol \u010diki" },
            { "Orkh", "orkon" },
            { "Orya", "orij\u0173" },
            { "Osma", "osman\u0173" },
            { "Palm", "Palmiros" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "senieji perm\u0117s" },
            { "Phag", "pagsa pa" },
            { "Phli", "ra\u0161ytiniai pahlavi" },
            { "Phlp", "pselter pahlavi" },
            { "Phlv", "buk pahvali" },
            { "Phnx", "foenik\u0173" },
            { "Plrd", "polard fonetin\u0117" },
            { "Prti", "ra\u0161ytiniai part\u0173" },
            { "Rjng", "rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "run\u0173" },
            { "Samr", "samarie\u010di\u0173" },
            { "Sara", "sarati" },
            { "Sarb", "senoji piet\u0173 Arabijos" },
            { "Saur", "saura\u0161tra" },
            { "Sgnw", "\u017eenkl\u0173 ra\u0161tas" },
            { "Shaw", "\u0161avi\u0173" },
            { "Shrd", "\u0160arados" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "Sora Sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "estrangelo sirie\u010di\u0173" },
            { "Syrj", "vakar\u0173 sir\u0173" },
            { "Syrn", "ryt\u0173 sir\u0173" },
            { "Tagb", "tagbanva" },
            { "Takr", "Takri" },
            { "Tale", "tai le" },
            { "Talu", "naujasis Tailando lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "tai vet" },
            { "Telu", metaValue_te },
            { "Teng", "tengvar" },
            { "Tfng", "tifinag" },
            { "Tglg", metaValue_tl },
            { "Thaa", "hana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Ugar", "ugaritik" },
            { "Vaii", metaValue_vai },
            { "Visp", "matoma kalba" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleai" },
            { "Xpeo", "senieji pers\u0173" },
            { "Xsux", "\u0160umero Akado dantira\u0161tis" },
            { "Yiii", "ji" },
            { "Zinh", "paveld\u0117tas" },
            { "Zmth", "matematiniai simboliai" },
            { "Zsye", "jaustukai" },
            { "Zsym", "simboli\u0173" },
            { "Zxxx", "nepara\u0161yta" },
            { "Zyyy", "bendri" },
            { "Zzzz", "ne\u017einomi ra\u0161menys" },
            { "de_AT", "Austrijos vokie\u010di\u0173" },
            { "de_CH", "\u0160veicarijos auk\u0161tutin\u0117 vokie\u010di\u0173" },
            { "en_AU", "Australijos angl\u0173" },
            { "en_CA", "Kanados angl\u0173" },
            { "en_GB", "Did\u017eiosios Britanijos angl\u0173" },
            { "en_US", "Jungtini\u0173 Valstij\u0173 angl\u0173" },
            { "es_ES", "Europos ispan\u0173" },
            { "es_MX", "Meksikos ispan\u0173" },
            { "fr_CA", "Kanados pranc\u016bz\u0173" },
            { "fr_CH", "\u0160veicarijos pranc\u016bz\u0173" },
            { "nl_BE", "flamand\u0173" },
            { "pt_BR", "Brazilijos portugal\u0173" },
            { "pt_PT", "Europos portugal\u0173" },
            { "ro_MD", "moldav\u0173" },
            { "sw_CD", "Kongo suahili\u0173" },
            { "%%1901", "\u012eprasta vokie\u010di\u0173 ra\u0161yba" },
            { "%%1994", "Sunorminta Resian ra\u0161yba" },
            { "%%1996", "1996 -\u0173j\u0173 met\u0173 vokie\u010di\u0173 ra\u0161yba" },
            { "ar_001", "\u0161iuolaikin\u0117 standartin\u0117 arab\u0173" },
            { "es_419", "Lotyn\u0173 Amerikos ispan\u0173" },
            { "key.ca", "kalendorius" },
            { "key.cf", "valiutos formatas" },
            { "key.co", "rikiavimas" },
            { "key.cu", "valiuta" },
            { "key.hc", "valand\u0173 ciklas (12 ir 24)" },
            { "key.lb", "teksto lau\u017eymo stilius" },
            { "key.ms", "mat\u0173 sistema" },
            { "key.nu", "skai\u010diai" },
            { "key.tz", "Laiko juosta" },
            { "key.va", "Lokal\u0117s variantas" },
            { "nds_NL", "\u017demutin\u0117s Saksonijos (Nyderlandai)" },
            { "%%BISKE", "San Giorgio / Bila tarm\u0117" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "\u012eprasta ra\u0161yba" },
            { "%%LIPAW", "Resian tarmei priklausanti Lipovaz tarm\u0117" },
            { "%%NEDIS", "Natisone tarm\u0117" },
            { "%%NJIVA", "Gniva / Njiva tarm\u0117" },
            { "%%OSOJS", "Oseacco / Osojane tarm\u0117" },
            { "%%POSIX", "Kompiuteris" },
            { "%%ROZAJ", "Resian" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Stolvizza / Solbica tarm\u0117" },
            { "%%UCCOR", "Suvienodinta ra\u0161yba" },
            { "zh_Hans", "supaprastintoji kin\u0173" },
            { "zh_Hant", "tradicin\u0117 kin\u0173" },
            { "%%FONIPA", "Tarptautin\u0117s ab\u0117c\u0117l\u0117s fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%PINYIN", "Kin\u0173 hieroglif\u0173 vertimo sistema Romanization" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskievica tarm\u0117" },
            { "%%UCRCOR", "Suvienodinta i\u0161taisyta ra\u0161yba" },
            { "%%AREVELA", "Ryt\u0173 arm\u0117nai" },
            { "%%AREVMDA", "Vakar\u0173 arm\u0117nai" },
            { "%%MONOTON", "Vienodas" },
            { "%%POLYTON", "Polytonic" },
            { "%%REVISED", "I\u0161taisyta ra\u0161yba" },
            { "%%1606NICT", "1606 -\u0173j\u0173 met\u0173 pranc\u016bz\u0173 kalba" },
            { "%%1694ACAD", "Ankstyvasis Pranc\u016bzijos modernizmas" },
            { "%%1959ACAD", "Akademinis" },
            { "%%BAKU1926", "Suvienodinta turk\u0173 kalbos lotyni\u0161ka ab\u0117c\u0117l\u0117" },
            { "%%SCOTLAND", "Normin\u0117 \u0161koti\u0161ka angl\u0173 kalba" },
            { "%%VALENCIA", "Valencie\u010diai" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "type.ca.roc", "Kinijos Respublikos kalendorius" },
            { "type.co.eor", "r\u016b\u0161iavimo tvarka daugiakalb\u0117s Europos dokument\u0173" },
            { "type.hc.h11", "12 valand\u0173 sistema (0\u201311)" },
            { "type.hc.h12", "12 valand\u0173 sistema (1\u201312)" },
            { "type.hc.h23", "24 valand\u0173 sistema (0\u201323)" },
            { "type.hc.h24", "24 valand\u0173 sistema (1\u201324)" },
            { "type.m0.bgn", "BGN simboliai" },
            { "type.nu.arab", "arab\u0173-ind\u0173 skaitmenys" },
            { "type.nu.armn", "arm\u0117n\u0173 skaitmenys" },
            { "type.nu.bali", "bali skaitmenys" },
            { "type.nu.beng", "bengal\u0173 skaitmenys" },
            { "type.nu.brah", "Brahmi skaitmenys" },
            { "type.nu.cakm", "\u010cakm\u0173 skaitmenys" },
            { "type.nu.cham", "cham skaitmenys" },
            { "type.nu.deva", "devanagari skaitmenys" },
            { "type.nu.ethi", "Etiopijos skaitmenys" },
            { "type.nu.geor", "gruzin\u0173 skaitmenys" },
            { "type.nu.grek", "graik\u0173 skaitmenys" },
            { "type.nu.gujr", "gud\u017earat\u0173 skaitmenys" },
            { "type.nu.guru", "gurmuki skaitmenys" },
            { "type.nu.hans", "supaprastintos kin\u0173 k. skaitmenys" },
            { "type.nu.hant", "tradicin\u0117s kin\u0173 k. skaitmenys" },
            { "type.nu.hebr", "hebraj\u0173 skaitmenys" },
            { "type.nu.java", "javie\u010di\u0173 skaitmenys" },
            { "type.nu.jpan", "japon\u0173 skaitmenys" },
            { "type.nu.kali", "Kayah Li skaitmenys" },
            { "type.nu.khmr", "khmer\u0173 skaitmenys" },
            { "type.nu.knda", "kanad\u0173 skaitmenys" },
            { "type.nu.lana", "Tai Tham Hora skaitmenys" },
            { "type.nu.laoo", "laosie\u010di\u0173 skaitmenys" },
            { "type.nu.latn", "lotyni\u0161ki skaitmenys" },
            { "type.nu.lepc", "Lepcha skaitmenys" },
            { "type.nu.limb", "Limbu skaitmenys" },
            { "type.nu.mlym", "malajali\u0173 skaitmenys" },
            { "type.nu.mong", "mongol\u0173 skaitmenys" },
            { "type.nu.mtei", "Meetei Mayek skaitmenys" },
            { "type.nu.mymr", "mianmarie\u010di\u0173 skaitmenys" },
            { "type.nu.nkoo", "N\u2019Ko skaitmenys" },
            { "type.nu.olck", "Ol Chiki skaitmenys" },
            { "type.nu.orya", "orij\u0173 skaitmenys" },
            { "type.nu.osma", "Osman\u0173 skaitmenys" },
            { "type.nu.saur", "Saura\u0161tr\u0173 skaitmenys" },
            { "type.nu.shrd", "\u0160arad\u0173 skaitmenys" },
            { "type.nu.sora", "Sora Sompeng skaitmenys" },
            { "type.nu.sund", "Sudanie\u010di\u0173 skaitmenys" },
            { "type.nu.takr", "Takri skaitmenys" },
            { "type.nu.talu", "Naujieji Tai Lue skaitmenys" },
            { "type.nu.taml", "tradicin\u0117s tamil\u0173 skaitmenys" },
            { "type.nu.telu", "telug\u0173 skaitmenys" },
            { "type.nu.thai", "taj\u0173 skaitmenys" },
            { "type.nu.tibt", "tibetie\u010di\u0173 skaitmenys" },
            { "type.nu.vaii", "vai skaitmenys" },
            { "type.ca.dangi", "dangi kalendorius" },
            { "type.co.ducet", "numatytasis unikodo rikiavimas" },
            { "type.lb.loose", "laisvas teksto lau\u017eymo stilius" },
            { "type.nu.roman", "rom\u0117ni\u0161ki skaitmenys" },
            { "type.ca.coptic", "kopt\u0173 kalendorius" },
            { "type.ca.hebrew", "hebraj\u0173 kalendorius" },
            { "type.ca.indian", "nacionalinis ind\u0173 kalendorius" },
            { "type.co.compat", "ankstesn\u0117 r\u016b\u0161iavimo tvarka, skirta suderinamumui" },
            { "type.co.pinyin", "supaprastinta kini\u0161k\u0173 hieroglif\u0173 r\u016b\u0161iavimo tvarka" },
            { "type.co.search", "bendroji paie\u0161ka" },
            { "type.co.stroke", "\u012eprasta kini\u0161ko po\u017eymio r\u016b\u0161iavimo tvarka" },
            { "type.co.unihan", "\u0160aknies \u017eenkl\u0173 ir br\u016bk\u0161ni\u0173 r\u016b\u0161iavimo tvarka" },
            { "type.co.zhuyin", "Zhuyin rikiavimo tvarka" },
            { "type.d0.fwidth", "viso plo\u010dio" },
            { "type.d0.hwidth", "vidutinio plo\u010dio" },
            { "type.lb.normal", "\u012fprastas teksto lau\u017eymo stilius" },
            { "type.lb.strict", "grie\u017etas teksto lau\u017eymo stilius" },
            { "type.m0.ungegn", "UNGEGN simboliai" },
            { "type.ms.metric", "metrin\u0117 sistema" },
            { "type.nu.native", "Vietiniai skaitmenys" },
            { "type.ca.chinese", "kin\u0173 kalendorius" },
            { "type.ca.islamic", "islamo kalendorius" },
            { "type.ca.iso8601", "ISO 8601 kalendorius" },
            { "type.ca.persian", "pers\u0173 kalendorius" },
            { "type.cf.account", "apskaitos valiutos formatas" },
            { "type.co.big5han", "\u012fprasta kini\u0161ka r\u016b\u0161iavimo tvarka - Big5" },
            { "type.d0.npinyin", "Skaitinis" },
            { "type.nu.arabext", "i\u0161pl\u0117stiniai arab\u0173-ind\u0173 skaitmenys" },
            { "type.nu.armnlow", "arm\u0117n\u0173 skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "type.nu.finance", "Finansiniai skai\u010diai" },
            { "type.nu.greklow", "graik\u0173 skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "type.nu.hanidec", "kin\u0173 de\u0161imtainiai skaitmenys" },
            { "type.nu.hansfin", "supaprastintos kin\u0173 k. finans. skaitmenys" },
            { "type.nu.hantfin", "tradicin\u0117s kin\u0173 k. finans. skaitmenys" },
            { "type.nu.jpanfin", "japon\u0173 finans. skaitmenys" },
            { "type.nu.tamldec", "tamil\u0173 skaitmenys" },
            { "type.ca.buddhist", "budist\u0173 kalendorius" },
            { "type.ca.ethiopic", "Etiopijos kalendorius" },
            { "type.ca.japanese", "japon\u0173 kalendorius" },
            { "type.cf.standard", "standartinis valiutos formatas" },
            { "type.co.phonetic", "Fonetin\u0117 rikiavimo tvarka" },
            { "type.co.standard", "standartinis rikiavimas" },
            { "type.ms.uksystem", "angli\u0161ka mat\u0173 sistema" },
            { "type.ms.ussystem", "amerikieti\u0161ka mat\u0173 sistema" },
            { "type.nu.fullwide", "viso plo\u010dio skaitmenys" },
            { "type.nu.lanatham", "Tai Tham Tham skaitmenys" },
            { "type.nu.mymrshan", "Myanmar Shan skaitmenys" },
            { "type.nu.romanlow", "rom\u0117ni\u0161ki skaitmenys ma\u017eosiomis raid\u0117mis" },
            { "type.ca.gregorian", "Grigaliaus kalendorius" },
            { "type.co.gb2312han", "supaprastinta kini\u0161ka r\u016b\u0161iavimo tvarka - GB2312" },
            { "type.co.phonebook", "telefon\u0173 knygos r\u016b\u0161iavimo tvarka" },
            { "type.co.dictionary", "\u017eodyno r\u016b\u0161iavimo tvarka" },
            { "type.co.traditional", "\u012fprasta r\u016b\u0161iavimo tvarka" },
            { "type.nu.traditional", "Tradiciniai skai\u010diai" },
            { "type.ca.islamic-civil", "Islamo kalendorius (lentelinis, pilietin\u0117 era)" },
            { "type.ca.islamic-umalqura", "Islamo kalendorius (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Etiopijos \u201eAmete Alem\u201c kalendorius" },
        };
        return data;
    }
}
