/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;
import java.util.Queue;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class BackgroundEventHandler {
    private final Logger log;
    private final Queue<BackgroundEvent> backgroundEventQueue;

    public BackgroundEventHandler(LogContext logContext, Queue<BackgroundEvent> backgroundEventQueue) {
        this.log = logContext.logger(BackgroundEventHandler.class);
        this.backgroundEventQueue = backgroundEventQueue;
    }

    public void add(BackgroundEvent event) {
        Objects.requireNonNull(event, "BackgroundEvent provided to add must be non-null");
        this.backgroundEventQueue.add(event);
        this.log.trace("Enqueued event: {}", (Object)event);
    }
}

