/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.command.CommandActivity3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandBackward3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandBackward3() {
        super(CommandBackward3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandBackward3.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("\\("), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("->"), new RegexLeaf("INCOMING_COLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->"))), new RegexLeaf("INCOMING", "(.*?)"), new RegexLeaf("\\)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("backward"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), new RegexLeaf("LABEL", "(.*?)"), new RegexLeaf("STYLE", CommandActivity3.endingGroup()), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("\\("), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("->"), new RegexLeaf("OUTCOMING_COLOR", "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->"))), new RegexLeaf("OUTCOMING", "(.*?)"), new RegexLeaf("\\)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String styleString = arg.get("STYLE", 0);
        BoxStyle boxStyle = styleString == null ? BoxStyle.PLAIN : BoxStyle.fromString(styleString);
        String stereo = arg.get("STYLE", 1);
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
        }
        Display label = Display.getWithNewlines(diagram.getPragma(), arg.get("LABEL", 0));
        LinkRendering in = CommandBackward3.getBackRendering(diagram, arg, "INCOMING");
        LinkRendering out = CommandBackward3.getBackRendering(diagram, arg, "OUTCOMING");
        return diagram.backward(label, boxStyle, in, out, stereotype);
    }

    public static LinkRendering getBackRendering(ActivityDiagram3 diagram, RegexResult arg, String name) throws NoSuchColorException {
        Rainbow incomingColor = CommandBackward3.getRainbow(name + "_COLOR", diagram, arg);
        LinkRendering in = incomingColor == null ? LinkRendering.none() : LinkRendering.create(incomingColor);
        String label = arg.get(name, 0);
        return in.withDisplay(Display.getWithNewlines(diagram.getPragma(), label));
    }

    private static Rainbow getRainbow(String key, ActivityDiagram3 diagram, RegexResult arg) throws NoSuchColorException {
        String colorString = arg.get(key, 0);
        if (colorString == null) {
            return null;
        }
        return Rainbow.build(diagram.getSkinParam(), colorString, diagram.getSkinParam().colorArrowSeparationSpace());
    }
}

