/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Server;
import org.apache.catalina.Session;
import org.apache.catalina.session.JDBCStore;
import org.apache.catalina.session.StandardSession;
import org.apache.juli.logging.Log;

public class DataSourceStore
extends JDBCStore {
    @Override
    public String[] expiredKeys() throws IOException {
        return this.keys(true);
    }

    @Override
    public String[] keys() throws IOException {
        return this.keys(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] keys(boolean bl) throws IOException {
        String[] stringArray = null;
        for (int i = 2; i > 0; --i) {
            Connection connection = this.getConnection();
            if (connection == null) {
                return new String[0];
            }
            try {
                String string = "SELECT " + this.sessionIdCol + " FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
                if (bl) {
                    string = string + " AND (" + this.sessionLastAccessedCol + " + " + this.sessionMaxInactiveCol + " * 1000 < ?)";
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                    preparedStatement.setString(1, this.getName());
                    if (bl) {
                        preparedStatement.setLong(2, System.currentTimeMillis());
                    }
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                arrayList.add(resultSet.getString(1));
                            }
                        }
                        stringArray = arrayList.toArray(new String[0]);
                        i = 0;
                        continue;
                    }
                }
            }
            catch (SQLException sQLException) {
                this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                stringArray = new String[]{};
                continue;
            }
            finally {
                this.release(connection);
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws IOException {
        int n = 0;
        String string = "SELECT COUNT(" + this.sessionIdCol + ") FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        for (int i = 2; i > 0; --i) {
            Connection connection = this.getConnection();
            if (connection == null) {
                return n;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                preparedStatement.setString(1, this.getName());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    i = 0;
                    continue;
                }
            }
            catch (SQLException sQLException) {
                this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                continue;
            }
            finally {
                this.release(connection);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session load(String string) throws ClassNotFoundException, IOException {
        StandardSession standardSession = null;
        Context context = this.getManager().getContext();
        Log log = context.getLogger();
        String string2 = "SELECT " + this.sessionIdCol + ", " + this.sessionDataCol + " FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ? AND " + this.sessionAppCol + " = ?";
        for (int i = 2; i > 0; --i) {
            Connection connection = this.getConnection();
            if (connection == null) {
                return null;
            }
            ClassLoader classLoader = context.bind(Globals.IS_SECURITY_ENABLED, null);
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, this.getName());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        try (ObjectInputStream objectInputStream = this.getObjectInputStream(resultSet.getBinaryStream(2));){
                            if (log.isTraceEnabled()) {
                                log.trace((Object)sm.getString(this.getStoreName() + ".loading", new Object[]{string, this.sessionTable}));
                            }
                            standardSession = (StandardSession)this.manager.createEmptySession();
                            standardSession.readObjectData(objectInputStream);
                            standardSession.setManager(this.manager);
                        }
                    } else if (context.getLogger().isDebugEnabled()) {
                        log.debug((Object)(this.getStoreName() + ": No persisted data object found"));
                    }
                    i = 0;
                    continue;
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                continue;
            }
            finally {
                context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
                this.release(connection);
            }
        }
        return standardSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string) throws IOException {
        for (int i = 2; i > 0; --i) {
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            try {
                this.remove(string, connection);
                i = 0;
                continue;
            }
            catch (SQLException sQLException) {
                this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                continue;
            }
            finally {
                this.release(connection);
            }
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace((Object)sm.getString(this.getStoreName() + ".removing", new Object[]{string, this.sessionTable}));
        }
    }

    private void remove(String string, Connection connection) throws SQLException {
        String string2 = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionIdCol + " = ?  AND " + this.sessionAppCol + " = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, this.getName());
            preparedStatement.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        String string = "DELETE FROM " + this.sessionTable + " WHERE " + this.sessionAppCol + " = ?";
        for (int i = 2; i > 0; --i) {
            Connection connection = this.getConnection();
            if (connection == null) {
                return;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                preparedStatement.setString(1, this.getName());
                preparedStatement.execute();
                i = 0;
                continue;
            }
            catch (SQLException sQLException) {
                this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                continue;
            }
            finally {
                this.release(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Session session) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        String string = "INSERT INTO " + this.sessionTable + " (" + this.sessionIdCol + ", " + this.sessionAppCol + ", " + this.sessionDataCol + ", " + this.sessionValidCol + ", " + this.sessionMaxInactiveCol + ", " + this.sessionLastAccessedCol + ") VALUES (?, ?, ?, ?, ?, ?)";
        Session session2 = session;
        synchronized (session2) {
            for (int i = 2; i > 0; --i) {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                try {
                    this.remove(session.getIdInternal(), connection);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    try (Object object = new ObjectOutputStream(new BufferedOutputStream(byteArrayOutputStream));){
                        ((StandardSession)session).writeObjectData((ObjectOutputStream)object);
                    }
                    object = byteArrayOutputStream.toByteArray();
                    int n = ((Object)object).length;
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object, 0, n);
                         BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream, n);
                         PreparedStatement preparedStatement = connection.prepareStatement(string);){
                        preparedStatement.setString(1, session.getIdInternal());
                        preparedStatement.setString(2, this.getName());
                        preparedStatement.setBinaryStream(3, (InputStream)bufferedInputStream, n);
                        preparedStatement.setString(4, session.isValid() ? "1" : "0");
                        preparedStatement.setInt(5, session.getMaxInactiveInterval());
                        preparedStatement.setLong(6, session.getLastAccessedTime());
                        preparedStatement.execute();
                        i = 0;
                        continue;
                    }
                }
                catch (SQLException sQLException) {
                    this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".SQLException", new Object[]{sQLException}));
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    this.release(connection);
                }
            }
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace((Object)sm.getString(this.getStoreName() + ".saving", new Object[]{session.getIdInternal(), this.sessionTable}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection open() throws SQLException {
        if (this.dataSourceName != null && this.dataSource == null) {
            Context context = this.getManager().getContext();
            if (this.getLocalDataSource()) {
                ClassLoader classLoader = context.bind(Globals.IS_SECURITY_ENABLED, null);
                try {
                    javax.naming.Context context2 = (javax.naming.Context)new InitialContext().lookup("java:comp/env");
                    this.dataSource = (DataSource)context2.lookup(this.dataSourceName);
                }
                catch (NamingException namingException) {
                    context.getLogger().error((Object)sm.getString("dataSourceStore.wrongDataSource", new Object[]{this.dataSourceName}), (Throwable)namingException);
                }
                finally {
                    context.unbind(Globals.IS_SECURITY_ENABLED, classLoader);
                }
            } else {
                Object object;
                try {
                    Server server;
                    object = Container.getService(context);
                    if (object != null && (server = object.getServer()) != null) {
                        javax.naming.Context context3 = server.getGlobalNamingContext();
                        this.dataSource = (DataSource)context3.lookup(this.dataSourceName);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                if (this.dataSource == null) {
                    try {
                        object = (javax.naming.Context)new InitialContext().lookup("java:comp/env");
                        this.dataSource = (DataSource)object.lookup(this.dataSourceName);
                    }
                    catch (NamingException namingException) {
                        context.getLogger().error((Object)sm.getString("dataSourceStore.wrongDataSource", new Object[]{this.dataSourceName}), (Throwable)namingException);
                    }
                }
            }
        }
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        throw new IllegalStateException(sm.getString(this.getStoreName() + ".missingDataSource"));
    }

    @Override
    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".commitSQLException"), (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.manager.getContext().getLogger().error((Object)sm.getString(this.getStoreName() + ".close", new Object[]{sQLException.toString()}));
        }
    }
}

