/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.JMethodIdTable;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeMemoryCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeObjAllocTermCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.RuntimeObjLivenessTermCCTNode;

public abstract class MemoryResultsSnapshot
extends ResultsSnapshot {
    private JMethodIdTable table;
    String[] classNames;
    long[] objectsSizePerClass;
    private RuntimeMemoryCCTNode[] stacksForClasses;
    int nProfiledClasses;

    public MemoryResultsSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryResultsSnapshot(long beginTime, long timeTaken, MemoryCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken);
        ProfilingSessionStatus status = client.getStatus();
        status.beginTrans(false);
        try {
            this.performInit(client, provider);
        }
        finally {
            status.endTrans();
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.debugValues();
            }
        }
    }

    public String getClassName(int classId) {
        return this.classNames[classId];
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public JMethodIdTable getJMethodIdTable() {
        return this.table;
    }

    public int getNProfiledClasses() {
        return this.nProfiledClasses;
    }

    public long[] getObjectsSizePerClass() {
        return this.objectsSizePerClass;
    }

    public boolean containsStacks() {
        return this.stacksForClasses != null;
    }

    public abstract MemoryResultsSnapshot createDiff(MemoryResultsSnapshot var1);

    public void filterReverse(String filter, int filterType, int sortBy, boolean sortOrder, PresoObjAllocCCTNode root, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        PresoObjAllocCCTNode rev = this.createPresentationCCT(classId, dontShowZeroLiveObjAllocPaths);
        this.filter(filter, filterType, rev);
        root.children = rev.children;
        if (root.children != null) {
            for (PresoObjAllocCCTNode ch : root.children) {
                ch.parent = root;
            }
            root.sortChildren(sortBy, sortOrder);
        }
        if (!FilterSortSupport.passesFilter(filter, filterType, root.getNodeName())) {
            // empty if block
        }
    }

    private void filter(String filter, int filterType, PresoObjAllocCCTNode node) {
        if (node.children != null) {
            PresoObjAllocCCTNode filtered = null;
            ArrayList<PresoObjAllocCCTNode> ch = new ArrayList<PresoObjAllocCCTNode>();
            for (PresoObjAllocCCTNode n : node.children) {
                PresoObjAllocCCTNode nn = n;
                if (FilterSortSupport.passesFilter(filter, filterType, nn.getNodeName())) {
                    int i = ch.indexOf(nn);
                    if (i == -1) {
                        ch.add(nn);
                        continue;
                    }
                    ((PresoObjAllocCCTNode)ch.get(i)).merge(nn);
                    continue;
                }
                if (filtered == null) {
                    filtered = nn;
                    ch.add(nn);
                    continue;
                }
                filtered.merge(nn);
            }
            if (ch.isEmpty()) {
                node.children = null;
            } else if (node.isFiltered() && filtered != null && ch.size() == 1) {
                PresoObjAllocCCTNode n = (PresoObjAllocCCTNode)ch.get(0);
                this.filter(filter, filterType, n);
                node.children = n.children;
            } else {
                node.children = ch.toArray(new PresoObjAllocCCTNode[0]);
            }
            if (node.children != null) {
                for (PresoObjAllocCCTNode n : node.children) {
                    this.filter(filter, filterType, n);
                }
            }
        }
    }

    public PresoObjAllocCCTNode createPresentationCCT(int classId, boolean dontShowZeroLiveObjAllocPaths) {
        if (this.stacksForClasses == null) {
            return null;
        }
        RuntimeMemoryCCTNode rootNode = this.stacksForClasses[classId];
        if (rootNode == null) {
            return null;
        }
        return this.createPresentationCCT(rootNode, classId, dontShowZeroLiveObjAllocPaths);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.nProfiledClasses = in.readInt();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        for (int i = 0; i < this.nProfiledClasses; ++i) {
            this.classNames[i] = in.readUTF();
            this.objectsSizePerClass[i] = in.readLong();
        }
        if (in.readBoolean()) {
            int len = in.readInt();
            this.stacksForClasses = new RuntimeMemoryCCTNode[len];
            for (int i = 0; i < len; ++i) {
                int type = in.readInt();
                if (type == 0) continue;
                this.stacksForClasses[i] = RuntimeMemoryCCTNode.create(type);
                this.stacksForClasses[i].readFromStream(in);
            }
            if (in.readBoolean()) {
                this.table = new JMethodIdTable();
                this.table.readFromStream(in);
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeInt(this.nProfiledClasses);
        for (int i = 0; i < this.nProfiledClasses; ++i) {
            out.writeUTF(this.classNames[i]);
            out.writeLong(this.objectsSizePerClass[i]);
        }
        out.writeBoolean(this.stacksForClasses != null);
        if (this.stacksForClasses != null) {
            out.writeInt(this.stacksForClasses.length);
            for (RuntimeMemoryCCTNode stacksForClasse : this.stacksForClasses) {
                if (stacksForClasse == null) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(stacksForClasse.getType());
                stacksForClasse.writeToStream(out);
            }
            out.writeBoolean(this.table != null);
            if (this.table != null) {
                this.table.writeToStream(out);
            }
        }
    }

    protected abstract PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode var1, int var2, boolean var3);

    protected void performInit(ProfilerClient client, MemoryCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        this.nProfiledClasses = provider.getNProfiledClasses();
        int len = 0;
        if (provider.getObjectsSizePerClass() != null) {
            len = provider.getObjectsSizePerClass().length;
            this.objectsSizePerClass = new long[len];
            System.arraycopy(provider.getObjectsSizePerClass(), 0, this.objectsSizePerClass, 0, len);
        }
        String[] s_classNames = client.getStatus().getClassNames();
        len = this.nProfiledClasses;
        this.classNames = new String[len];
        System.arraycopy(s_classNames, 0, this.classNames, 0, len);
        RuntimeMemoryCCTNode[] stacks = provider.getStacksForClasses();
        if (stacks != null && this.checkContainsStacks(stacks)) {
            this.stacksForClasses = new RuntimeMemoryCCTNode[stacks.length];
            for (int i = 0; i < this.stacksForClasses.length; ++i) {
                if (stacks[i] == null) continue;
                this.stacksForClasses[i] = (RuntimeMemoryCCTNode)stacks[i].clone();
            }
            this.table = new JMethodIdTable(client.getJMethodIdTable());
        }
    }

    private boolean checkContainsStacks(RuntimeMemoryCCTNode[] stacksForClasses) {
        for (RuntimeMemoryCCTNode stacksForClass : stacksForClasses) {
            if (stacksForClass == null || stacksForClass instanceof RuntimeObjAllocTermCCTNode || stacksForClass instanceof RuntimeObjLivenessTermCCTNode) continue;
            return true;
        }
        return false;
    }

    void debugValues() {
        LOGGER.finest("nProfiledClasses: " + this.nProfiledClasses);
        LOGGER.finest("stacksForClasses.length: " + this.debugLength(this.stacksForClasses));
        LOGGER.finest("objectsSizePerClass.length: " + this.debugLength(this.objectsSizePerClass));
        LOGGER.finest("classNames.length: " + this.debugLength(this.classNames));
        LOGGER.finest("table: " + (this.table == null ? "null" : this.table.debug()));
    }
}

