/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;

class WinFlatEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final Color background = UIManager.getColor("EditorTab.background");
    private static final Color activeBackground = WinFlatUtils.Utils.getUIColor("EditorTab.activeBackground", background);
    private static final Color selectedBackground = WinFlatUtils.Utils.getUIColor("EditorTab.selectedBackground", activeBackground);
    private static final Color selectedBackgroundBottomGradient = WinFlatUtils.Utils.getUIColor("EditorTab.selectedBackgroundBottomGradient", selectedBackground);
    private static final Color hoverBackground = UIManager.getColor("EditorTab.hoverBackground");
    private static final Color unselectedHoverBackground = WinFlatUtils.Utils.getUIColor("EditorTab.unselectedHoverBackground", hoverBackground);
    private static final Color attentionBackground = UIManager.getColor("EditorTab.attentionBackground");
    private static final Color foreground = WinFlatUtils.Utils.getUIColor("EditorTab.foreground", "TabbedPane.foreground");
    private static final Color activeForeground = WinFlatUtils.Utils.getUIColor("EditorTab.activeForeground", foreground);
    private static final Color selectedForeground = WinFlatUtils.Utils.getUIColor("EditorTab.selectedForeground", activeForeground);
    private static final Color hoverForeground = WinFlatUtils.Utils.getUIColor("EditorTab.hoverForeground", foreground);
    private static final Color attentionForeground = WinFlatUtils.Utils.getUIColor("EditorTab.attentionForeground", foreground);
    private static final Color underlineColor = UIManager.getColor("EditorTab.underlineColor");
    private static final Color inactiveUnderlineColor = UIManager.getColor("EditorTab.inactiveUnderlineColor");
    private static final Color tabSeparatorColor = UIManager.getColor("EditorTab.tabSeparatorColor");
    private static final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private static final Insets tabInsets = WinFlatUtils.UIScale.scale(UIManager.getInsets("EditorTab.tabInsets"));
    private static final int underlineHeight = WinFlatUtils.UIScale.scale(UIManager.getInt("EditorTab.underlineHeight"));
    private static final boolean underlineAtTop = UIManager.getBoolean("EditorTab.underlineAtTop");
    private static boolean showTabSeparators = UIManager.getBoolean("EditorTab.showTabSeparators");
    private static final int CLOSE_ICON_RIGHT_PAD = WinFlatEditorTabCellRenderer.tabInsets.left;
    private static final boolean showSelectedTabBorder = WinFlatUtils.Utils.getUIBoolean("EditorTab.showSelectedTabBorder", false);
    private static final boolean unscaledBorders = WinFlatUtils.Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private static final FlatTabPainter leftClipPainter = new FlatTabPainter(true, false);
    private static final FlatTabPainter noClipPainter = new FlatTabPainter(false, false);
    private static final FlatTabPainter rightClipPainter = new FlatTabPainter(false, true);
    boolean firstTab;
    boolean lastTab;
    boolean nextTabSelected;

    public WinFlatEditorTabCellRenderer() {
        super(leftClipPainter, noClipPainter, rightClipPainter, new Dimension(WinFlatEditorTabCellRenderer.tabInsets.left + WinFlatEditorTabCellRenderer.tabInsets.right, WinFlatEditorTabCellRenderer.tabInsets.top + WinFlatEditorTabCellRenderer.tabInsets.bottom));
    }

    @Override
    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        if (this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton")) {
            dimension.width += this.findCloseIcon().getIconWidth() + WinFlatUtils.UIScale.scale(CLOSE_ICON_RIGHT_PAD);
        }
        return dimension;
    }

    @Override
    protected int getCaptionYAdjustment() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        Insets insets = this.getInsets();
        int n2 = this.getHeight() - (insets.top + insets.bottom);
        int n3 = -1;
        return (n2 <= n ? -fontMetrics.getDescent() : -1) + n3;
    }

    @Override
    protected int stateChanged(int n, int n2) {
        int n3 = super.stateChanged(n, n2);
        this.setForeground(this.colorForState(foreground, activeForeground, selectedForeground, hoverForeground, hoverForeground, attentionForeground));
        return n3;
    }

    private Color colorForState(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        return this.isAttention() ? color6 : (this.isArmed() ? (this.isSelected() ? color4 : color5) : (this.isSelected() ? color3 : (this.isActive() ? color2 : color)));
    }

    private Icon findCloseIcon() {
        return WinFlatUtils.FlatTabControlIcon.get(1, this.inCloseButton() ? (this.isPressed() ? 1 : 3) : 0);
    }

    private static class FlatTabPainter
    implements TabPainter {
        final boolean leftClip;
        final boolean rightClip;

        public FlatTabPainter(boolean bl, boolean bl2) {
            this.leftClip = bl;
            this.rightClip = bl2;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return tabInsets;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            WinFlatEditorTabCellRenderer winFlatEditorTabCellRenderer = (WinFlatEditorTabCellRenderer)jComponent;
            if (!winFlatEditorTabCellRenderer.isShowCloseButton() || this.leftClip || this.rightClip) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            Icon icon = winFlatEditorTabCellRenderer.findCloseIcon();
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            rectangle.x = rectangle2.x + rectangle2.width - n - WinFlatUtils.UIScale.scale(CLOSE_ICON_RIGHT_PAD);
            int n3 = 2;
            rectangle.y = rectangle2.y + Math.max(0, (rectangle2.height - n2) / 2) - 1 + n3;
            rectangle.width = n;
            rectangle.height = n2;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            int n = 0;
            int n2 = 0;
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + n3, n2);
            polygon.addPoint(n + n3, n2 + n4);
            polygon.addPoint(n, n2 + n4);
            return polygon;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            WinFlatUtils.HiDPIUtils.paintAtScale1x(graphics, 0, 0, component.getWidth(), component.getHeight(), (graphics2D, n, n2, d) -> this.paintInteriorAtScale1x(graphics2D, component, n, n2, d));
            WinFlatEditorTabCellRenderer winFlatEditorTabCellRenderer = (WinFlatEditorTabCellRenderer)component;
            if (!winFlatEditorTabCellRenderer.isClipLeft() && !winFlatEditorTabCellRenderer.isClipRight()) {
                this.paintCloseButton(graphics, winFlatEditorTabCellRenderer);
            }
        }

        private static void fillGradientRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
            if (color2.equals(color)) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, n2 + n5, color, 0.0f, n2 + n4 - n5, color2, false));
            }
            graphics2D.fillRect(n, n2, n3, n4);
        }

        private void paintInteriorAtScale1x(Graphics2D graphics2D, Component component, int n, int n2, double d) {
            WinFlatEditorTabCellRenderer winFlatEditorTabCellRenderer = (WinFlatEditorTabCellRenderer)component;
            boolean bl = winFlatEditorTabCellRenderer.isSelected();
            Color color = winFlatEditorTabCellRenderer.colorForState(background, activeBackground, selectedBackground, hoverBackground, unselectedHoverBackground, attentionBackground);
            boolean bl2 = showTabSeparators && !winFlatEditorTabCellRenderer.lastTab && !bl && !winFlatEditorTabCellRenderer.nextTabSelected && !this.rightClip;
            int n3 = unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(d, 1);
            int n4 = bl2 ? n3 : 0;
            int n5 = (int)Math.round((double)underlineHeight * d);
            FlatTabPainter.fillGradientRect(graphics2D, 0, 0, n - (color != background ? n4 : 0), n2, color, bl && !selectedBackground.equals(selectedBackgroundBottomGradient) ? selectedBackgroundBottomGradient : color, underlineAtTop ? n5 : 0);
            if (bl) {
                if (showSelectedTabBorder) {
                    graphics2D.setColor(contentBorderColor);
                    graphics2D.fillRect(0, 0, n - n4, n3);
                    if (!this.leftClip) {
                        graphics2D.fillRect(0, 0, n3, n2);
                    }
                    if (!this.rightClip) {
                        graphics2D.fillRect(n - n4 - n3, 0, n3, n2);
                    }
                }
                if (n5 > 0) {
                    graphics2D.setColor(winFlatEditorTabCellRenderer.isActive() ? underlineColor : inactiveUnderlineColor);
                    if (underlineAtTop) {
                        graphics2D.fillRect(0, 0, n - n4, n5);
                    } else {
                        graphics2D.fillRect(0, n2 - n5, n - n4, n5);
                    }
                }
            } else {
                graphics2D.setColor(contentBorderColor);
                graphics2D.fillRect(0, n2 - n3, n, n3);
            }
            if (bl2) {
                int n6 = (int)(4.0 * d);
                graphics2D.setColor(tabSeparatorColor);
                graphics2D.fillRect(n - n4, n6, n4, n2 - n6 * 2 - 1);
            }
        }

        private void paintCloseButton(Graphics graphics, WinFlatEditorTabCellRenderer winFlatEditorTabCellRenderer) {
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(winFlatEditorTabCellRenderer, rectangle, new Rectangle(0, 0, winFlatEditorTabCellRenderer.getWidth(), winFlatEditorTabCellRenderer.getHeight()));
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            Icon icon = winFlatEditorTabCellRenderer.findCloseIcon();
            icon.paintIcon(winFlatEditorTabCellRenderer, graphics, rectangle.x, rectangle.y);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return jComponent instanceof TabDisplayer ? ((TabDisplayer)jComponent).isShowCloseButton() : true;
        }
    }
}

