
//==--------- builtins_vector_gen.hpp - SYCL generated built-in functions ---------==//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// NOTE: This file was generated and should not be changed!

#pragma once

#include <sycl/builtins_utils_vec.hpp>

// TODO Decide whether to mark functions with this attribute.
#define __NOEXC /*noexcept*/

namespace sycl {
inline namespace _V1 {

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> acos(T0 a0) __NOEXC {
  return __sycl_std::__invoke_acos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> acosh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_acosh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> acospi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_acospi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> asin(T0 a0) __NOEXC {
  return __sycl_std::__invoke_asin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> asinh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_asinh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> asinpi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_asinpi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> atan(T0 a0) __NOEXC {
  return __sycl_std::__invoke_atan<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> atan2(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_atan2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> atanh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_atanh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> atanpi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_atanpi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> atan2pi(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_atan2pi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cbrt(T0 a0) __NOEXC {
  return __sycl_std::__invoke_cbrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> ceil(T0 a0) __NOEXC {
  return __sycl_std::__invoke_ceil<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> copysign(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_copysign<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cos(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_cos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_cos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cosh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_cosh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cospi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_cospi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> erfc(T0 a0) __NOEXC {
  return __sycl_std::__invoke_erfc<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> erf(T0 a0) __NOEXC {
  return __sycl_std::__invoke_erf<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_exp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_exp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp2(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_exp2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_exp2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp10(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_exp10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_exp10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> expm1(T0 a0) __NOEXC {
  return __sycl_std::__invoke_expm1<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> fabs(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fabs<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> fdim(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fdim<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> floor(T0 a0) __NOEXC {
  return __sycl_std::__invoke_floor<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> fma(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_fma<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> fmax(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmax<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> fmax(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_fmax<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> fmin(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> fmin(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_fmin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> fmod(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmod<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, float, double, half> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> fract(T0 a0, T1* a1) __NOEXC {
  return __sycl_std::__invoke_fract<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<T0>>), detail::simplify_if_swizzle_t<T0>> fract(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fract<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::change_elements_t<int32_t, T0>>), detail::simplify_if_swizzle_t<T0>> frexp(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_frexp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, int32_t> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> frexp(T0 a0, T1* a1) __NOEXC {
  return __sycl_std::__invoke_frexp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> hypot(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_hypot<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::int_elements_t<detail::simplify_if_swizzle_t<T0>>> ilogb(T0 a0) __NOEXC {
  return __sycl_std::__invoke_ilogb<detail::int_elements_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, int32_t, int> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> ldexp(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_ldexp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> ldexp(T0 a0, int a1) __NOEXC {
  constexpr size_t N = detail::num_elements<T0>::value;  return __sycl_std::__invoke_ldexp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), vec<int, N>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> lgamma(T0 a0) __NOEXC {
  return __sycl_std::__invoke_lgamma<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::change_elements_t<int32_t, T0>>), detail::simplify_if_swizzle_t<T0>> lgamma_r(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, int32_t> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> lgamma_r(T0 a0, T1* a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_log<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_log<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log2(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_log2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_log2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log10(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_log10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_log10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log1p(T0 a0) __NOEXC {
  return __sycl_std::__invoke_log1p<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> logb(T0 a0) __NOEXC {
  return __sycl_std::__invoke_logb<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_mad<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> maxmag(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_maxmag<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> minmag(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_minmag<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, float, double, half> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> modf(T0 a0, T1* a1) __NOEXC {
  return __sycl_std::__invoke_modf<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<T0>>), detail::simplify_if_swizzle_t<T0>> modf(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_modf<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t, unsigned int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>> nan(T0 a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<T0>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint64_t, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>> nan(T0 a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<T0>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint16_t, unsigned short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>> nan(T0 a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<T0>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<detail::simplify_if_swizzle_t<T0>>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> nextafter(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_nextafter<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> pow(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_pow<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, int32_t, int> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> pown(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_pown<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> powr(T0 a0, T1 a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_powr<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));}
  return __sycl_std::__invoke_powr<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> remainder(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_remainder<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_multi_ptr_v<T2> && detail::has_writeable_addr_space_v<T2> && detail::is_valid_elem_type_v<T2, detail::change_elements_t<int32_t, T0>>), detail::simplify_if_swizzle_t<T0>> remquo(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_remquo<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), a2);
}

template <typename T0, typename T1, typename T2>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int32_t> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> remquo(T0 a0, T1 a1, T2* a2) __NOEXC {
  return __sycl_std::__invoke_remquo<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), a2);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> rint(T0 a0) __NOEXC {
  return __sycl_std::__invoke_rint<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, int32_t, int> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> rootn(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_rootn<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> round(T0 a0) __NOEXC {
  return __sycl_std::__invoke_round<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> rsqrt(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_rsqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_rsqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sin(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_sin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_sin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, float, double, half> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sincos(T0 a0, T1* a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    *a1 = __sycl_std::__invoke_native_cos<detail::simplify_if_swizzle_t<T0>>(a0);
    return __sycl_std::__invoke_native_sin<detail::simplify_if_swizzle_t<T0>>(a0);}
  return __sycl_std::__invoke_sincos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<T0>>), detail::simplify_if_swizzle_t<T0>> sincos(T0 a0, T1 a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    *a1 = __sycl_std::__invoke_native_cos<detail::simplify_if_swizzle_t<T0>>(a0);
    return __sycl_std::__invoke_native_sin<detail::simplify_if_swizzle_t<T0>>(a0);}
  return __sycl_std::__invoke_sincos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sinh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_sinh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sinpi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_sinpi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sqrt(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_sqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_sqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tan(T0 a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<T0>) {    return __sycl_std::__invoke_native_tan<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));}
  return __sycl_std::__invoke_tan<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tanh(T0 a0) __NOEXC {
  return __sycl_std::__invoke_tanh<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tanpi(T0 a0) __NOEXC {
  return __sycl_std::__invoke_tanpi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tgamma(T0 a0) __NOEXC {
  return __sycl_std::__invoke_tgamma<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> trunc(T0 a0) __NOEXC {
  return __sycl_std::__invoke_trunc<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> abs_diff(T0 a0, T1 a1) __NOEXC {
return __sycl_std::__invoke_s_abs_diff<detail::make_unsigned_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0) ,detail::simplify_if_swizzle_t<T1>(a1)).template convert<detail::get_elem_type_t<detail::simplify_if_swizzle_t<T0>>>();
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> abs_diff(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_abs_diff<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> add_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_add_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> add_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_add_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> hadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_hadd<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> hadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_hadd<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> rhadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_rhadd<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> rhadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_rhadd<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clz(T0 a0) __NOEXC {
  return __sycl_std::__invoke_clz<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> ctz(T0 a0) __NOEXC {
  return __sycl_std::__invoke_ctz<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad_hi(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad_hi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad_hi(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad_hi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad_sat(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad_sat(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mul_hi(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_mul_hi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mul_hi(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_mul_hi<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> rotate(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_rotate<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> sub_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_sub_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> sub_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_sub_sat<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, char, signed char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, uint8_t, unsigned char> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, unsigned char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int16_t, short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, uint16_t, unsigned short> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint16_t, unsigned short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int32_t, int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && (detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, uint32_t, unsigned int> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t, unsigned int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> popcount(T0 a0) __NOEXC {
  return __sycl_std::__invoke_popcount<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int32_t> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad24(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad24<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mad24(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad24<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int32_t> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mul24(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_mul24<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mul24(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_mul24<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_fclamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, float a1, float a2) __NOEXC {
  return __sycl_std::__invoke_fclamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, double a1, double a2) __NOEXC {
  return __sycl_std::__invoke_fclamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, half a1, half a2) __NOEXC {
  return __sycl_std::__invoke_fclamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_clamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_clamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, detail::get_elem_type_t<T0> a1, detail::get_elem_type_t<T0> a2) __NOEXC {
  return __sycl_std::__invoke_s_clamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1, a2);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> clamp(T0 a0, detail::get_elem_type_t<T0> a1, detail::get_elem_type_t<T0> a2) __NOEXC {
  return __sycl_std::__invoke_u_clamp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1, a2);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> degrees(T0 a0) __NOEXC {
  return __sycl_std::__invoke_degrees<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmax_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fmax_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fmax_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fmax_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_max<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_max<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_s_max<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (max)(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_u_max<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmin_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fmin_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fmin_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fmin_common<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T0>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_min<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_min<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_s_min<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> (min)(T0 a0, detail::get_elem_type_t<T0> a1) __NOEXC {
  return __sycl_std::__invoke_u_min<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), a1);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> mix(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_mix<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mix(T0 a0, T1 a1, float a2) __NOEXC {
  return __sycl_std::__invoke_mix<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mix(T0 a0, T1 a1, double a2) __NOEXC {
  return __sycl_std::__invoke_mix<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> mix(T0 a0, T1 a1, half a2) __NOEXC {
  return __sycl_std::__invoke_mix<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T0>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> radians(T0 a0) __NOEXC {
  return __sycl_std::__invoke_radians<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> step(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_step<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, float> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T1>> step(float a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_step<detail::simplify_if_swizzle_t<T1>>(detail::simplify_if_swizzle_t<T1>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, double> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T1>> step(double a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_step<detail::simplify_if_swizzle_t<T1>>(detail::simplify_if_swizzle_t<T1>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T1> && detail::is_valid_elem_type_v<T1, half> && detail::is_valid_size_v<T1, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T1>> step(half a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_step<detail::simplify_if_swizzle_t<T1>>(detail::simplify_if_swizzle_t<T1>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> smoothstep(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_smoothstep<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, float> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T2>> smoothstep(float a0, float a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_smoothstep<detail::simplify_if_swizzle_t<T2>>(detail::simplify_if_swizzle_t<T2>(a0), detail::simplify_if_swizzle_t<T2>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, double> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T2>> smoothstep(double a0, double a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_smoothstep<detail::simplify_if_swizzle_t<T2>>(detail::simplify_if_swizzle_t<T2>(a0), detail::simplify_if_swizzle_t<T2>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, half> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T2>> smoothstep(half a0, half a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_smoothstep<detail::simplify_if_swizzle_t<T2>>(detail::simplify_if_swizzle_t<T2>(a0), detail::simplify_if_swizzle_t<T2>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sign(T0 a0) __NOEXC {
  return __sycl_std::__invoke_sign<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
__SYCL_DEPRECATED("abs for floating point types is non-standard and has been deprecated. Please use fabs instead.")
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> abs(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fabs<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> abs(T0 a0) __NOEXC {
return __sycl_std::__invoke_s_abs<detail::make_unsigned_t<detail::simplify_if_swizzle_t<T0>>>(detail::simplify_if_swizzle_t<T0>(a0)).template convert<detail::get_elem_type_t<detail::simplify_if_swizzle_t<T0>>>();
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, uint16_t, uint32_t, uint64_t, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> abs(T0 a0) __NOEXC {
  return __sycl_std::__invoke_u_abs<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> cross(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_cross<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> cross(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_cross<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> cross(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_cross<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, float> dot(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_Dot<float>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, double> dot(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_Dot<double>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, half> dot(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_Dot<half>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, float> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<float>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, double> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<double>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, half> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<half>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), float> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<float>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), double> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<double>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), half> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<half>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, float> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<float>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, double> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<double>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>) && detail::check_all_same_op_type_v<T0, T1>, half> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<half>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), float> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<float>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), double> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<double>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), half> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<half>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4>), detail::simplify_if_swizzle_t<T0>> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isequal(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdEqual<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isnotequal(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FUnordNotEqual<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isgreater(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdGreaterThan<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isgreaterequal(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdGreaterThanEqual<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isless(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdLessThan<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> islessequal(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdLessThanEqual<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> islessgreater(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_FOrdNotEqual<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isfinite(T0 a0) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_IsFinite<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isinf(T0 a0) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_IsInf<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isnan(T0 a0) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_IsNan<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isnormal(T0 a0) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_IsNormal<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isordered(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_Ordered<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> isunordered(T0 a0, T1 a1) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_Unordered<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float, double, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>> signbit(T0 a0) __NOEXC {
  return detail::RelConverter<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>::apply(__sycl_std::__invoke_SignBitSet<detail::internal_rel_ret_t<detail::same_size_signed_int_t<detail::simplify_if_swizzle_t<T0>>>>(detail::simplify_if_swizzle_t<T0>(a0)));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), int> any(T0 a0) __NOEXC {
  using VecT = detail::simplify_if_swizzle_t<T0>;
  return detail::rel_sign_bit_test_ret_t<detail::simplify_if_swizzle_t<VecT>>(
      __sycl_std::__invoke_Any<detail::rel_sign_bit_test_ret_t<VecT>>(
          detail::rel_sign_bit_test_arg_t<VecT>(detail::simplify_if_swizzle_t<T0>(a0))));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, char, signed char, short, int, long, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), int> all(T0 a0) __NOEXC {
  using VecT = detail::simplify_if_swizzle_t<T0>;
  return detail::rel_sign_bit_test_ret_t<detail::simplify_if_swizzle_t<VecT>>(
      __sycl_std::__invoke_All<detail::rel_sign_bit_test_ret_t<VecT>>(
          detail::rel_sign_bit_test_arg_t<VecT>(detail::simplify_if_swizzle_t<T0>(a0))));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, int16_t, int32_t, int64_t, uint8_t, uint16_t, uint32_t, uint64_t, float, double, half, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> bitselect(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_bitselect<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, char, signed char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int16_t, short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int32_t, int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int64_t, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, unsigned char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int8_t, char, signed char> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint16_t, unsigned short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int16_t, short> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t, unsigned int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int32_t, int> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint64_t, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int64_t, long long> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int32_t, int> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int64_t, long long> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, int16_t, short> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int8_t, char, signed char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint8_t, unsigned char> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int16_t, short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint16_t, unsigned short> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int32_t, int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint32_t, unsigned int> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, int64_t, long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint64_t, unsigned long long> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint8_t, unsigned char> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint16_t, unsigned short> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint32_t, unsigned int> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, uint64_t, unsigned long long> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1, T2>, detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint32_t, unsigned int> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, double> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint64_t, unsigned long long> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, half> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1> && (detail::is_vec_or_swizzle_v<T2> && detail::is_valid_elem_type_v<T2, uint16_t, unsigned short> && detail::is_valid_size_v<T2, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1), detail::simplify_if_swizzle_t<T2>(a2));
}

namespace native {
template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cos(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_cos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> divide(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_native_divide<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_exp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp2(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_exp2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp10(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_exp10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_log<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log2(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_log2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log10(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_log10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> powr(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_native_powr<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> recip(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_recip<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> rsqrt(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_rsqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sin(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_sin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sqrt(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_sqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tan(T0 a0) __NOEXC {
  return __sycl_std::__invoke_native_tan<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}
} // namespace native

namespace half_precision {
template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> cos(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_cos<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> divide(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_half_divide<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_exp<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp2(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_exp2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> exp10(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_exp10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_log<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log2(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_log2<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> log10(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_log10<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>) && detail::check_all_same_op_type_v<T0, T1>, detail::simplify_if_swizzle_t<T0>> powr(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_half_powr<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0), detail::simplify_if_swizzle_t<T1>(a1));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> recip(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_recip<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> rsqrt(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_rsqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sin(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_sin<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> sqrt(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_sqrt<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}

template <typename T0>
std::enable_if_t<(detail::is_vec_or_swizzle_v<T0> && detail::is_valid_elem_type_v<T0, float> && detail::is_valid_size_v<T0, 1, 2, 3, 4, 8, 16>), detail::simplify_if_swizzle_t<T0>> tan(T0 a0) __NOEXC {
  return __sycl_std::__invoke_half_tan<detail::simplify_if_swizzle_t<T0>>(detail::simplify_if_swizzle_t<T0>(a0));
}
} // namespace half_precision

} // namespace _V1
} // namespace sycl

#undef __NOEXC
