/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    public BandedSampleModel(int dataType, int w, int h, int numBands) {
        super(dataType, w, h, 1, w, BandedSampleModel.createIndicesArray(numBands), BandedSampleModel.createOffsetArray(numBands));
    }

    public BandedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, 1, scanlineStride, bankIndices, bandOffsets);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] bandOffs = this.numBanks == 1 ? this.orderBands(this.bandOffsets, w * h) : new int[this.bandOffsets.length];
        BandedSampleModel sampleModel = new BandedSampleModel(this.dataType, w, h, w, this.bankIndices, bandOffs);
        return sampleModel;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] newBankIndices = new int[bands.length];
        int[] newBandOffsets = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            newBankIndices[i] = this.bankIndices[bands[i]];
            newBandOffsets[i] = this.bandOffsets[bands[i]];
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, newBankIndices, newBandOffsets);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int size = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(size, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(size, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(size, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(size, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(size, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(size, this.numBanks);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataType is not one of the supported types.");
            }
        }
        return dataBuffer;
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        int pixelOffset = y * this.scanlineStride + x;
        switch (type) {
            case 0: {
                byte[] bdata = obj == null ? new byte[numDataElems] : (byte[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    bdata[i] = (byte)data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                }
                obj = bdata;
                break;
            }
            case 1: 
            case 2: {
                short[] sdata = obj == null ? new short[numDataElems] : (short[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    sdata[i] = (short)data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                }
                obj = sdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[numDataElems] : (int[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    idata[i] = data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                }
                obj = idata;
                break;
            }
            case 4: {
                float[] fdata = obj == null ? new float[numDataElems] : (float[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    fdata[i] = data.getElemFloat(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                }
                obj = fdata;
                break;
            }
            case 5: {
                double[] ddata = obj == null ? new double[numDataElems] : (double[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    ddata[i] = data.getElemDouble(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
                }
                obj = ddata;
            }
        }
        return obj;
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] pixels = iArray != null ? iArray : new int[this.numBands];
        int pixelOffset = y * this.scanlineStride + x;
        for (int i = 0; i < this.numBands; ++i) {
            pixels[i] = data.getElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i]);
        }
        return pixels;
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int x1 = x + w;
        int y1 = y + h;
        if (x < 0 || x >= this.width || w > this.width || x1 < 0 || x1 > this.width || y < 0 || y >= this.height || h > this.height || y1 < 0 || y1 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] pixels = iArray != null ? iArray : new int[w * h * this.numBands];
        for (int k = 0; k < this.numBands; ++k) {
            int lineOffset = y * this.scanlineStride + x + this.bandOffsets[k];
            int srcOffset = k;
            int bank = this.bankIndices[k];
            for (int i = 0; i < h; ++i) {
                int pixelOffset = lineOffset;
                for (int j = 0; j < w; ++j) {
                    pixels[srcOffset] = data.getElem(bank, pixelOffset++);
                    srcOffset += this.numBands;
                }
                lineOffset += this.scanlineStride;
            }
        }
        return pixels;
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int sample = data.getElem(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
        return sample;
    }

    @Override
    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float sample = data.getElemFloat(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
        return sample;
    }

    @Override
    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double sample = data.getElemDouble(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b]);
        return sample;
    }

    @Override
    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] samples = iArray != null ? iArray : new int[w * h];
        int lineOffset = y * this.scanlineStride + x + this.bandOffsets[b];
        int srcOffset = 0;
        int bank = this.bankIndices[b];
        for (int i = 0; i < h; ++i) {
            int sampleOffset = lineOffset;
            for (int j = 0; j < w; ++j) {
                samples[srcOffset++] = data.getElem(bank, sampleOffset++);
            }
            lineOffset += this.scanlineStride;
        }
        return samples;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int type = this.getTransferType();
        int numDataElems = this.getNumDataElements();
        int pixelOffset = y * this.scanlineStride + x;
        switch (type) {
            case 0: {
                byte[] barray = (byte[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], barray[i] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sarray = (short[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], sarray[i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] iarray = (int[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], iarray[i]);
                }
                break;
            }
            case 4: {
                float[] farray = (float[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    data.setElemFloat(this.bankIndices[i], pixelOffset + this.bandOffsets[i], farray[i]);
                }
                break;
            }
            case 5: {
                double[] darray = (double[])obj;
                for (int i = 0; i < numDataElems; ++i) {
                    data.setElemDouble(this.bankIndices[i], pixelOffset + this.bandOffsets[i], darray[i]);
                }
                break;
            }
        }
    }

    @Override
    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int pixelOffset = y * this.scanlineStride + x;
        for (int i = 0; i < this.numBands; ++i) {
            data.setElem(this.bankIndices[i], pixelOffset + this.bandOffsets[i], iArray[i]);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int x1 = x + w;
        int y1 = y + h;
        if (x < 0 || x >= this.width || w > this.width || x1 < 0 || x1 > this.width || y < 0 || y >= this.height || h > this.height || y1 < 0 || y1 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        for (int k = 0; k < this.numBands; ++k) {
            int lineOffset = y * this.scanlineStride + x + this.bandOffsets[k];
            int srcOffset = k;
            int bank = this.bankIndices[k];
            for (int i = 0; i < h; ++i) {
                int pixelOffset = lineOffset;
                for (int j = 0; j < w; ++j) {
                    data.setElem(bank, pixelOffset++, iArray[srcOffset]);
                    srcOffset += this.numBands;
                }
                lineOffset += this.scanlineStride;
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        data.setElem(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        data.setElemFloat(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        data.setElemDouble(this.bankIndices[b], y * this.scanlineStride + x + this.bandOffsets[b], s);
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x + w > this.width || y + h > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int lineOffset = y * this.scanlineStride + x + this.bandOffsets[b];
        int srcOffset = 0;
        int bank = this.bankIndices[b];
        for (int i = 0; i < h; ++i) {
            int sampleOffset = lineOffset;
            for (int j = 0; j < w; ++j) {
                data.setElem(bank, sampleOffset++, iArray[srcOffset++]);
            }
            lineOffset += this.scanlineStride;
        }
    }

    private static int[] createOffsetArray(int numBands) {
        int[] bandOffsets = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bandOffsets[i] = 0;
        }
        return bandOffsets;
    }

    private static int[] createIndicesArray(int numBands) {
        int[] bankIndices = new int[numBands];
        for (int i = 0; i < numBands; ++i) {
            bankIndices[i] = i;
        }
        return bankIndices;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 2;
    }
}

