/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.nio.fs.DynamicFileAttributeView;

abstract class AbstractUserDefinedFileAttributeView
implements UserDefinedFileAttributeView,
DynamicFileAttributeView {
    protected AbstractUserDefinedFileAttributeView() {
    }

    protected void checkAccess(String file, boolean checkRead, boolean checkWrite) {
        assert (checkRead || checkWrite);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (checkRead) {
                sm.checkRead(file);
            }
            if (checkWrite) {
                sm.checkWrite(file);
            }
            sm.checkPermission(new RuntimePermission("accessUserDefinedAttributes"));
        }
    }

    @Override
    public final String name() {
        return "user";
    }

    @Override
    public final void setAttribute(String attribute, Object value) throws IOException {
        ByteBuffer bb = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : (ByteBuffer)value;
        this.write(attribute, bb);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, Object> readAttributes(String[] attributes) throws IOException {
        void var5_7;
        List<Object> names = new ArrayList();
        String[] arr$ = attributes;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            String name = arr$[var5_7];
            if (name.equals("*")) {
                names = this.list();
                break;
            }
            if (name.length() == 0) {
                throw new IllegalArgumentException();
            }
            names.add(name);
            ++var5_7;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String string : names) {
            int size;
            byte[] buf;
            int n = this.read(string, ByteBuffer.wrap(buf = new byte[size = this.size(string)]));
            byte[] value = n == size ? buf : Arrays.copyOf(buf, n);
            result.put(string, value);
        }
        return result;
    }
}

