/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.NameVariables;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public class MethodDeclaration
extends EntityDeclaration {
    public static final Role<Expression> DEFAULT_VALUE_ROLE = new Role<Expression>("DefaultValue", Expression.class, Expression.NULL);
    public static final TokenRole DEFAULT_KEYWORD = new TokenRole("default", 1);
    public static final TokenRole THROWS_KEYWORD = new TokenRole("throws", 1);

    public final AstType getPrivateImplementationType() {
        return (AstType)this.getChildByRole(PRIVATE_IMPLEMENTATION_TYPE_ROLE);
    }

    public final void setPrivateImplementationType(AstType type) {
        this.setChildByRole(PRIVATE_IMPLEMENTATION_TYPE_ROLE, type);
    }

    public final Expression getDefaultValue() {
        return this.getChildByRole(DEFAULT_VALUE_ROLE);
    }

    public final void setDefaultValue(Expression value) {
        this.setChildByRole(DEFAULT_VALUE_ROLE, value);
    }

    public final AstNodeCollection<AstType> getThrownTypes() {
        return this.getChildrenByRole(Roles.THROWN_TYPE);
    }

    public final AstNodeCollection<TypeDeclaration> getDeclaredTypes() {
        return this.getChildrenByRole(Roles.LOCAL_TYPE_DECLARATION);
    }

    public final AstNodeCollection<TypeParameterDeclaration> getTypeParameters() {
        return this.getChildrenByRole(Roles.TYPE_PARAMETER);
    }

    public final AstNodeCollection<ParameterDeclaration> getParameters() {
        return this.getChildrenByRole(Roles.PARAMETER);
    }

    public final BlockStatement getBody() {
        return this.getChildByRole(Roles.BODY);
    }

    public final void setBody(BlockStatement value) {
        NameVariables nv;
        NameVariables nameVariables = nv = value != null ? value.getUserData(Keys.NAME_VARIABLES) : null;
        if (nv != null) {
            this.putUserData(Keys.NAME_VARIABLES, nv);
        }
        this.setChildByRole(Roles.BODY, value);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.METHOD;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitMethodDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof MethodDeclaration) {
            MethodDeclaration otherDeclaration = (MethodDeclaration)other;
            return !otherDeclaration.isNull() && MethodDeclaration.matchString(this.getName(), otherDeclaration.getName()) && this.matchAnnotationsAndModifiers(otherDeclaration, match) && this.getPrivateImplementationType().matches(otherDeclaration.getPrivateImplementationType(), match) && this.getTypeParameters().matches(otherDeclaration.getTypeParameters(), match) && this.getReturnType().matches(otherDeclaration.getReturnType(), match) && this.getParameters().matches(otherDeclaration.getParameters(), match) && this.getBody().matches(otherDeclaration.getBody(), match);
        }
        return false;
    }

    public static MethodDeclaration forPattern(Pattern pattern) {
        return new PatternPlaceholder(VerifyArgument.notNull(pattern, "pattern"));
    }

    private static final class PatternPlaceholder
    extends MethodDeclaration {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role<?> role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }
}

