/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderSimple
extends TimeHeader {
    private final PrintScale printScale;
    private int delta = 0;

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h2 + 6.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h2 + 6.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderSimple(StringBounder stringBounder, TimeHeaderParameters thParam, PrintScale printScale) {
        super(thParam, new TimeScaleWink(thParam.getCellWidth(stringBounder), thParam.getScale(), printScale));
        this.printScale = printScale;
    }

    private Day increment(Day day) {
        if (this.delta == 0) {
            this.initDelta(day);
        }
        for (int i = 0; i < this.delta; ++i) {
            day = day.increment(this.printScale);
        }
        return day;
    }

    private void initDelta(Day day) {
        double x1 = this.getTimeScale().getStartingPosition(day);
        do {
            ++this.delta;
            day = day.increment();
        } while (this.getTimeScale().getStartingPosition(day) < x1 + 16.0);
    }

    private void drawSmallVlinesDay(UGraphic ug, double totalHeightWithoutFooter) {
        ug = ug.apply(this.getLineColor());
        ug = ug.apply(UTranslate.dy(6.0));
        ULine vbar = ULine.vline(totalHeightWithoutFooter + 2.0);
        Day i = this.getMin();
        while (i.compareTo(this.getMax().increment()) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(i);
            ug.apply(UTranslate.dx(x1)).draw(vbar);
            i = this.increment(i);
        }
    }

    private void drawSimpleDayCounter(UGraphic ug) {
        Day i = this.getMin();
        while (i.compareTo(this.getMax().increment()) <= 0) {
            int value = this.printScale == PrintScale.WEEKLY ? i.getAbsoluteDayNum() / 7 + 1 : i.getAbsoluteDayNum() + 1;
            UFont font = this.thParam.getStyle(SName.timeline, SName.day).getUFont();
            FontConfiguration fontConfiguration = this.getFontConfiguration(font, false, this.openFontColor());
            TextBlock num = Display.getWithNewlines(this.getPragma(), "" + value).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = this.getTimeScale().getStartingPosition(i);
            double x2 = this.printScale == PrintScale.WEEKLY ? this.getTimeScale().getEndingPosition(i.addDays(6)) : this.getTimeScale().getStartingPosition(this.increment(i));
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.getMax().increment()) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            i = this.increment(i);
        }
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawSmallVlinesDay(ug, totalHeightWithoutFooter);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug);
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSimpleDayCounter(ug);
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight(ug.getStringBounder());
        Pending pending = null;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.thParam.getColor(wink);
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            wink = wink.increment();
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderSimple.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

