/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.HashSet;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UHidden;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.Untranslated;

public final class SvekResult
extends AbstractTextBlock
implements IEntityImage {
    private final DotData dotData;
    private final DotStringFactory clusterManager;
    private MinMax minMax;

    public SvekResult(DotData dotData, DotStringFactory clusterManager) {
        this.dotData = dotData;
        this.clusterManager = clusterManager;
    }

    @Override
    public void drawU(UGraphic ug) {
        for (Cluster cluster : this.clusterManager.getBibliotekon().allCluster()) {
            if (cluster.getGroup().isPacked()) continue;
            cluster.drawU(ug);
        }
        Style style2 = this.getDefaultStyleDefinition(null).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        HColor borderColor = HColors.noGradient(style2.value(PName.LineColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet()));
        for (SvekNode node : this.clusterManager.getBibliotekon().allNodes()) {
            double minX = node.getMinX();
            double minY = node.getMinY();
            UGraphic ug2 = node.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            IEntityImage image = node.getImage();
            image.drawU(ug2.apply(new UTranslate(minX, minY)));
            if (!(image instanceof Untranslated)) continue;
            ((Untranslated)image).drawUntranslated(ug.apply(borderColor), minX, minY);
        }
        HashSet<String> ids = new HashSet<String>();
        this.computeKal();
        for (SvekEdge svekEdge : this.clusterManager.getBibliotekon().allLines()) {
            UGraphic ug2 = svekEdge.isHidden() ? ug.apply(UHidden.HIDDEN) : ug;
            svekEdge.setSharedIds(ids);
            svekEdge.drawU(ug2);
        }
        for (SvekNode node : this.clusterManager.getBibliotekon().allNodes()) {
            node.drawKals(ug);
        }
    }

    private void computeKal() {
        for (SvekEdge line : this.clusterManager.getBibliotekon().allLines()) {
            line.computeKal();
        }
        for (SvekNode node : this.clusterManager.getBibliotekon().allNodes()) {
            node.fixOverlap();
        }
    }

    private StyleSignature getDefaultStyleDefinition(Stereotype stereotype) {
        StyleSignatureBasic result = StyleSignatureBasic.of(SName.root, SName.element, this.dotData.getUmlDiagramType().getStyleName(), SName.arrow);
        return result.withTOBECHANGED(stereotype);
    }

    @Override
    public HColor getBackcolor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        if (this.minMax == null) {
            this.minMax = TextBlockUtils.getMinMax(this, stringBounder, false);
            this.clusterManager.moveDelta(6.0 - this.minMax.getMinX(), 6.0 - this.minMax.getMinY());
        }
        return this.minMax.getDimension().delta(0.0, 12.0);
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

