# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Comment message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # *
    #  A comment in a Gherkin document
    ##
    class Comment < Message
      ##
      # The location of the comment
      ##
      attr_reader :location

      ##
      # The text of the comment
      ##
      attr_reader :text

      def initialize(
        location: Location.new,
        text: ''
      )
        @location = location
        @text = text
        super()
      end

      ##
      # Returns a new Comment from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Comment.from_h(some_hash) # => #<Cucumber::Messages::Comment:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          location: Location.from_h(hash[:location]),
          text: hash[:text]
        )
      end
    end
  end
end
