/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.res.StringManager;

public class HttpParser {
    private static final StringManager sm = StringManager.getManager(HttpParser.class);
    private static final int ARRAY_SIZE = 128;
    private static final boolean[] IS_CONTROL = new boolean[128];
    private static final boolean[] IS_SEPARATOR = new boolean[128];
    private static final boolean[] IS_TOKEN = new boolean[128];
    private static final boolean[] IS_HEX = new boolean[128];
    private static final boolean[] IS_HTTP_PROTOCOL = new boolean[128];
    private static final boolean[] IS_ALPHA = new boolean[128];
    private static final boolean[] IS_NUMERIC = new boolean[128];
    private static final boolean[] IS_SCHEME = new boolean[128];
    private static final boolean[] IS_UNRESERVED = new boolean[128];
    private static final boolean[] IS_SUBDELIM = new boolean[128];
    private static final boolean[] IS_USERINFO = new boolean[128];
    private static final boolean[] IS_RELAXABLE = new boolean[128];
    private static final HttpParser DEFAULT;
    private final boolean[] IS_NOT_REQUEST_TARGET = new boolean[128];
    private final boolean[] IS_ABSOLUTEPATH_RELAXED = new boolean[128];
    private final boolean[] IS_QUERY_RELAXED = new boolean[128];

    public HttpParser(String string, String string2) {
        for (int i = 0; i < 128; ++i) {
            if (IS_CONTROL[i] || i == 32 || i == 34 || i == 35 || i == 60 || i == 62 || i == 92 || i == 94 || i == 96 || i == 123 || i == 124 || i == 125) {
                this.IS_NOT_REQUEST_TARGET[i] = true;
            }
            if (IS_USERINFO[i] || i == 64 || i == 47) {
                this.IS_ABSOLUTEPATH_RELAXED[i] = true;
            }
            if (!this.IS_ABSOLUTEPATH_RELAXED[i] && i != 63) continue;
            this.IS_QUERY_RELAXED[i] = true;
        }
        this.relax(this.IS_ABSOLUTEPATH_RELAXED, string);
        this.relax(this.IS_QUERY_RELAXED, string2);
    }

    public boolean isNotRequestTargetRelaxed(int n) {
        try {
            return this.IS_NOT_REQUEST_TARGET[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
    }

    public boolean isAbsolutePathRelaxed(int n) {
        try {
            return this.IS_ABSOLUTEPATH_RELAXED[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public boolean isQueryRelaxed(int n) {
        try {
            return this.IS_QUERY_RELAXED[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static String unquote(String string) {
        int n;
        int n2;
        if (string == null || string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            n2 = 1;
            n = string.length() - 1;
        } else {
            n2 = 0;
            n = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n; ++i) {
            char c = string.charAt(i);
            if (string.charAt(i) == '\\') {
                if (++i == n) {
                    return null;
                }
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isToken(int n) {
        try {
            return IS_TOKEN[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isToken(String string) {
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (HttpParser.isToken(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(int n) {
        try {
            return IS_HEX[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isNotRequestTarget(int n) {
        return DEFAULT.isNotRequestTargetRelaxed(n);
    }

    public static boolean isHttpProtocol(int n) {
        try {
            return IS_HTTP_PROTOCOL[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isAlpha(int n) {
        try {
            return IS_ALPHA[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isNumeric(int n) {
        try {
            return IS_NUMERIC[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isScheme(int n) {
        try {
            return IS_SCHEME[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isScheme(String string) {
        if (string == null) {
            return false;
        }
        if (string.isEmpty()) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!HttpParser.isAlpha(cArray[0])) {
            return false;
        }
        if (cArray.length > 1) {
            for (int i = 1; i < cArray.length; ++i) {
                if (HttpParser.isScheme(cArray[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isUserInfo(int n) {
        try {
            return IS_USERINFO[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    private static boolean isRelaxable(int n) {
        try {
            return IS_RELAXABLE[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public static boolean isAbsolutePath(int n) {
        return DEFAULT.isAbsolutePathRelaxed(n);
    }

    public static boolean isQuery(int n) {
        return DEFAULT.isQueryRelaxed(n);
    }

    public static boolean isControl(int n) {
        try {
            return IS_CONTROL[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static int skipLws(Reader reader) throws IOException {
        reader.mark(1);
        int n = reader.read();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
        return n;
    }

    static SkipResult skipConstant(Reader reader, String string) throws IOException {
        int n = string.length();
        HttpParser.skipLws(reader);
        reader.mark(n);
        int n2 = reader.read();
        for (int i = 0; i < n; ++i) {
            if (i == 0 && n2 == -1) {
                return SkipResult.EOF;
            }
            if (n2 != string.charAt(i)) {
                reader.reset();
                return SkipResult.NOT_FOUND;
            }
            if (i == n - 1) continue;
            n2 = reader.read();
        }
        return SkipResult.FOUND;
    }

    static String readToken(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        HttpParser.skipLws(reader);
        reader.mark(1);
        int n = reader.read();
        while (n != -1 && HttpParser.isToken(n)) {
            stringBuilder.append((char)n);
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
        if (n != -1 && stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    static String readDigits(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        HttpParser.skipLws(reader);
        reader.mark(1);
        int n = reader.read();
        while (n != -1 && HttpParser.isNumeric(n)) {
            stringBuilder.append((char)n);
            reader.mark(1);
            n = reader.read();
        }
        reader.reset();
        return stringBuilder.toString();
    }

    static long readLong(Reader reader) throws IOException {
        String string = HttpParser.readDigits(reader);
        if (string.length() == 0) {
            return -1L;
        }
        return Long.parseLong(string);
    }

    static String readQuotedString(Reader reader, boolean bl) throws IOException {
        HttpParser.skipLws(reader);
        int n = reader.read();
        if (n != 34) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('\"');
        }
        n = reader.read();
        while (n != 34) {
            if (n == -1) {
                return null;
            }
            if (n == 92) {
                n = reader.read();
                if (bl) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append((char)n);
            } else {
                stringBuilder.append((char)n);
            }
            n = reader.read();
        }
        if (bl) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    static String readTokenOrQuotedString(Reader reader, boolean bl) throws IOException {
        int n = HttpParser.skipLws(reader);
        if (n == 34) {
            return HttpParser.readQuotedString(reader, bl);
        }
        return HttpParser.readToken(reader);
    }

    static String readQuotedToken(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        HttpParser.skipLws(reader);
        reader.mark(1);
        int n = reader.read();
        if (n == 34) {
            bl = true;
        } else {
            if (n == -1 || !HttpParser.isToken(n)) {
                return null;
            }
            stringBuilder.append((char)n);
        }
        reader.mark(1);
        n = reader.read();
        while (n != -1 && HttpParser.isToken(n)) {
            stringBuilder.append((char)n);
            reader.mark(1);
            n = reader.read();
        }
        if (bl) {
            if (n != 34) {
                return null;
            }
        } else {
            reader.reset();
        }
        if (n != -1 && stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    static String readLhex(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        HttpParser.skipLws(reader);
        reader.mark(1);
        int n = reader.read();
        if (n == 34) {
            bl = true;
        } else {
            if (n == -1 || !HttpParser.isHex(n)) {
                return null;
            }
            if (65 <= n && n <= 70) {
                n += 32;
            }
            stringBuilder.append((char)n);
        }
        reader.mark(1);
        n = reader.read();
        while (n != -1 && HttpParser.isHex(n)) {
            if (65 <= n && n <= 70) {
                n += 32;
            }
            stringBuilder.append((char)n);
            reader.mark(1);
            n = reader.read();
        }
        if (bl) {
            if (n != 34) {
                return null;
            }
        } else {
            reader.reset();
        }
        if (n != -1 && stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    static double readWeight(Reader reader, char c) throws IOException {
        StringBuilder stringBuilder;
        int n;
        block12: {
            HttpParser.skipLws(reader);
            n = reader.read();
            if (n == -1 || n == c) {
                return 1.0;
            }
            if (n != 113) {
                HttpParser.skipUntil(reader, n, c);
                return 0.0;
            }
            HttpParser.skipLws(reader);
            n = reader.read();
            if (n != 61) {
                HttpParser.skipUntil(reader, n, c);
                return 0.0;
            }
            HttpParser.skipLws(reader);
            n = reader.read();
            stringBuilder = new StringBuilder(5);
            int n2 = -1;
            if (n == 48 || n == 49) {
                stringBuilder.append((char)n);
                n = reader.read();
                while (true) {
                    if (n2 == -1 && n == 46) {
                        stringBuilder.append('.');
                        n2 = 0;
                    } else {
                        if (n2 <= -1 || n < 48 || n > 57) break block12;
                        if (n2 < 3) {
                            stringBuilder.append((char)n);
                            ++n2;
                        }
                    }
                    n = reader.read();
                }
            }
            HttpParser.skipUntil(reader, n, c);
            return 0.0;
        }
        if (n == 9 || n == 32) {
            HttpParser.skipLws(reader);
            n = reader.read();
        }
        if (n != c && n != -1) {
            HttpParser.skipUntil(reader, n, c);
            return 0.0;
        }
        double d = Double.parseDouble(stringBuilder.toString());
        if (d > 1.0) {
            return 0.0;
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int readHostIPv4(Reader reader, boolean bl) throws IOException {
        int n = -1;
        int n2 = 1;
        int n3 = 0;
        reader.mark(1);
        while (true) {
            block19: {
                int n4;
                if ((n4 = reader.read()) == 46) {
                    if (n > -1 && n < 256) {
                        ++n2;
                        n = -1;
                        break block19;
                    } else {
                        if (!bl && n != -1) {
                            reader.reset();
                            return HttpParser.readHostDomainName(reader);
                        }
                        throw new IllegalArgumentException(sm.getString("http.invalidOctet", new Object[]{Integer.toString(n)}));
                    }
                }
                if (HttpParser.isNumeric(n4)) {
                    if (n == -1) {
                        n = n4 - 48;
                    } else {
                        if (n == 0) {
                            if (bl) {
                                throw new IllegalArgumentException(sm.getString("http.invalidLeadingZero"));
                            }
                            reader.reset();
                            return HttpParser.readHostDomainName(reader);
                        }
                        if ((n = n * 10 + n4 - 48) > 255) {
                            break;
                        }
                    }
                } else {
                    if (n4 == 58) break;
                    if (n4 == -1) {
                        if (bl) {
                            throw new IllegalArgumentException(sm.getString("http.noClosingBracket"));
                        }
                        n3 = -1;
                        break;
                    }
                    if (n4 == 93) {
                        if (!bl) {
                            throw new IllegalArgumentException(sm.getString("http.closingBracket"));
                        }
                        ++n3;
                        break;
                    }
                    if (!bl && (HttpParser.isAlpha(n4) || n4 == 45)) {
                        reader.reset();
                        return HttpParser.readHostDomainName(reader);
                    }
                    throw new IllegalArgumentException(sm.getString("http.illegalCharacterIpv4", new Object[]{Character.toString((char)n4)}));
                }
            }
            ++n3;
        }
        if (n2 != 4 || n < 0 || n > 255) {
            reader.reset();
            return HttpParser.readHostDomainName(reader);
        }
        if (bl) {
            return n3;
        }
        return HttpParser.validatePort(reader, n3);
    }

    static int readHostIPv6(Reader reader) throws IOException {
        int n = reader.read();
        if (n != 91) {
            throw new IllegalArgumentException(sm.getString("http.noOpeningBracket"));
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        boolean bl = false;
        int n5 = 0;
        while (true) {
            n = reader.read();
            if (n2 == 0 && n5 == 1 && n != 58) {
                throw new IllegalArgumentException(sm.getString("http.singleColonStart"));
            }
            if (HttpParser.isHex(n)) {
                if (n3 == 0) {
                    n5 = 0;
                    ++n2;
                }
                if (++n3 > 4) {
                    throw new IllegalArgumentException(sm.getString("http.invalidHextet"));
                }
            } else if (n == 58) {
                if (n5 >= 2) {
                    throw new IllegalArgumentException(sm.getString("http.tooManyColons"));
                }
                if (n5 == 1) {
                    if (bl) {
                        throw new IllegalArgumentException(sm.getString("http.tooManyDoubleColons"));
                    }
                    bl = true;
                    ++n2;
                }
                ++n5;
                reader.mark(4);
                n3 = 0;
            } else {
                if (n == 93) {
                    if (n5 == 1) {
                        throw new IllegalArgumentException(sm.getString("http.singleColonEnd"));
                    }
                    ++n4;
                    break;
                }
                if (n == 46) {
                    if (n2 == 7 || n2 < 7 && bl) {
                        reader.reset();
                        n4 -= n3;
                        n4 += HttpParser.readHostIPv4(reader, true);
                        ++n2;
                        break;
                    }
                    throw new IllegalArgumentException(sm.getString("http.invalidIpv4Location"));
                }
                throw new IllegalArgumentException(sm.getString("http.illegalCharacterIpv6", new Object[]{Character.toString((char)n)}));
            }
            ++n4;
        }
        if (n2 > 8) {
            throw new IllegalArgumentException(sm.getString("http.tooManyHextets", new Object[]{Integer.toString(n2)}));
        }
        if (n2 != 8 && !bl) {
            throw new IllegalArgumentException(sm.getString("http.tooFewHextets", new Object[]{Integer.toString(n2)}));
        }
        n = reader.read();
        if (n == 58) {
            return HttpParser.validatePort(reader, n4);
        }
        if (n == -1) {
            return -1;
        }
        throw new IllegalArgumentException(sm.getString("http.illegalAfterIpv6", new Object[]{Character.toString((char)n)}));
    }

    static int readHostDomainName(Reader reader) throws IOException {
        DomainParseState domainParseState = DomainParseState.NEW;
        int n = 0;
        while (domainParseState.mayContinue()) {
            domainParseState = domainParseState.next(reader.read());
            ++n;
        }
        if (DomainParseState.COLON == domainParseState) {
            return HttpParser.validatePort(reader, n - 1);
        }
        return -1;
    }

    static int validatePort(Reader reader, int n) throws IOException {
        HttpParser.readLong(reader);
        if (reader.read() == -1) {
            return n;
        }
        throw new IllegalArgumentException();
    }

    static SkipResult skipUntil(Reader reader, int n, char c) throws IOException {
        while (n != -1 && n != c) {
            n = reader.read();
        }
        if (n == -1) {
            return SkipResult.EOF;
        }
        return SkipResult.FOUND;
    }

    private void relax(boolean[] blArray, String string) {
        if (string != null && string.length() > 0) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                if (!HttpParser.isRelaxable(c)) continue;
                blArray[c] = true;
                this.IS_NOT_REQUEST_TARGET[c] = false;
            }
        }
    }

    static {
        for (int i = 0; i < 128; ++i) {
            if (i < 32 || i == 127) {
                HttpParser.IS_CONTROL[i] = true;
            }
            if (i == 40 || i == 41 || i == 60 || i == 62 || i == 64 || i == 44 || i == 59 || i == 58 || i == 92 || i == 34 || i == 47 || i == 91 || i == 93 || i == 63 || i == 61 || i == 123 || i == 125 || i == 32 || i == 9) {
                HttpParser.IS_SEPARATOR[i] = true;
            }
            if (!IS_CONTROL[i] && !IS_SEPARATOR[i] && i < 128) {
                HttpParser.IS_TOKEN[i] = true;
            }
            if (i >= 48 && i <= 57 || i >= 97 && i <= 102 || i >= 65 && i <= 70) {
                HttpParser.IS_HEX[i] = true;
            }
            if (i == 72 || i == 84 || i == 80 || i == 47 || i == 46 || i >= 48 && i <= 57) {
                HttpParser.IS_HTTP_PROTOCOL[i] = true;
            }
            if (i >= 48 && i <= 57) {
                HttpParser.IS_NUMERIC[i] = true;
            }
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                HttpParser.IS_ALPHA[i] = true;
            }
            if (IS_ALPHA[i] || IS_NUMERIC[i] || i == 43 || i == 45 || i == 46) {
                HttpParser.IS_SCHEME[i] = true;
            }
            if (IS_ALPHA[i] || IS_NUMERIC[i] || i == 45 || i == 46 || i == 95 || i == 126) {
                HttpParser.IS_UNRESERVED[i] = true;
            }
            if (i == 33 || i == 36 || i == 38 || i == 39 || i == 40 || i == 41 || i == 42 || i == 43 || i == 44 || i == 59 || i == 61) {
                HttpParser.IS_SUBDELIM[i] = true;
            }
            if (IS_UNRESERVED[i] || i == 37 || IS_SUBDELIM[i] || i == 58) {
                HttpParser.IS_USERINFO[i] = true;
            }
            if (i != 34 && i != 60 && i != 62 && i != 91 && i != 92 && i != 93 && i != 94 && i != 96 && i != 123 && i != 124 && i != 125) continue;
            HttpParser.IS_RELAXABLE[i] = true;
        }
        DEFAULT = new HttpParser(null, null);
    }

    private static enum DomainParseState {
        NEW(true, false, false, false, "http.invalidCharacterDomain.atStart"),
        ALPHA(true, true, true, true, "http.invalidCharacterDomain.afterLetter"),
        NUMERIC(true, true, true, true, "http.invalidCharacterDomain.afterNumber"),
        PERIOD(true, false, false, true, "http.invalidCharacterDomain.afterPeriod"),
        HYPHEN(true, true, false, false, "http.invalidCharacterDomain.afterHyphen"),
        COLON(false, false, false, false, "http.invalidCharacterDomain.afterColon"),
        END(false, false, false, false, "http.invalidCharacterDomain.atEnd");

        private final boolean mayContinue;
        private final boolean allowsHyphen;
        private final boolean allowsPeriod;
        private final boolean allowsEnd;
        private final String errorMsg;

        private DomainParseState(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
            this.mayContinue = bl;
            this.allowsHyphen = bl2;
            this.allowsPeriod = bl3;
            this.allowsEnd = bl4;
            this.errorMsg = string2;
        }

        public boolean mayContinue() {
            return this.mayContinue;
        }

        public DomainParseState next(int n) {
            if (n == -1) {
                if (this.allowsEnd) {
                    return END;
                }
                throw new IllegalArgumentException(sm.getString("http.invalidSegmentEndState", new Object[]{this.name()}));
            }
            if (HttpParser.isAlpha(n)) {
                return ALPHA;
            }
            if (HttpParser.isNumeric(n)) {
                return NUMERIC;
            }
            if (n == 46) {
                if (this.allowsPeriod) {
                    return PERIOD;
                }
                throw new IllegalArgumentException(sm.getString(this.errorMsg, new Object[]{Character.toString((char)n)}));
            }
            if (n == 58) {
                if (this.allowsEnd) {
                    return COLON;
                }
                throw new IllegalArgumentException(sm.getString(this.errorMsg, new Object[]{Character.toString((char)n)}));
            }
            if (n == 45) {
                if (this.allowsHyphen) {
                    return HYPHEN;
                }
                throw new IllegalArgumentException(sm.getString(this.errorMsg, new Object[]{Character.toString((char)n)}));
            }
            throw new IllegalArgumentException(sm.getString("http.illegalCharacterDomain", new Object[]{Character.toString((char)n)}));
        }
    }
}

