# This file is generated by coder.py. DO NOT EDIT!
# ruff: noqa: F401, E402, F811
# fmt: off

from __future__ import annotations

from gaphor.core.modeling.properties import (
    association,
    attribute as _attribute,
    derived,
    derivedunion,
    enumeration as _enumeration,
    redefine,
    relation_many,
    relation_one,
)


# 1: override Element
from gaphor.core.modeling.element import Element

# 4: override Diagram
from gaphor.core.modeling.diagram import Diagram

# 7: override Presentation
from gaphor.core.modeling.presentation import Presentation

class Comment(Element):
    annotatedElement: relation_many[Element]
    body: _attribute[str] = _attribute("body", str)


# 13: override StyleSheet
from gaphor.core.modeling.stylesheet import StyleSheet

class PendingChange(Element):
    applied: _attribute[int] = _attribute("applied", int, default=0)
    element_id: _attribute[str] = _attribute("element_id", str)
    op = _enumeration("op", ("add", "remove", "update"), "add")


class ElementChange(PendingChange):
    diagram_id: _attribute[str] = _attribute("diagram_id", str)
    element_name: _attribute[str] = _attribute("element_name", str)


class ValueChange(PendingChange):
    property_name: _attribute[str] = _attribute("property_name", str)
    property_value: _attribute[str] = _attribute("property_value", str)


class RefChange(PendingChange):
    property_name: _attribute[str] = _attribute("property_name", str)
    property_ref: _attribute[str] = _attribute("property_ref", str)


class Picture(Element):
    content: _attribute[str] = _attribute("content", str)


class Relationship(Element):
    relatedElement: relation_many[Element]
    source: relation_many[Element]
    target: relation_many[Element]


class Dependency(Relationship):
    client: relation_one[Element]
    supplier: relation_one[Element]


class NamedElement(Element):
    visibility = _enumeration("visibility", ("public", "private", "package", "protected"), "public")


class Namespace(NamedElement):
    member: relation_many[Element]
    ownedMember: relation_many[Element]


class Type(Namespace):
    pass


class Feature(Type):
    isStatic: _attribute[int] = _attribute("isStatic", int, default=False)



Element.ownedElement = derivedunion("ownedElement", Element)
Element.owner = derivedunion("owner", Element, upper=1)
Element.presentation = association("presentation", Presentation, composite=True, opposite="subject")
Element.ownedDiagram = association("ownedDiagram", Diagram, composite=True, opposite="element")
Element.comment = association("comment", Comment, opposite="annotatedElement")
Element.relationship = derivedunion("relationship", Relationship)
Element.clientDependency = association("clientDependency", Dependency, composite=True, opposite="client")
Element.supplierDependency = association("supplierDependency", Dependency, opposite="supplier")
Element.memberNamespace = derivedunion("memberNamespace", Namespace, upper=1)
Element.namespace = derivedunion("namespace", Namespace, upper=1)
Element.sourceRelationship = derivedunion("sourceRelationship", Relationship)
Element.targetRelationship = derivedunion("targetRelationship", Relationship)
Element.ownedElement.add(Element.ownedDiagram)  # type: ignore[attr-defined]
Element.ownedElement.add(Element.clientDependency)  # type: ignore[attr-defined]
Element.sourceRelationship.add(Element.clientDependency)  # type: ignore[attr-defined]
Element.targetRelationship.add(Element.supplierDependency)  # type: ignore[attr-defined]
Element.memberNamespace.add(Element.namespace)  # type: ignore[attr-defined]
Element.owner.add(Element.namespace)  # type: ignore[attr-defined]
Element.relationship.add(Element.sourceRelationship)  # type: ignore[attr-defined]
Element.relationship.add(Element.targetRelationship)  # type: ignore[attr-defined]
Diagram.ownedPresentation = association("ownedPresentation", Presentation, composite=True, opposite="diagram")
Diagram.element = association("element", Element, upper=1, opposite="ownedDiagram")
Element.ownedElement.add(Diagram.ownedPresentation)  # type: ignore[attr-defined]
Element.owner.add(Diagram.element)  # type: ignore[attr-defined]
Presentation.parent = association("parent", Presentation, upper=1, opposite="children")
Presentation.children = association("children", Presentation, composite=True, opposite="parent")
Presentation.diagram = association("diagram", Diagram, upper=1, opposite="ownedPresentation")
Presentation.subject = association("subject", Element, upper=1, opposite="presentation")
Element.owner.add(Presentation.diagram)  # type: ignore[attr-defined]
Comment.annotatedElement = association("annotatedElement", Element, opposite="comment")
Relationship.relatedElement = derivedunion("relatedElement", Element, lower=1)
Relationship.source = derivedunion("source", Element)
Relationship.target = derivedunion("target", Element)
Relationship.relatedElement.add(Relationship.source)  # type: ignore[attr-defined]
Relationship.relatedElement.add(Relationship.target)  # type: ignore[attr-defined]
Dependency.client = association("client", Element, upper=1, opposite="clientDependency")
Dependency.supplier = association("supplier", Element, upper=1, opposite="supplierDependency")
Element.owner.add(Dependency.client)  # type: ignore[attr-defined]
Relationship.source.add(Dependency.client)  # type: ignore[attr-defined]
Relationship.target.add(Dependency.supplier)  # type: ignore[attr-defined]
Namespace.member = derivedunion("member", Element)
Namespace.ownedMember = derivedunion("ownedMember", Element)
Namespace.member.add(Namespace.ownedMember)  # type: ignore[attr-defined]
Element.ownedElement.add(Namespace.ownedMember)  # type: ignore[attr-defined]
