/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainer;
import net.sourceforge.plantuml.stereo.StereotypeDecoration;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.text.Guillemet;

public class Stereotype
implements CharSequence {
    private final double radius;
    private final UFont circledFont;
    private final boolean automaticPackageStyle;
    private final StereotypeDecoration decoration;

    private Stereotype(boolean automaticPackageStyle, String label, StereotypeDecoration decoration, double radius, UFont circledFont) {
        this.automaticPackageStyle = automaticPackageStyle;
        this.radius = radius;
        this.circledFont = circledFont;
        this.decoration = Objects.requireNonNull(decoration);
    }

    private static void checkLabel(String label) {
        if (!label.startsWith("<<") || !label.endsWith(">>")) {
            throw new IllegalArgumentException(label);
        }
    }

    public static Stereotype build(String label) {
        if (label == null) {
            return null;
        }
        return Stereotype.build(label, true);
    }

    public static Stereotype build(String label, boolean automaticPackageStyle) {
        Stereotype.checkLabel(label);
        StereotypeDecoration decoration = StereotypeDecoration.buildSimple(label);
        return new Stereotype(automaticPackageStyle, label, decoration, 0.0, null);
    }

    public static Stereotype build(String label, double radius, UFont circledFont, HColorSet htmlColorSet) throws NoSuchColorException {
        Stereotype.checkLabel(label);
        StereotypeDecoration decoration = StereotypeDecoration.buildComplex(label, htmlColorSet);
        return new Stereotype(true, label, decoration, radius, circledFont);
    }

    public HColor getHtmlColor() {
        return this.decoration.htmlColor;
    }

    public char getCharacter() {
        return this.decoration.character;
    }

    public final TextBlock getSprite(SpriteContainer container) {
        if (this.decoration.spriteName == null || container == null) {
            return null;
        }
        Sprite tmp = container.getSprite(this.decoration.spriteName);
        if (tmp == null) {
            return null;
        }
        return tmp.asTextBlock(this.getHtmlColor(), this.decoration.spriteScale);
    }

    public boolean isWithOOSymbol() {
        return "<<O-O>>".equalsIgnoreCase(this.decoration.label);
    }

    public List<String> getMultipleLabels() {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("\\<\\<\\s?((?:\\<&\\w+\\>|[^<>])+?)\\s?\\>\\>");
        Matcher m4 = p.matcher(this.decoration.label);
        while (m4.find()) {
            result.add(m4.group(1));
        }
        return Collections.unmodifiableList(result);
    }

    public boolean isSpotted() {
        return this.decoration.character != '\u0000';
    }

    @Override
    public String toString() {
        if (this.decoration.character == '\u0000') {
            return this.decoration.label;
        }
        return this.decoration.character + " " + this.decoration.label;
    }

    @Override
    public char charAt(int arg0) {
        return this.toString().charAt(arg0);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return this.toString().subSequence(arg0, arg1);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }

    public String getLabel(Guillemet guillemet) {
        if (this.isWithOOSymbol()) {
            return null;
        }
        if (this.decoration.spriteName != null && this.decoration.spriteName.startsWith("archimate/")) {
            return guillemet.manageGuillemet("<<" + this.decoration.spriteName.substring("archimate/".length()) + ">>");
        }
        return guillemet.manageGuillemet(this.decoration.label);
    }

    public List<String> getLabels(Guillemet guillemet) {
        String labelLocal = this.getLabel(Guillemet.DOUBLE_COMPARATOR);
        if (labelLocal == null) {
            return Collections.emptyList();
        }
        return StereotypeDecoration.cutLabels(labelLocal, guillemet);
    }

    public List<Style> getStyles(StyleBuilder builder) {
        ArrayList<Style> result = new ArrayList<Style>();
        for (String s2 : this.getStyleNames()) {
            Style style = builder.createStyle(s2);
            assert (style != null);
            result.add(style);
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getStyleNames() {
        return this.decoration.getStyleNames();
    }

    public PackageStyle getPackageStyle() {
        if (!this.automaticPackageStyle) {
            return null;
        }
        for (PackageStyle p : EnumSet.allOf(PackageStyle.class)) {
            if (!("<<" + (Object)((Object)p) + ">>").equalsIgnoreCase(this.decoration.label)) continue;
            return p;
        }
        return null;
    }

    public boolean isBiddableOrUncertain() {
        return this.decoration.label.equalsIgnoreCase("<<B>>") || this.decoration.label.equalsIgnoreCase("<<Biddable>>") || this.decoration.label.equalsIgnoreCase("<<Uncertain>>");
    }

    public boolean isCausal() {
        return this.decoration.label.equalsIgnoreCase("<<C>>") || this.decoration.label.equalsIgnoreCase("<<Causal>>");
    }

    public boolean isLexicalOrGiven() {
        return this.decoration.label.equalsIgnoreCase("<<L>>") || this.decoration.label.equalsIgnoreCase("<<Lexical>>") || this.decoration.label.equalsIgnoreCase("<<X>>") || this.decoration.label.equalsIgnoreCase("<<Given>>");
    }

    public boolean isDesignedOrSolved() {
        return this.decoration.label.equalsIgnoreCase("<<D>>") || this.decoration.label.equalsIgnoreCase("<<Designed>>") || this.decoration.label.equalsIgnoreCase("<<Nested>>") || this.decoration.label.equalsIgnoreCase("<<Solved>>");
    }

    public boolean isMachineOrSpecification() {
        return this.decoration.label.equalsIgnoreCase("M") || this.decoration.label.equalsIgnoreCase("<<Machine>>") || this.decoration.label.equalsIgnoreCase("<<S>>") || this.decoration.label.equalsIgnoreCase("<<Spec>>") || this.decoration.label.equalsIgnoreCase("<<Specification>>");
    }
}

