/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.SmapStratum;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SmapUtil {
    private static final Charset SMAP_ENCODING = StandardCharsets.UTF_8;

    public static Map<String, SmapStratum> generateSmap(JspCompilationContext jspCompilationContext, Node.Nodes nodes) throws IOException {
        HashMap<String, SmapStratum> hashMap = new HashMap<String, SmapStratum>();
        PreScanVisitor preScanVisitor = new PreScanVisitor();
        try {
            nodes.visit(preScanVisitor);
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
        HashMap<String, SmapStratum> hashMap2 = preScanVisitor.getMap();
        SmapStratum smapStratum = new SmapStratum();
        SmapUtil.evaluateNodes(nodes, smapStratum, hashMap2, jspCompilationContext.getOptions().getMappedFile());
        smapStratum.optimizeLineSection();
        smapStratum.setOutputFileName(SmapUtil.unqualify(jspCompilationContext.getServletJavaFileName()));
        String string = jspCompilationContext.getClassFileName();
        smapStratum.setClassFileName(string);
        hashMap.put(jspCompilationContext.getFQCN(), smapStratum);
        if (jspCompilationContext.getOptions().isSmapDumped()) {
            File file = new File(string + ".smap");
            PrintWriter object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), SMAP_ENCODING));
            object.print(smapStratum.getSmapString());
            object.close();
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string2 = (String)entry.getKey();
            smapStratum = (SmapStratum)entry.getValue();
            smapStratum.optimizeLineSection();
            smapStratum.setOutputFileName(SmapUtil.unqualify(jspCompilationContext.getServletJavaFileName()));
            String string3 = string.substring(0, string.indexOf(".class")) + "$" + string2 + ".class";
            smapStratum.setClassFileName(string3);
            hashMap.put(jspCompilationContext.getFQCN() + "." + string2, smapStratum);
            if (!jspCompilationContext.getOptions().isSmapDumped()) continue;
            File file = new File(string3 + ".smap");
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), SMAP_ENCODING));
            printWriter.print(smapStratum.getSmapString());
            printWriter.close();
        }
        return hashMap;
    }

    public static void installSmap(Map<String, SmapStratum> map) throws IOException {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, SmapStratum> entry : map.entrySet()) {
            File file = new File(entry.getValue().getClassFileName());
            SDEInstaller.install(file, entry.getValue().getSmapString().getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    private static String unqualify(String string) {
        string = string.replace('\\', '/');
        return string.substring(string.lastIndexOf(47) + 1);
    }

    public static void evaluateNodes(Node.Nodes nodes, SmapStratum smapStratum, HashMap<String, SmapStratum> hashMap, boolean bl) {
        try {
            nodes.visit(new SmapGenVisitor(smapStratum, bl, hashMap));
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
    }

    public static SmapStratum loadSmap(String string, ClassLoader classLoader) {
        String[] stringArray;
        String string2 = SmapUtil.getSmap(string, classLoader);
        if (string2 == null) {
            return null;
        }
        SmapStratum smapStratum = new SmapStratum();
        String[] stringArray2 = string2.split("\n");
        int n = 0;
        smapStratum.setOutputFileName(stringArray2[n]);
        n = 4;
        while (!stringArray2[n].equals("*L")) {
            int n2 = stringArray2[n].lastIndexOf(32);
            stringArray = stringArray2[n].substring(n2 + 1);
            smapStratum.addFile((String)stringArray, stringArray2[++n]);
            ++n;
        }
        ++n;
        while (!stringArray2[n].equals("*E")) {
            String[] stringArray3;
            SmapStratum.LineInfo lineInfo = new SmapStratum.LineInfo();
            stringArray = stringArray2[n].split(":");
            String[] stringArray4 = stringArray[0].split(",");
            if (stringArray4.length == 2) {
                lineInfo.setInputLineCount(Integer.parseInt(stringArray4[1]));
            }
            if ((stringArray3 = stringArray4[0].split("#")).length == 2) {
                lineInfo.setLineFileID(Integer.parseInt(stringArray3[1]));
            }
            lineInfo.setInputStartLine(Integer.parseInt(stringArray3[0]));
            String[] stringArray5 = stringArray[1].split(",");
            if (stringArray5.length == 2) {
                lineInfo.setOutputLineIncrement(Integer.parseInt(stringArray5[1]));
            }
            lineInfo.setOutputStartLine(Integer.parseInt(stringArray5[0]));
            smapStratum.addLineInfo(lineInfo);
            ++n;
        }
        return smapStratum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSmap(String string, ClassLoader classLoader) {
        Charset charset = StandardCharsets.ISO_8859_1;
        boolean bl = false;
        String string2 = null;
        InputStream inputStream = null;
        inputStream = classLoader.getResourceAsStream(string.replace(".", "/") + ".smap");
        if (inputStream != null) {
            charset = SMAP_ENCODING;
            bl = true;
        } else {
            inputStream = classLoader.getResourceAsStream(string.replace(".", "/") + ".class");
            int n = inputStream.read();
            while (n != -1) {
                if (n == 83) {
                    n = inputStream.read();
                    if (n != 77 || (n = inputStream.read()) != 65 || (n = inputStream.read()) != 80 || (n = inputStream.read()) != 10) continue;
                    bl = true;
                    break;
                }
                n = inputStream.read();
            }
        }
        if (bl) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            string2 = new String(byteArrayOutputStream.toByteArray(), charset);
        }
        if (inputStream == null) return string2;
        try {
            inputStream.close();
            return string2;
        }
        catch (IOException iOException) {
            Log log = LogFactory.getLog(SmapUtil.class);
            log.warn((Object)Localizer.getMessage("jsp.warning.loadSmap", string), (Throwable)iOException);
        }
        return string2;
        catch (IOException iOException) {
            try {
                Log log = LogFactory.getLog(SmapUtil.class);
                log.warn((Object)Localizer.getMessage("jsp.warning.loadSmap", string), (Throwable)iOException);
                if (inputStream == null) return string2;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    Log log = LogFactory.getLog(SmapUtil.class);
                    log.warn((Object)Localizer.getMessage("jsp.warning.loadSmap", string), (Throwable)iOException2);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return string2;
            }
            catch (IOException iOException3) {
                Log log = LogFactory.getLog(SmapUtil.class);
                log.warn((Object)Localizer.getMessage("jsp.warning.loadSmap", string), (Throwable)iOException3);
            }
            return string2;
        }
    }

    private static class PreScanVisitor
    extends Node.Visitor {
        HashMap<String, SmapStratum> map = new HashMap();

        private PreScanVisitor() {
        }

        @Override
        public void doVisit(Node node) {
            String string = node.getInnerClassName();
            if (string != null && !this.map.containsKey(string)) {
                this.map.put(string, new SmapStratum());
            }
        }

        HashMap<String, SmapStratum> getMap() {
            return this.map;
        }
    }

    private static class SDEInstaller {
        private final Log log = LogFactory.getLog(SDEInstaller.class);
        static final String nameSDE = "SourceDebugExtension";
        byte[] orig;
        byte[] sdeAttr;
        byte[] gen;
        int origPos = 0;
        int genPos = 0;
        int sdeIndex;

        static void install(File file, byte[] byArray) throws IOException {
            File file2 = new File(file.getPath() + "tmp");
            SDEInstaller sDEInstaller = new SDEInstaller(file, byArray);
            sDEInstaller.install(file2);
            if (!file.delete()) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.deleteClassFile", file.getAbsolutePath()));
            }
            if (!file2.renameTo(file)) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.renameClassFile", file2.getAbsolutePath(), file.getAbsolutePath()));
            }
        }

        SDEInstaller(File file, byte[] byArray) throws IOException {
            if (!file.exists()) {
                throw new FileNotFoundException(Localizer.getMessage("jsp.error.noFile", file));
            }
            this.sdeAttr = byArray;
            this.orig = SDEInstaller.readWhole(file);
            this.gen = new byte[this.orig.length + byArray.length + 100];
        }

        void install(File file) throws IOException {
            this.addSDE();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(this.gen, 0, this.genPos);
            }
        }

        static byte[] readWhole(File file) throws IOException {
            int n = (int)file.length();
            byte[] byArray = new byte[n];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                if (fileInputStream.read(byArray, 0, n) != n) {
                    throw new IOException(Localizer.getMessage("jsp.error.readContent", n));
                }
            }
            return byArray;
        }

        void addSDE() throws UnsupportedEncodingException, IOException {
            this.copy(8);
            int n = this.genPos;
            int n2 = this.readU2();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("constant pool count: " + n2));
            }
            this.writeU2(n2);
            this.sdeIndex = this.copyConstantPool(n2);
            if (this.sdeIndex < 0) {
                this.writeUtf8ForSDE();
                this.sdeIndex = n2++;
                this.randomAccessWriteU2(n, n2);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("SourceDebugExtension not found, installed at: " + this.sdeIndex));
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("SourceDebugExtension found at: " + this.sdeIndex));
            }
            this.copy(6);
            int n3 = this.readU2();
            this.writeU2(n3);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("interfaceCount: " + n3));
            }
            this.copy(n3 * 2);
            this.copyMembers();
            this.copyMembers();
            int n4 = this.genPos;
            int n5 = this.readU2();
            this.writeU2(n5);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("class attrCount: " + n5));
            }
            if (!this.copyAttrs(n5)) {
                this.randomAccessWriteU2(n4, ++n5);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"class attrCount incremented");
                }
            }
            this.writeAttrForSDE(this.sdeIndex);
        }

        void copyMembers() {
            int n = this.readU2();
            this.writeU2(n);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("members count: " + n));
            }
            for (int i = 0; i < n; ++i) {
                this.copy(6);
                int n2 = this.readU2();
                this.writeU2(n2);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("member attr count: " + n2));
                }
                this.copyAttrs(n2);
            }
        }

        boolean copyAttrs(int n) {
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2 = this.readU2();
                if (n2 == this.sdeIndex) {
                    bl = true;
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)"SDE attr found");
                    continue;
                }
                this.writeU2(n2);
                int n3 = this.readU4();
                this.writeU4(n3);
                this.copy(n3);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("attr len: " + n3));
            }
            return bl;
        }

        void writeAttrForSDE(int n) {
            this.writeU2(n);
            this.writeU4(this.sdeAttr.length);
            for (byte by : this.sdeAttr) {
                this.writeU1(by);
            }
        }

        void randomAccessWriteU2(int n, int n2) {
            int n3 = this.genPos;
            this.genPos = n;
            this.writeU2(n2);
            this.genPos = n3;
        }

        int readU1() {
            return this.orig[this.origPos++] & 0xFF;
        }

        int readU2() {
            int n = this.readU1();
            return (n << 8) + this.readU1();
        }

        int readU4() {
            int n = this.readU2();
            return (n << 16) + this.readU2();
        }

        void writeU1(int n) {
            this.gen[this.genPos++] = (byte)n;
        }

        void writeU2(int n) {
            this.writeU1(n >> 8);
            this.writeU1(n & 0xFF);
        }

        void writeU4(int n) {
            this.writeU2(n >> 16);
            this.writeU2(n & 0xFFFF);
        }

        void copy(int n) {
            for (int i = 0; i < n; ++i) {
                this.gen[this.genPos++] = this.orig[this.origPos++];
            }
        }

        byte[] readBytes(int n) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.orig[this.origPos++];
            }
            return byArray;
        }

        void writeBytes(byte[] byArray) {
            for (byte by : byArray) {
                this.gen[this.genPos++] = by;
            }
        }

        int copyConstantPool(int n) throws UnsupportedEncodingException, IOException {
            int n2 = -1;
            block7: for (int i = 1; i < n; ++i) {
                int n3 = this.readU1();
                this.writeU1(n3);
                switch (n3) {
                    case 7: 
                    case 8: 
                    case 16: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(i + " copying 2 bytes"));
                        }
                        this.copy(2);
                        continue block7;
                    }
                    case 15: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(i + " copying 3 bytes"));
                        }
                        this.copy(3);
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(i + " copying 4 bytes"));
                        }
                        this.copy(4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(i + " copying 8 bytes"));
                        }
                        this.copy(8);
                        ++i;
                        continue block7;
                    }
                    case 1: {
                        int n4 = this.readU2();
                        this.writeU2(n4);
                        byte[] byArray = this.readBytes(n4);
                        String string = new String(byArray, "UTF-8");
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)(i + " read class attr -- '" + string + "'"));
                        }
                        if (string.equals(nameSDE)) {
                            n2 = i;
                        }
                        this.writeBytes(byArray);
                        continue block7;
                    }
                    default: {
                        throw new IOException(Localizer.getMessage("jsp.error.unexpectedTag", n3));
                    }
                }
            }
            return n2;
        }

        void writeUtf8ForSDE() {
            int n = nameSDE.length();
            this.writeU1(1);
            this.writeU2(n);
            for (int i = 0; i < n; ++i) {
                this.writeU1(nameSDE.charAt(i));
            }
        }
    }

    private static class SmapGenVisitor
    extends Node.Visitor {
        private SmapStratum smap;
        private final boolean breakAtLF;
        private final HashMap<String, SmapStratum> innerClassMap;

        SmapGenVisitor(SmapStratum smapStratum, boolean bl, HashMap<String, SmapStratum> hashMap) {
            this.smap = smapStratum;
            this.breakAtLF = bl;
            this.innerClassMap = hashMap;
        }

        @Override
        public void visitBody(Node node) throws JasperException {
            SmapStratum smapStratum = this.smap;
            String string = node.getInnerClassName();
            if (string != null) {
                this.smap = this.innerClassMap.get(string);
            }
            super.visitBody(node);
            this.smap = smapStratum;
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            this.doSmapText(declaration);
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            this.doSmapText(expression);
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            this.doSmapText(scriptlet);
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            this.doSmap(includeAction);
            this.visitBody(includeAction);
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            this.doSmap(forwardAction);
            this.visitBody(forwardAction);
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            this.doSmap(getProperty);
            this.visitBody(getProperty);
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            this.doSmap(setProperty);
            this.visitBody(setProperty);
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            this.doSmap(useBean);
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            this.doSmap(plugIn);
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.doSmap(customTag);
            this.visitBody(customTag);
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            this.doSmap(uninterpretedTag);
            this.visitBody(uninterpretedTag);
        }

        @Override
        public void visit(Node.JspElement jspElement) throws JasperException {
            this.doSmap(jspElement);
            this.visitBody(jspElement);
        }

        @Override
        public void visit(Node.JspText jspText) throws JasperException {
            this.doSmap(jspText);
            this.visitBody(jspText);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            this.visitBody(namedAttribute);
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.doSmap(jspBody);
            this.visitBody(jspBody);
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws JasperException {
            this.doSmap(invokeAction);
            this.visitBody(invokeAction);
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws JasperException {
            this.doSmap(doBodyAction);
            this.visitBody(doBodyAction);
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            this.doSmap(eLExpression);
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            Mark mark = templateText.getStart();
            if (mark == null) {
                return;
            }
            String string = mark.getFile();
            this.smap.addFile(SmapUtil.unqualify(string), string);
            int n = mark.getLineNumber();
            int n2 = templateText.getBeginJavaLine();
            int n3 = this.breakAtLF ? 1 : 0;
            this.smap.addLineData(n, string, 1, n2, n3);
            ArrayList<Integer> arrayList = templateText.getExtraSmap();
            if (arrayList != null) {
                for (Integer n4 : arrayList) {
                    this.smap.addLineData(n + n4, string, 1, n2 += n3, n3);
                }
            }
        }

        private void doSmap(Node node, int n, int n2, int n3) {
            Mark mark = node.getStart();
            if (mark == null) {
                return;
            }
            String string = SmapUtil.unqualify(mark.getFile());
            this.smap.addFile(string, mark.getFile());
            this.smap.addLineData(mark.getLineNumber() + n3, mark.getFile(), n - n3, node.getBeginJavaLine() + n3, n2);
        }

        private void doSmap(Node node) {
            this.doSmap(node, 1, node.getEndJavaLine() - node.getBeginJavaLine(), 0);
        }

        private void doSmapText(Node node) {
            String string = node.getText();
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = true;
            while ((n2 = string.indexOf(10, n)) > -1) {
                if (bl2) {
                    String string2 = string.substring(n, n2).trim();
                    if (!bl && string2.startsWith("/*")) {
                        bl = true;
                    }
                    if (bl) {
                        ++n4;
                        int n5 = string2.indexOf("*/");
                        if (n5 >= 0) {
                            bl = false;
                            if (n5 < string2.length() - 2) {
                                --n4;
                                bl2 = false;
                            }
                        }
                    } else if (string2.length() == 0 || string2.startsWith("//")) {
                        ++n4;
                    } else {
                        bl2 = false;
                    }
                }
                ++n3;
                n = n2 + 1;
            }
            this.doSmap(node, n3, 1, n4);
        }
    }
}

