/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.TimeRange;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils {
    private static final long DAY_IN_MS = 86400000L;

    public static boolean isToday(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) == cal.get(1) && today.get(6) == cal.get(6);
    }

    public static boolean isThisWeek(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) == cal.get(1) && today.get(3) == cal.get(3);
    }

    public static boolean isThisMonth(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) == cal.get(1) && today.get(2) == cal.get(2);
    }

    public static boolean isThisQuarter(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) == cal.get(1) && today.get(2) / 3 == cal.get(2) / 3;
    }

    public static boolean isThisYear(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) == cal.get(1);
    }

    public static boolean isYesterday(Calendar cal) {
        Calendar yesterday = DateUtils.adjustDate(Calendar.getInstance(), -1);
        return yesterday.get(1) == cal.get(1) && yesterday.get(6) == cal.get(6);
    }

    public static boolean isLastWeek(Calendar cal) {
        Calendar lastWeek = DateUtils.adjustDate(Calendar.getInstance(), -7);
        return lastWeek.get(1) == cal.get(1) && lastWeek.get(3) == cal.get(3);
    }

    public static boolean isLastMonth(Calendar cal) {
        Calendar today = Calendar.getInstance();
        int thisMonth = today.get(2);
        if (thisMonth >= 1) {
            return today.get(1) == cal.get(1) && thisMonth - 1 == cal.get(2);
        }
        return today.get(1) - 1 == cal.get(1) && today.getActualMaximum(2) == cal.get(2);
    }

    public static boolean isLastQuarter(Calendar cal) {
        Calendar today = Calendar.getInstance();
        int thisQuarter = today.get(2) / 3;
        if (thisQuarter >= 1) {
            return today.get(1) == cal.get(1) && thisQuarter - 1 == cal.get(2) / 3;
        }
        return today.get(1) - 1 == cal.get(1) && today.getActualMaximum(2) / 3 == cal.get(2) / 3;
    }

    public static boolean isLastYear(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) - 1 == cal.get(1);
    }

    public static boolean isTomorrow(Calendar cal) {
        Calendar tomorrow = DateUtils.adjustDate(Calendar.getInstance(), 1);
        return tomorrow.get(1) == cal.get(1) && tomorrow.get(6) == cal.get(6);
    }

    public static boolean isNextWeek(Calendar cal) {
        Calendar nextWeek = DateUtils.adjustDate(Calendar.getInstance(), 7);
        return nextWeek.get(1) == cal.get(1) && nextWeek.get(3) == cal.get(3);
    }

    public static boolean isNextMonth(Calendar cal) {
        Calendar today = Calendar.getInstance();
        int thisMonth = today.get(2);
        if (thisMonth < today.getActualMaximum(2)) {
            return today.get(1) == cal.get(1) && thisMonth + 1 == cal.get(2);
        }
        return today.get(1) + 1 == cal.get(1) && today.getMinimum(2) == cal.get(2);
    }

    public static boolean isNextQuarter(Calendar cal) {
        Calendar today = Calendar.getInstance();
        int thisQuarter = today.get(2) / 3;
        if (thisQuarter < today.getActualMaximum(2) / 3) {
            return today.get(1) == cal.get(1) && thisQuarter + 1 == cal.get(2) / 3;
        }
        return today.get(1) + 1 == cal.get(1) && today.getActualMinimum(2) / 3 == cal.get(2) / 3;
    }

    public static boolean isNextYear(Calendar cal) {
        Calendar today = Calendar.getInstance();
        return today.get(1) + 1 == cal.get(1);
    }

    public static boolean isAtMonth(Calendar cal, int month) {
        return cal.get(2) == month;
    }

    public static boolean isAtQuarter(Calendar cal, int quarter) {
        return cal.get(2) / 3 + 1 == quarter;
    }

    public static Calendar adjustDate(Calendar calendar, int differenceInDay) {
        calendar.setTimeInMillis(calendar.getTimeInMillis() + 86400000L * (long)differenceInDay);
        return calendar;
    }

    @Deprecated
    public static Date min(List<Date> dates) {
        return DateUtils.minDates(dates);
    }

    @Deprecated
    public static Date max(List<Date> dates) {
        return DateUtils.maxDates(dates);
    }

    public static Date minDates(List<Date> dates) {
        long min2 = Long.MAX_VALUE;
        Date minDate = null;
        for (Date value : dates) {
            long v = value.getTime();
            if (v >= min2) continue;
            min2 = v;
            minDate = value;
        }
        return minDate;
    }

    public static Date maxDates(List<Date> dates) {
        long max = Long.MIN_VALUE;
        Date maxDate = null;
        for (Date value : dates) {
            long v = value.getTime();
            if (v <= max) continue;
            max = v;
            maxDate = value;
        }
        return maxDate;
    }

    public static TimeRange rangeDates(List<Date> dates) {
        long max = Long.MIN_VALUE;
        long min2 = Long.MAX_VALUE;
        Date minDate = null;
        Date maxDate = null;
        for (Date value : dates) {
            long v = value.getTime();
            if (v > max) {
                max = v;
                maxDate = value;
            }
            if (v >= min2) continue;
            min2 = v;
            minDate = value;
        }
        return minDate == null || maxDate == null ? null : new TimeRange(minDate, maxDate);
    }

    public static Calendar minCalendars(List<Calendar> calendars) {
        long min2 = Long.MAX_VALUE;
        Calendar minCalendar = null;
        for (Calendar value : calendars) {
            long v = value.getTimeInMillis();
            if (v >= min2) continue;
            min2 = v;
            minCalendar = value;
        }
        return minCalendar;
    }

    public static Calendar maxCalendars(List<Calendar> calendars) {
        long max = Long.MIN_VALUE;
        Calendar maxCalendar = null;
        for (Calendar value : calendars) {
            long v = value.getTimeInMillis();
            if (v <= max) continue;
            max = v;
            maxCalendar = value;
        }
        return maxCalendar;
    }

    public static TimeRange rangeCalendars(List<Calendar> calendars) {
        long max = Long.MIN_VALUE;
        long min2 = Long.MAX_VALUE;
        Calendar minCalendar = null;
        Calendar maxCalendar = null;
        for (Calendar value : calendars) {
            long v = value.getTimeInMillis();
            if (v > max) {
                max = v;
                maxCalendar = value;
            }
            if (v >= min2) continue;
            min2 = v;
            minCalendar = value;
        }
        return minCalendar == null || maxCalendar == null ? null : new TimeRange(minCalendar, maxCalendar);
    }
}

