/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.forecast.ratelimit.ForecastCheckpointReadWorker;
import org.opensearch.forecast.ratelimit.ForecastColdStartWorker;
import org.opensearch.forecast.transport.ForecastRunOnceProfileAction;
import org.opensearch.forecast.transport.ForecastRunOnceProfileNodeRequest;
import org.opensearch.forecast.transport.ForecastRunOnceProfileRequest;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.transport.BooleanNodeResponse;
import org.opensearch.timeseries.transport.BooleanResponse;
import org.opensearch.transport.TransportService;

public class ForecastRunOnceProfileTransportAction
extends TransportNodesAction<ForecastRunOnceProfileRequest, BooleanResponse, ForecastRunOnceProfileNodeRequest, BooleanNodeResponse> {
    private final ForecastColdStartWorker coldStartWorker;
    private final ForecastCheckpointReadWorker checkpointReadWorker;

    @Inject
    public ForecastRunOnceProfileTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Settings settings, ForecastColdStartWorker coldStartWorker, ForecastCheckpointReadWorker checkpointReadWorker) {
        super(ForecastRunOnceProfileAction.NAME, threadPool, clusterService, transportService, actionFilters, ForecastRunOnceProfileRequest::new, ForecastRunOnceProfileNodeRequest::new, "management", BooleanNodeResponse.class);
        this.coldStartWorker = coldStartWorker;
        this.checkpointReadWorker = checkpointReadWorker;
    }

    protected BooleanResponse newResponse(ForecastRunOnceProfileRequest request, List<BooleanNodeResponse> responses, List<FailedNodeException> failures) {
        return new BooleanResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ForecastRunOnceProfileNodeRequest newNodeRequest(ForecastRunOnceProfileRequest request) {
        return new ForecastRunOnceProfileNodeRequest(request);
    }

    protected BooleanNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new BooleanNodeResponse(in);
    }

    protected BooleanNodeResponse nodeOperation(ForecastRunOnceProfileNodeRequest request) {
        String configId = request.getConfigId();
        return new BooleanNodeResponse(this.clusterService.localNode(), this.coldStartWorker.hasConfigId(configId) || this.checkpointReadWorker.hasConfigId(configId));
    }
}

