/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import org.opensearch.ad.ADJobProcessor;
import org.opensearch.forecast.ForecastJobProcessor;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.timeseries.model.Job;

public class JobRunner
implements ScheduledJobRunner {
    private static JobRunner INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<JobRunner> clazz = JobRunner.class;
        synchronized (JobRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new JobRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void runJob(ScheduledJobParameter scheduledJobParameter, JobExecutionContext context) {
        if (!(scheduledJobParameter instanceof Job)) {
            throw new IllegalArgumentException("Job parameter is not instance of Job, type: " + scheduledJobParameter.getClass().getCanonicalName());
        }
        Job jobParameter = (Job)scheduledJobParameter;
        switch (jobParameter.getAnalysisType()) {
            case AD: {
                ADJobProcessor.getInstance().process(jobParameter, context);
                break;
            }
            case FORECAST: {
                ForecastJobProcessor.getInstance().process(jobParameter, context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Analysis type is not supported, type: : " + jobParameter.getAnalysisType());
            }
        }
    }
}

