"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observabilityOverviewID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityGettingStartedTitle = exports.observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.discoverPluginID = exports.anomalyDetectionPluginID = exports.alertingPluginID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.TIMESTAMP_DATETIME_TYPES = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SECURITY_PLUGIN_ACCOUNT_API = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATA_SOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OTEL_METRIC_SUBTYPE = exports.OTEL_DATE_FORMAT = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SETTINGS = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = void 0;
exports.tutorialSampleDataPluginId = exports.queryWorkbenchPluginID = exports.queryWorkbenchPluginCheck = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesNewNavURL = exports.observabilityTracesNewNavID = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityServicesTitle = exports.observabilityServicesPluginOrder = exports.observabilityServicesNewNavURL = exports.observabilityServicesNewNavID = exports.observabilityServicesID = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityOverviewTitleWithUseCase = exports.observabilityOverviewTitle = exports.observabilityOverviewPluginOrder = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const DSL_SETTINGS = exports.DSL_SETTINGS = '/indices.getFieldSettings';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const DATACONNECTIONS_UPDATE_STATUS = exports.DATACONNECTIONS_UPDATE_STATUS = '/status';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';
const SECURITY_PLUGIN_ACCOUNT_API = exports.SECURITY_PLUGIN_ACCOUNT_API = '/api/v1/configuration/account';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const tutorialSampleDataPluginId = exports.tutorialSampleDataPluginId = 'import_sample_data';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityOverviewID = exports.observabilityOverviewID = 'observability-overview';
const observabilityOverviewTitle = exports.observabilityOverviewTitle = 'Overview';
const observabilityOverviewTitleWithUseCase = exports.observabilityOverviewTitleWithUseCase = 'Observability overview';
const observabilityOverviewPluginOrder = exports.observabilityOverviewPluginOrder = 5088;
const observabilityGettingStartedID = exports.observabilityGettingStartedID = 'observability-gettingStarted';
const observabilityGettingStartedTitle = exports.observabilityGettingStartedTitle = 'Get started';
const observabilityGettingStartedPluginOrder = exports.observabilityGettingStartedPluginOrder = 5089;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesNewNavID = exports.observabilityTracesNewNavID = 'observability-traces-nav';
const observabilityTracesNewNavURL = exports.observabilityTracesNewNavURL = observabilityTracesNewNavID;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityServicesNewNavID = exports.observabilityServicesNewNavID = 'observability-services-nav';
const observabilityServicesNewNavURL = exports.observabilityServicesNewNavURL = observabilityServicesNewNavID;
const observabilityServicesID = exports.observabilityServicesID = 'observability-services';
const observabilityServicesTitle = exports.observabilityServicesTitle = 'Services';
const observabilityServicesPluginOrder = exports.observabilityServicesPluginOrder = 5092;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';
const queryWorkbenchPluginCheck = exports.queryWorkbenchPluginCheck = 'plugin:queryWorkbenchDashboards';
const alertingPluginID = exports.alertingPluginID = 'alerting';
const anomalyDetectionPluginID = exports.anomalyDetectionPluginID = 'anomaly-detection-dashboards';
const discoverPluginID = exports.discoverPluginID = 'data-explorer/discover';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const OTEL_DATE_FORMAT = exports.OTEL_DATE_FORMAT = 'YYYY-MM-DDTHH:mm:ss';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const OTEL_METRIC_SUBTYPE = exports.OTEL_METRIC_SUBTYPE = 'openTelemetryMetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;
const PPL_DESCRIBE_INDEX_REGEX = exports.PPL_DESCRIBE_INDEX_REGEX = /(describe)\s+([^|\s]+)/i;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  VIS_CHART_TYPES["Histogram"] = "histogram";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: -45,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATA_SOURCE_TYPE = exports.S3_DATA_SOURCE_TYPE = 's3glue';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const ASYNC_QUERY_DATASOURCE_CACHE = exports.ASYNC_QUERY_DATASOURCE_CACHE = 'async-query-catalog-cache';
const ASYNC_QUERY_ACCELERATIONS_CACHE = exports.ASYNC_QUERY_ACCELERATIONS_CACHE = 'async-query-acclerations-cache';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
const TIMESTAMP_DATETIME_TYPES = exports.TIMESTAMP_DATETIME_TYPES = ['date', 'date_nanos'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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