"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryBuilder = void 0;
var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");
var _stats_builder = require("../ast/builder/stats_builder");
var _stats_ast_builder = require("../ast/builder/stats_ast_builder");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLQueryBuilder {
  constructor() {
    _defineProperty(this, "parser", null);
  }
  build(query, pplTokens) {
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(query);
    return this.buildStats(query, pplTokens);
  }
  buildStats(query, statsTokens) {
    const statsTree = new _stats_ast_builder.StatsAstBuilder().visitRoot(this.parser.root());
    const newStatsAstTree = new _stats_builder.StatsBuilder(statsTokens).build();
    if (typeof statsTree.getStartEndIndicesOfOriginQuery !== 'function') {
      return query + ' | ' + newStatsAstTree.toString();
    }
    const indices = statsTree.getStartEndIndicesOfOriginQuery();
    if (indices.start !== -1 && indices.end !== -1) {
      return query.substring(0, indices.start) + newStatsAstTree.toString() + query.substring(indices.end + 1, query.length);
    } else if (indices && newStatsAstTree) {
      return query + ' | ' + newStatsAstTree.toString();
    }
    return '';
  }
}
exports.PPLQueryBuilder = PPLQueryBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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