/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import org.apache.lucene.index.BinaryDocValues;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;

public class KNNCodecUtil {
    public static final int FLOAT_BYTE_SIZE = 4;

    public static long calculateArraySize(int numVectors, int vectorLength, VectorDataType vectorDataType) {
        if (vectorDataType == VectorDataType.FLOAT) {
            return numVectors * vectorLength * 4;
        }
        if (vectorDataType == VectorDataType.BINARY || vectorDataType == VectorDataType.BYTE) {
            return numVectors * vectorLength;
        }
        throw new IllegalArgumentException("Float, binary, and byte are the only supported vector data types for array size calculation.");
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format("%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format("%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format("_%s%s", fieldName, extension);
    }

    public static long getTotalLiveDocsCount(BinaryDocValues binaryDocValues) {
        long totalLiveDocs = binaryDocValues instanceof KNN80BinaryDocValues ? ((KNN80BinaryDocValues)binaryDocValues).getTotalLiveDocs() : binaryDocValues.cost();
        return totalLiveDocs;
    }
}

