/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.nativelib;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DocAndScoreQuery
extends Query {
    private final int k;
    private final int[] docs;
    private final float[] scores;
    private final int[] segmentStarts;
    private final Object contextIdentity;

    DocAndScoreQuery(int k, int[] docs, float[] scores, int[] segmentStarts, Object contextIdentity) {
        this.k = k;
        this.docs = docs;
        this.scores = scores;
        this.segmentStarts = segmentStarts;
        this.contextIdentity = contextIdentity;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) {
        if (searcher.getIndexReader().getContext().id() != this.contextIdentity) {
            throw new IllegalStateException("This DocAndScore query was created by a different reader");
        }
        return new Weight(this){

            public Explanation explain(LeafReaderContext context, int doc) {
                int found = Arrays.binarySearch(DocAndScoreQuery.this.docs, doc + context.docBase);
                if (found < 0) {
                    return Explanation.noMatch((String)("not in top " + DocAndScoreQuery.this.k), (Explanation[])new Explanation[0]);
                }
                return Explanation.match((Number)Float.valueOf(DocAndScoreQuery.this.scores[found] * boost), (String)("within top " + DocAndScoreQuery.this.k), (Explanation[])new Explanation[0]);
            }

            public int count(LeafReaderContext context) {
                return DocAndScoreQuery.this.segmentStarts[context.ord + 1] - DocAndScoreQuery.this.segmentStarts[context.ord];
            }

            public Scorer scorer(final LeafReaderContext context) {
                if (DocAndScoreQuery.this.segmentStarts[context.ord] == DocAndScoreQuery.this.segmentStarts[context.ord + 1]) {
                    return null;
                }
                return new Scorer(this){
                    final int lower;
                    final int upper;
                    int upTo;
                    {
                        super(weight);
                        this.lower = DocAndScoreQuery.this.segmentStarts[context.ord];
                        this.upper = DocAndScoreQuery.this.segmentStarts[context.ord + 1];
                        this.upTo = -1;
                    }

                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){

                            public int docID() {
                                return this.docIdNoShadow();
                            }

                            public int nextDoc() {
                                upTo = upTo == -1 ? lower : ++upTo;
                                return this.docIdNoShadow();
                            }

                            public int advance(int target) throws IOException {
                                return this.slowAdvance(target);
                            }

                            public long cost() {
                                return upper - lower;
                            }
                        };
                    }

                    public float getMaxScore(int docId) {
                        docId += context.docBase;
                        float maxScore = 0.0f;
                        for (int idx = Math.max(0, this.upTo); idx < this.upper && DocAndScoreQuery.this.docs[idx] <= docId; ++idx) {
                            maxScore = Math.max(maxScore, DocAndScoreQuery.this.scores[idx]);
                        }
                        return maxScore * boost;
                    }

                    public float score() {
                        return DocAndScoreQuery.this.scores[this.upTo] * boost;
                    }

                    public int advanceShallow(int docid) {
                        int start = Math.max(this.upTo, this.lower);
                        int docidIndex = Arrays.binarySearch(DocAndScoreQuery.this.docs, start, this.upper, docid + context.docBase);
                        if (docidIndex < 0) {
                            docidIndex = -1 - docidIndex;
                        }
                        if (docidIndex >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return DocAndScoreQuery.this.docs[docidIndex];
                    }

                    private int docIdNoShadow() {
                        if (this.upTo == -1) {
                            return -1;
                        }
                        if (this.upTo >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return DocAndScoreQuery.this.docs[this.upTo] - context.docBase;
                    }

                    public int docID() {
                        return this.docIdNoShadow();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String toString(String field) {
        return "DocAndScore[" + this.k + "][docs:" + Arrays.toString(this.docs) + ", scores:" + Arrays.toString(this.scores) + "]";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return this.contextIdentity == ((DocAndScoreQuery)((Object)obj)).contextIdentity && Arrays.equals(this.docs, ((DocAndScoreQuery)((Object)obj)).docs) && Arrays.equals(this.scores, ((DocAndScoreQuery)((Object)obj)).scores);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.contextIdentity, Arrays.hashCode(this.docs), Arrays.hashCode(this.scores));
    }
}

