/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.passay.CharacterRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.Rule;

public class PasswordGenerator {
    private static final int RETRY_LIMIT = 2;
    private final Random random;
    private int retryCount;

    public PasswordGenerator() {
        this(new SecureRandom());
    }

    public PasswordGenerator(Random r) {
        this.random = r;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    @Deprecated
    public String generatePassword(int length, CharacterRule ... rules) {
        return this.generatePassword(length, Arrays.asList(rules));
    }

    public <T extends Rule> String generatePassword(int length, T ... rules) {
        return this.generatePassword(length, Arrays.asList(rules));
    }

    /*
     * WARNING - void declaration
     */
    public String generatePassword(int length, List<? extends Rule> rules) {
        String generated;
        void var7_9;
        if (length <= 0) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        StringBuilder allChars = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(length);
        PasswordValidator validator = new PasswordValidator(rules);
        if (rules != null) {
            for (Rule rule : rules) {
                if (!(rule instanceof CharacterRule)) continue;
                CharacterRule characterRule = (CharacterRule)rule;
                this.fillRandomCharacters(characterRule.getValidCharacters(), Math.min(length, characterRule.getNumberOfCharacters()), buffer);
                allChars.append(characterRule.getValidCharacters());
            }
        }
        boolean bl = false;
        do {
            this.fillRandomCharacters(allChars, length - buffer.position(), buffer);
            ((Buffer)buffer).flip();
            this.randomize(buffer);
            generated = buffer.toString();
            if (var7_9 <= 0) continue;
            ++this.retryCount;
        } while (++var7_9 <= 2 && !validator.validate(new PasswordData(generated)).isValid());
        if (var7_9 > 2) {
            throw new IllegalStateException("Exceeded maximum number of password generation retries");
        }
        return generated;
    }

    protected void fillRandomCharacters(CharSequence source, int count, Appendable target) {
        for (int i = 0; i < count; ++i) {
            try {
                target.append(source.charAt(this.random.nextInt(source.length())));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Error appending characters.", e);
            }
        }
    }

    protected void randomize(CharBuffer buffer) {
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            int n = this.random.nextInt(buffer.length());
            char c = buffer.get(n);
            buffer.put(n, buffer.get(i));
            buffer.put(i, c);
        }
    }
}

