/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.compliance.ComplianceConfig;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuditConfig {
    public static final List<String> DEFAULT_IGNORED_USERS = Collections.singletonList("kibanaserver");
    private static Set<String> FIELDS = DefaultObjectMapper.getFields(AuditConfig.class);
    @JsonProperty(value="enabled")
    private final boolean auditLogEnabled;
    @JsonProperty(value="audit")
    private final Filter filter;
    private final ComplianceConfig compliance;
    public static final List<String> DEPRECATED_KEYS = ImmutableList.of((Object)"opendistro_security.audit.enable_rest", (Object)"opendistro_security.audit.config.disabled_rest_categories", (Object)"opendistro_security.audit.enable_transport", (Object)"opendistro_security.audit.config.disabled_transport_categories", (Object)"opendistro_security.audit.log_request_body", (Object)"opendistro_security.audit.resolve_indices", (Object)"opendistro_security.audit.exclude_sensitive_headers", (Object)"opendistro_security.audit.resolve_bulk_requests", (Object)"opendistro_security.audit.ignore_users", (Object)"opendistro_security.audit.ignore_requests", (Object)"opendistro_security.compliance.history.internal_config_enabled", (Object)"opendistro_security.compliance.history.external_config_enabled", (Object[])new String[]{"opendistro_security.compliance.history.read.metadata_only", "opendistro_security.compliance.history.read.ignore_users", "opendistro_security.compliance.history.read.watched_fields", "opendistro_security.compliance.history.write.metadata_only", "opendistro_security.compliance.history.write.log_diffs", "opendistro_security.compliance.history.write.ignore_users", "opendistro_security.compliance.history.write.watched_indices"});
    public static final Set<String> FIELD_PATHS = Sets.union(Utils.generateFieldResourcePaths(FIELDS, "/"), (Set)Sets.union(Utils.generateFieldResourcePaths(Filter.FIELDS, "/audit/"), Utils.generateFieldResourcePaths(ComplianceConfig.FIELDS, "/compliance/")));

    private AuditConfig() {
        this(true, null, null);
    }

    public boolean isEnabled() {
        return this.auditLogEnabled;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public ComplianceConfig getCompliance() {
        return this.compliance;
    }

    @VisibleForTesting
    public AuditConfig(boolean auditLogEnabled, Filter filter, ComplianceConfig compliance) {
        this.auditLogEnabled = auditLogEnabled;
        this.filter = filter != null ? filter : Filter.DEFAULT;
        this.compliance = compliance != null ? compliance : ComplianceConfig.DEFAULT;
    }

    public static AuditConfig from(Settings settings) {
        return new AuditConfig(true, Filter.from(settings), ComplianceConfig.from(settings));
    }

    public static Set<String> getDeprecatedKeys(Settings settings) {
        return DEPRECATED_KEYS.stream().filter(arg_0 -> ((Settings)settings).hasValue(arg_0)).collect(Collectors.toSet());
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Filter {
        private static Set<String> FIELDS = DefaultObjectMapper.getFields(Filter.class);
        @VisibleForTesting
        public static final Filter DEFAULT = Filter.from(Settings.EMPTY);
        private final boolean isRestApiAuditEnabled;
        private final boolean isTransportApiAuditEnabled;
        private final boolean resolveBulkRequests;
        private final boolean logRequestBody;
        private final boolean resolveIndices;
        private final boolean excludeSensitiveHeaders;
        @JsonProperty(value="ignore_users")
        private final Set<String> ignoredAuditUsers;
        @JsonProperty(value="ignore_requests")
        private final Set<String> ignoredAuditRequests;
        @JsonProperty(value="ignore_headers")
        private final Set<String> ignoredCustomHeaders;
        @JsonProperty(value="ignore_url_params")
        private Set<String> ignoredUrlParams;
        private final WildcardMatcher ignoredAuditUsersMatcher;
        private final WildcardMatcher ignoredAuditRequestsMatcher;
        private final WildcardMatcher ignoredCustomHeadersMatcher;
        private WildcardMatcher ignoredUrlParamsMatcher;
        private final Set<AuditCategory> disabledRestCategories;
        private final Set<AuditCategory> disabledTransportCategories;

        @VisibleForTesting
        Filter(boolean isRestApiAuditEnabled, boolean isTransportApiAuditEnabled, boolean resolveBulkRequests, boolean logRequestBody, boolean resolveIndices, boolean excludeSensitiveHeaders, Set<String> ignoredAuditUsers, Set<String> ignoredAuditRequests, Set<String> ignoredCustomHeaders, Set<String> ignoredUrlParams, Set<AuditCategory> disabledRestCategories, Set<AuditCategory> disabledTransportCategories) {
            this.isRestApiAuditEnabled = isRestApiAuditEnabled;
            this.isTransportApiAuditEnabled = isTransportApiAuditEnabled;
            this.resolveBulkRequests = resolveBulkRequests;
            this.logRequestBody = logRequestBody;
            this.resolveIndices = resolveIndices;
            this.excludeSensitiveHeaders = excludeSensitiveHeaders;
            this.ignoredAuditUsers = ignoredAuditUsers;
            this.ignoredAuditUsersMatcher = WildcardMatcher.from(ignoredAuditUsers);
            this.ignoredAuditRequests = ignoredAuditRequests;
            this.ignoredAuditRequestsMatcher = WildcardMatcher.from(ignoredAuditRequests);
            this.ignoredCustomHeaders = ignoredCustomHeaders;
            this.ignoredCustomHeadersMatcher = WildcardMatcher.from(ignoredCustomHeaders);
            this.ignoredUrlParams = ignoredUrlParams;
            this.ignoredUrlParamsMatcher = WildcardMatcher.from(ignoredUrlParams);
            this.disabledRestCategories = disabledRestCategories;
            this.disabledTransportCategories = disabledTransportCategories;
        }

        @JsonCreator
        @VisibleForTesting
        public static Filter from(Map<String, Object> properties) throws JsonProcessingException {
            if (!FIELDS.containsAll(properties.keySet())) {
                throw new UnrecognizedPropertyException(null, "Unrecognized field(s) present in the input data for audit filter config", null, Filter.class, null, null);
            }
            boolean isRestApiAuditEnabled = DefaultObjectMapper.getOrDefault(properties, FilterEntries.ENABLE_REST.getKey(), true);
            boolean isTransportAuditEnabled = DefaultObjectMapper.getOrDefault(properties, FilterEntries.ENABLE_TRANSPORT.getKey(), true);
            boolean resolveBulkRequests = DefaultObjectMapper.getOrDefault(properties, FilterEntries.RESOLVE_BULK_REQUESTS.getKey(), false);
            boolean logRequestBody = DefaultObjectMapper.getOrDefault(properties, FilterEntries.LOG_REQUEST_BODY.getKey(), true);
            boolean resolveIndices = DefaultObjectMapper.getOrDefault(properties, FilterEntries.RESOLVE_INDICES.getKey(), true);
            boolean excludeSensitiveHeaders = DefaultObjectMapper.getOrDefault(properties, FilterEntries.EXCLUDE_SENSITIVE_HEADERS.getKey(), true);
            Set<AuditCategory> disabledRestCategories = AuditCategory.parse((Collection<String>)DefaultObjectMapper.getOrDefault(properties, FilterEntries.DISABLE_REST_CATEGORIES.getKey(), ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            Set<AuditCategory> disabledTransportCategories = AuditCategory.parse((Collection<String>)DefaultObjectMapper.getOrDefault(properties, FilterEntries.DISABLE_TRANSPORT_CATEGORIES.getKey(), ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            ImmutableSet ignoredAuditUsers = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, FilterEntries.IGNORE_USERS.getKey(), DEFAULT_IGNORED_USERS));
            ImmutableSet ignoreAuditRequests = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, FilterEntries.IGNORE_REQUESTS.getKey(), Collections.emptyList()));
            ImmutableSet ignoreHeaders = ImmutableSet.copyOf((Collection)DefaultObjectMapper.getOrDefault(properties, FilterEntries.IGNORE_HEADERS.getKey(), Collections.emptyList()));
            return new Filter(isRestApiAuditEnabled, isTransportAuditEnabled, resolveBulkRequests, logRequestBody, resolveIndices, excludeSensitiveHeaders, (Set<String>)ignoredAuditUsers, (Set<String>)ignoreAuditRequests, (Set<String>)ignoreHeaders, new HashSet<String>(), disabledRestCategories, disabledTransportCategories);
        }

        public static Filter from(Settings settings) {
            boolean isRestApiAuditEnabled = Filter.fromSettingBoolean(settings, FilterEntries.ENABLE_REST, true);
            boolean isTransportAuditEnabled = Filter.fromSettingBoolean(settings, FilterEntries.ENABLE_TRANSPORT, true);
            boolean resolveBulkRequests = Filter.fromSettingBoolean(settings, FilterEntries.RESOLVE_BULK_REQUESTS, false);
            boolean logRequestBody = Filter.fromSettingBoolean(settings, FilterEntries.LOG_REQUEST_BODY, true);
            boolean resolveIndices = Filter.fromSettingBoolean(settings, FilterEntries.RESOLVE_INDICES, true);
            boolean excludeSensitiveHeaders = Filter.fromSettingBoolean(settings, FilterEntries.EXCLUDE_SENSITIVE_HEADERS, true);
            Set<AuditCategory> disabledRestCategories = AuditCategory.parse(Filter.fromSettingStringSet(settings, FilterEntries.DISABLE_REST_CATEGORIES, ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            Set<AuditCategory> disabledTransportCategories = AuditCategory.parse(Filter.fromSettingStringSet(settings, FilterEntries.DISABLE_TRANSPORT_CATEGORIES, ConfigConstants.OPENDISTRO_SECURITY_AUDIT_DISABLED_CATEGORIES_DEFAULT));
            Set<String> ignoredAuditUsers = Filter.fromSettingStringSet(settings, FilterEntries.IGNORE_USERS, DEFAULT_IGNORED_USERS);
            Set<String> ignoreAuditRequests = Filter.fromSettingStringSet(settings, FilterEntries.IGNORE_REQUESTS, Collections.emptyList());
            Set<String> ignoreHeaders = Filter.fromSettingStringSet(settings, FilterEntries.IGNORE_HEADERS, Collections.emptyList());
            return new Filter(isRestApiAuditEnabled, isTransportAuditEnabled, resolveBulkRequests, logRequestBody, resolveIndices, excludeSensitiveHeaders, ignoredAuditUsers, ignoreAuditRequests, ignoreHeaders, new HashSet<String>(), disabledRestCategories, disabledTransportCategories);
        }

        static boolean fromSettingBoolean(Settings settings, FilterEntries filterEntry, boolean defaultValue) {
            return settings.getAsBoolean(filterEntry.getKeyWithNamespace(), settings.getAsBoolean(filterEntry.getLegacyKeyWithNamespace(), Boolean.valueOf(defaultValue)));
        }

        static Set<String> fromSettingStringSet(Settings settings, FilterEntries filterEntry, List<String> defaultValue) {
            String defaultDetectorValue = "__DEFAULT_DETECTION__";
            Set<String> stringSetOfKey = ConfigConstants.getSettingAsSet(settings, filterEntry.getKeyWithNamespace(), (List<String>)ImmutableList.of((Object)"__DEFAULT_DETECTION__"), true);
            boolean foundDefault = stringSetOfKey.stream().anyMatch("__DEFAULT_DETECTION__"::equals);
            if (!foundDefault) {
                return stringSetOfKey;
            }
            return ConfigConstants.getSettingAsSet(settings, filterEntry.getLegacyKeyWithNamespace(), defaultValue, true);
        }

        @JsonProperty(value="enable_rest")
        public boolean isRestApiAuditEnabled() {
            return this.isRestApiAuditEnabled;
        }

        @JsonProperty(value="enable_transport")
        public boolean isTransportApiAuditEnabled() {
            return this.isTransportApiAuditEnabled;
        }

        @JsonProperty(value="resolve_bulk_requests")
        public boolean shouldResolveBulkRequests() {
            return this.resolveBulkRequests;
        }

        @JsonProperty(value="log_request_body")
        public boolean shouldLogRequestBody() {
            return this.logRequestBody;
        }

        @JsonProperty(value="resolve_indices")
        public boolean shouldResolveIndices() {
            return this.resolveIndices;
        }

        @JsonProperty(value="exclude_sensitive_headers")
        public boolean shouldExcludeSensitiveHeaders() {
            return this.excludeSensitiveHeaders;
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredAuditUsersMatcher() {
            return this.ignoredAuditUsersMatcher;
        }

        public boolean isAuditDisabled(String user) {
            return this.ignoredAuditUsersMatcher.test(user);
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredAuditRequestsMatcher() {
            return this.ignoredAuditRequestsMatcher;
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredCustomHeadersMatcher() {
            return this.ignoredCustomHeadersMatcher;
        }

        @VisibleForTesting
        WildcardMatcher getIgnoredUrlParamsMatcher() {
            return this.ignoredUrlParamsMatcher;
        }

        public boolean shouldExcludeUrlParam(String param) {
            return this.ignoredUrlParamsMatcher.test(param);
        }

        public boolean shouldExcludeHeader(String header) {
            return this.ignoredCustomHeadersMatcher.test(header);
        }

        public boolean isRequestAuditDisabled(String action) {
            return this.ignoredAuditRequestsMatcher.test(action);
        }

        public void setIgnoredUrlParams(Set<String> ignoredUrlParams) {
            if (ignoredUrlParams == null) {
                return;
            }
            this.ignoredUrlParamsMatcher = WildcardMatcher.from(ignoredUrlParams);
            this.ignoredUrlParams = ignoredUrlParams;
        }

        @JsonProperty(value="disabled_rest_categories")
        public Set<AuditCategory> getDisabledRestCategories() {
            return this.disabledRestCategories;
        }

        @JsonProperty(value="disabled_transport_categories")
        public Set<AuditCategory> getDisabledTransportCategories() {
            return this.disabledTransportCategories;
        }

        public void log(Logger logger) {
            logger.info("Auditing on REST API is {}.", (Object)(this.isRestApiAuditEnabled ? "enabled" : "disabled"));
            logger.info("{} are excluded from REST API auditing.", this.disabledRestCategories);
            logger.info("Auditing on Transport API is {}.", (Object)(this.isTransportApiAuditEnabled ? "enabled" : "disabled"));
            logger.info("{} are excluded from Transport API auditing.", this.disabledTransportCategories);
            logger.info("Auditing of request body is {}.", (Object)(this.logRequestBody ? "enabled" : "disabled"));
            logger.info("Bulk requests resolution is {} during request auditing.", (Object)(this.resolveBulkRequests ? "enabled" : "disabled"));
            logger.info("Index resolution is {} during request auditing.", (Object)(this.resolveIndices ? "enabled" : "disabled"));
            logger.info("Sensitive headers exclusion from auditing is {}.", (Object)(this.excludeSensitiveHeaders ? "enabled" : "disabled"));
            logger.info("Auditing requests from {} users is disabled.", (Object)this.ignoredAuditUsersMatcher);
            logger.info("Auditing request headers {} is disabled.", (Object)this.ignoredCustomHeadersMatcher);
            logger.info("Auditing request url params {} is disabled.", (Object)this.ignoredUrlParamsMatcher);
        }

        public String toString() {
            return "Filter{isRestApiAuditEnabled=" + this.isRestApiAuditEnabled + ", disabledRestCategories=" + this.disabledRestCategories + ", isTransportApiAuditEnabled=" + this.isTransportApiAuditEnabled + ", disabledTransportCategories=" + this.disabledTransportCategories + ", resolveBulkRequests=" + this.resolveBulkRequests + ", logRequestBody=" + this.logRequestBody + ", resolveIndices=" + this.resolveIndices + ", excludeSensitiveHeaders=" + this.excludeSensitiveHeaders + ", ignoredAuditUsers=" + this.ignoredAuditUsersMatcher + ", ignoreAuditRequests=" + this.ignoredAuditRequestsMatcher + ", ignoredCustomHeaders=" + this.ignoredCustomHeadersMatcher + ", ignoredUrlParamsMatcher=" + this.ignoredUrlParamsMatcher + "}";
        }

        public static enum FilterEntries {
            ENABLE_REST("enable_rest", "opendistro_security.audit.enable_rest"),
            ENABLE_TRANSPORT("enable_transport", "opendistro_security.audit.enable_transport"),
            RESOLVE_BULK_REQUESTS("resolve_bulk_requests", "opendistro_security.audit.resolve_bulk_requests"),
            LOG_REQUEST_BODY("log_request_body", "opendistro_security.audit.log_request_body"),
            RESOLVE_INDICES("resolve_indices", "opendistro_security.audit.resolve_indices"),
            EXCLUDE_SENSITIVE_HEADERS("exclude_sensitive_headers", "opendistro_security.audit.exclude_sensitive_headers"),
            DISABLE_REST_CATEGORIES("disabled_rest_categories", "opendistro_security.audit.config.disabled_rest_categories"),
            DISABLE_TRANSPORT_CATEGORIES("disabled_transport_categories", "opendistro_security.audit.config.disabled_transport_categories"),
            IGNORE_USERS("ignore_users", "opendistro_security.audit.ignore_users"),
            IGNORE_REQUESTS("ignore_requests", "opendistro_security.audit.ignore_requests"),
            IGNORE_HEADERS("ignore_headers", "plugins.security.audit.ignore_headers");

            private final String key;
            private final String legacyKeyWithNamespace;

            private FilterEntries(String entryKey, String legacyKeyWithNamespace) {
                this.key = entryKey;
                this.legacyKeyWithNamespace = legacyKeyWithNamespace;
            }

            public String getKey() {
                return this.key;
            }

            public String getKeyWithNamespace() {
                return "plugins.security.audit.config." + this.key;
            }

            public String getLegacyKeyWithNamespace() {
                return this.legacyKeyWithNamespace;
            }
        }
    }
}

