/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma;

import java.util.ArrayList;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.CallableNode;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;

public final class GammaObjectPool {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm,gamma.GammaObjectPool.enabled", "true"));
    private static final boolean TRANLOCAL_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.tranlocalPooling", String.valueOf(ENABLED)));
    private static final boolean TRANLOCALARRAY_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.tranlocalArrayPooling", String.valueOf(ENABLED)));
    private static final boolean LISTENER_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.listenersPooling", String.valueOf(ENABLED)));
    private static final boolean LISTENERSARRAY_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.listenersArrayPooling", String.valueOf(ENABLED)));
    private static final boolean ARRAYLIST_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.arrayListPooling", String.valueOf(ENABLED)));
    private static final boolean CALLABLENODE_POOLING_ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.GammaObjectPool.callableNodePooling", String.valueOf(ENABLED)));
    private final boolean tranlocalPoolingEnabled;
    private final boolean tranlocalArrayPoolingEnabled;
    private final boolean listenersPoolingEnabled;
    private final boolean listenersArrayPoolingEnabled;
    private final boolean arrayListPoolingEnabled;
    private final boolean callableNodePoolingEnabled;
    private final Tranlocal[] tranlocals = new Tranlocal[100];
    private int lastUsedGammaTxnRef = -1;
    private final Listeners[] listenersPool = new Listeners[100];
    private int listenersPoolIndex = -1;
    private final ArrayList[] arrayListPool = new ArrayList[10];
    private int arrayListPoolIndex = -1;
    private final CallableNode[] callableNodePool = new CallableNode[100];
    private int callableNodePoolIndex = -1;
    private Tranlocal[][] tranlocalArrayPool = new Tranlocal[8193][];
    private Listeners[] listenersArray = new Listeners[100000];

    public GammaObjectPool() {
        this.arrayListPoolingEnabled = ARRAYLIST_POOLING_ENABLED;
        this.tranlocalArrayPoolingEnabled = TRANLOCALARRAY_POOLING_ENABLED;
        this.tranlocalPoolingEnabled = TRANLOCAL_POOLING_ENABLED;
        this.listenersPoolingEnabled = LISTENER_POOLING_ENABLED;
        this.listenersArrayPoolingEnabled = LISTENERSARRAY_POOLING_ENABLED;
        this.callableNodePoolingEnabled = CALLABLENODE_POOLING_ENABLED;
    }

    public Tranlocal take(BaseGammaTxnRef owner) {
        if (owner == null) {
            throw new NullPointerException();
        }
        if (this.lastUsedGammaTxnRef == -1) {
            Tranlocal tranlocal = new Tranlocal();
            tranlocal.owner = owner;
            return tranlocal;
        }
        Tranlocal tranlocal = this.tranlocals[this.lastUsedGammaTxnRef];
        tranlocal.owner = owner;
        this.tranlocals[this.lastUsedGammaTxnRef] = null;
        --this.lastUsedGammaTxnRef;
        return tranlocal;
    }

    public void put(Tranlocal tranlocal) {
        if (!this.tranlocalPoolingEnabled) {
            return;
        }
        if (this.lastUsedGammaTxnRef == this.tranlocals.length - 1) {
            return;
        }
        ++this.lastUsedGammaTxnRef;
        this.tranlocals[this.lastUsedGammaTxnRef] = tranlocal;
    }

    public void putTranlocalArray(Tranlocal[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!this.tranlocalArrayPoolingEnabled) {
            return;
        }
        if (array.length - 1 > this.tranlocalArrayPool.length) {
            return;
        }
        int index = array.length;
        if (this.tranlocalArrayPool[index] != null) {
            return;
        }
        for (int k = 0; k < array.length; ++k) {
            array[k] = null;
        }
        this.tranlocalArrayPool[index] = array;
    }

    public Tranlocal[] takeTranlocalArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.tranlocalArrayPoolingEnabled) {
            return new Tranlocal[size];
        }
        if (size >= this.tranlocalArrayPool.length) {
            return new Tranlocal[size];
        }
        if (this.tranlocalArrayPool[size] == null) {
            return new Tranlocal[size];
        }
        Tranlocal[] array = this.tranlocalArrayPool[size];
        this.tranlocalArrayPool[size] = null;
        return array;
    }

    public CallableNode takeCallableNode() {
        if (!this.callableNodePoolingEnabled || this.callableNodePoolIndex == -1) {
            return new CallableNode();
        }
        CallableNode node = this.callableNodePool[this.callableNodePoolIndex];
        this.callableNodePool[this.callableNodePoolIndex] = null;
        --this.callableNodePoolIndex;
        return node;
    }

    public void putCallableNode(CallableNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.callableNodePoolingEnabled || this.callableNodePoolIndex == this.callableNodePool.length - 1) {
            return;
        }
        node.prepareForPooling();
        ++this.callableNodePoolIndex;
        this.callableNodePool[this.callableNodePoolIndex] = node;
    }

    public ArrayList takeArrayList() {
        if (!this.arrayListPoolingEnabled || this.arrayListPoolIndex == -1) {
            return new ArrayList(10);
        }
        ArrayList list = this.arrayListPool[this.arrayListPoolIndex];
        this.arrayListPool[this.arrayListPoolIndex] = null;
        --this.arrayListPoolIndex;
        return list;
    }

    public void putArrayList(ArrayList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (!this.arrayListPoolingEnabled || this.arrayListPoolIndex == this.arrayListPool.length - 1) {
            return;
        }
        list.clear();
        ++this.arrayListPoolIndex;
        this.arrayListPool[this.arrayListPoolIndex] = list;
    }

    public Listeners takeListeners() {
        if (!this.listenersPoolingEnabled || this.listenersPoolIndex == -1) {
            return new Listeners();
        }
        Listeners listeners = this.listenersPool[this.listenersPoolIndex];
        this.listenersPool[this.listenersPoolIndex] = null;
        --this.listenersPoolIndex;
        return listeners;
    }

    public void putListeners(Listeners listeners) {
        if (listeners == null) {
            throw new NullPointerException();
        }
        if (!this.listenersPoolingEnabled || this.listenersPoolIndex == this.listenersPool.length - 1) {
            return;
        }
        listeners.prepareForPooling();
        ++this.listenersPoolIndex;
        this.listenersPool[this.listenersPoolIndex] = listeners;
    }

    public Listeners[] takeListenersArray(int minimalSize) {
        if (minimalSize < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.listenersArrayPoolingEnabled) {
            return new Listeners[minimalSize];
        }
        if (this.listenersArray == null || this.listenersArray.length < minimalSize) {
            return new Listeners[minimalSize];
        }
        Listeners[] result = this.listenersArray;
        this.listenersArray = null;
        return result;
    }

    public void putListenersArray(Listeners[] listenersArray) {
        if (listenersArray == null) {
            throw new NullPointerException();
        }
        if (!this.listenersArrayPoolingEnabled) {
            return;
        }
        if (this.listenersArray != listenersArray) {
            return;
        }
        this.listenersArray = listenersArray;
    }
}

