from collections.abc import Iterator

from ._pygit2 import Oid, Reference
from .enums import ReferenceFilter
from .repository import BaseRepository

class References:
    def __init__(self, repository: BaseRepository) -> None: ...
    def __getitem__(self, name: str) -> Reference: ...
    def get(self, key: str) -> Reference | None: ...
    def __iter__(self) -> Iterator[Reference]: ...
    def iterator(self, references_return_type: ReferenceFilter = ...) -> Iterator[Reference]: ...
    def create(self, name: str, target: Oid | str, force: bool = False) -> Reference: ...
    def delete(self, name: str) -> None: ...
    def __contains__(self, name: str) -> bool: ...
    @property
    def objects(self) -> list[Reference]: ...
    def compress(self) -> None: ...
