/*
 * Decompiled with CFR 0.152.
 */
package org.prismlauncher.launcher.impl;

import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import org.prismlauncher.launcher.impl.AbstractLauncher;
import org.prismlauncher.utils.Parameters;
import org.prismlauncher.utils.ReflectionUtils;

public final class StandardLauncher
extends AbstractLauncher {
    private final boolean quickPlayMultiplayerSupported;
    private final boolean quickPlaySingleplayerSupported;

    public StandardLauncher(Parameters parameters) {
        super(parameters);
        List<String> list = parameters.getList("traits", Collections.emptyList());
        this.quickPlayMultiplayerSupported = list.contains("feature:is_quick_play_multiplayer");
        this.quickPlaySingleplayerSupported = list.contains("feature:is_quick_play_singleplayer");
    }

    @Override
    public void launch() throws Throwable {
        if (!this.maximize) {
            this.gameArgs.add("--width");
            this.gameArgs.add(Integer.toString(this.width));
            this.gameArgs.add("--height");
            this.gameArgs.add(Integer.toString(this.height));
        }
        if (this.serverAddress != null) {
            if (this.quickPlayMultiplayerSupported) {
                this.gameArgs.add("--quickPlayMultiplayer");
                this.gameArgs.add(this.serverAddress + ':' + this.serverPort);
            } else {
                this.gameArgs.add("--server");
                this.gameArgs.add(this.serverAddress);
                this.gameArgs.add("--port");
                this.gameArgs.add(this.serverPort);
            }
        } else if (this.worldName != null && this.quickPlaySingleplayerSupported) {
            this.gameArgs.add("--quickPlaySingleplayer");
            this.gameArgs.add(this.worldName);
        }
        MethodHandle methodHandle = ReflectionUtils.findMainMethod(this.mainClassName);
        methodHandle.invokeExact(this.gameArgs.toArray(new String[0]));
    }
}

