/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.dot.ProcessState;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;

public class ProcessRunner {
    private final String[] cmd;
    private String error;
    private String out;

    public ProcessRunner(String[] cmd) {
        this.cmd = cmd;
    }

    public ProcessState run(byte[] in, OutputStream redirection) {
        return this.run(in, redirection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState run(byte[] in, OutputStream redirection, SFile dir) {
        Process process = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(this.cmd);
            if (dir != null) {
                builder.directory(dir.conv());
            }
            builder.redirectErrorStream(true);
            process = builder.start();
            if (in != null) {
                try (OutputStream os = process.getOutputStream();){
                    os.write(in);
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (InputStream is = process.getInputStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                    if (redirection == null) continue;
                    redirection.write(buffer, 0, length);
                }
            }
            long timeoutMs = OptionFlags.getInstance().getTimeoutMs();
            boolean finished = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            outputStream.close();
            if (finished) {
                this.out = new String(outputStream.toByteArray(), "UTF-8");
                ProcessState processState = ProcessState.TERMINATED_OK();
                return processState;
            }
            ProcessState processState = ProcessState.TIMEOUT();
            return processState;
        }
        catch (Throwable e) {
            Logme.error(e);
            this.error = e.toString();
            ProcessState processState = ProcessState.EXCEPTION(e);
            return processState;
        }
        finally {
            if (process != null && this.out == null && process.isAlive()) {
                process.destroy();
                this.error = "Timeout - kill";
                try {
                    if (!process.waitFor(500L, TimeUnit.MILLISECONDS)) {
                        process.destroyForcibly();
                        this.error = "Timeout - kill force";
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final String getError() {
        return this.error;
    }

    public final String getOut() {
        return this.out;
    }
}

