import * as tslib_1 from "tslib";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { NumberFormatStyle } from '../../i18n/locale_data_api';
var NumberFormatter = /** @class */ (function () {
    function NumberFormatter() {
    }
    NumberFormatter.format = function (num, locale, style, opts) {
        if (opts === void 0) { opts = {}; }
        var minimumIntegerDigits = opts.minimumIntegerDigits, minimumFractionDigits = opts.minimumFractionDigits, maximumFractionDigits = opts.maximumFractionDigits, currency = opts.currency, _a = opts.currencyAsSymbol, currencyAsSymbol = _a === void 0 ? false : _a;
        var options = {
            minimumIntegerDigits: minimumIntegerDigits,
            minimumFractionDigits: minimumFractionDigits,
            maximumFractionDigits: maximumFractionDigits,
            style: NumberFormatStyle[style].toLowerCase()
        };
        if (style == NumberFormatStyle.Currency) {
            options.currency = typeof currency == 'string' ? currency : undefined;
            options.currencyDisplay = currencyAsSymbol ? 'symbol' : 'code';
        }
        return new Intl.NumberFormat(locale, options).format(num);
    };
    return NumberFormatter;
}());
export { NumberFormatter };
var DATE_FORMATS_SPLIT = /((?:[^yMLdHhmsazZEwGjJ']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|L+|d+|H+|h+|J+|j+|m+|s+|a|z|Z|G+|w+))(.*)/;
var PATTERN_ALIASES = {
    // Keys are quoted so they do not get renamed during closure compilation.
    'yMMMdjms': datePartGetterFactory(combine([
        digitCondition('year', 1),
        nameCondition('month', 3),
        digitCondition('day', 1),
        digitCondition('hour', 1),
        digitCondition('minute', 1),
        digitCondition('second', 1),
    ])),
    'yMdjm': datePartGetterFactory(combine([
        digitCondition('year', 1), digitCondition('month', 1), digitCondition('day', 1),
        digitCondition('hour', 1), digitCondition('minute', 1)
    ])),
    'yMMMMEEEEd': datePartGetterFactory(combine([
        digitCondition('year', 1), nameCondition('month', 4), nameCondition('weekday', 4),
        digitCondition('day', 1)
    ])),
    'yMMMMd': datePartGetterFactory(combine([digitCondition('year', 1), nameCondition('month', 4), digitCondition('day', 1)])),
    'yMMMd': datePartGetterFactory(combine([digitCondition('year', 1), nameCondition('month', 3), digitCondition('day', 1)])),
    'yMd': datePartGetterFactory(combine([digitCondition('year', 1), digitCondition('month', 1), digitCondition('day', 1)])),
    'jms': datePartGetterFactory(combine([digitCondition('hour', 1), digitCondition('second', 1), digitCondition('minute', 1)])),
    'jm': datePartGetterFactory(combine([digitCondition('hour', 1), digitCondition('minute', 1)]))
};
var DATE_FORMATS = {
    // Keys are quoted so they do not get renamed.
    'yyyy': datePartGetterFactory(digitCondition('year', 4)),
    'yy': datePartGetterFactory(digitCondition('year', 2)),
    'y': datePartGetterFactory(digitCondition('year', 1)),
    'MMMM': datePartGetterFactory(nameCondition('month', 4)),
    'MMM': datePartGetterFactory(nameCondition('month', 3)),
    'MM': datePartGetterFactory(digitCondition('month', 2)),
    'M': datePartGetterFactory(digitCondition('month', 1)),
    'LLLL': datePartGetterFactory(nameCondition('month', 4)),
    'L': datePartGetterFactory(nameCondition('month', 1)),
    'dd': datePartGetterFactory(digitCondition('day', 2)),
    'd': datePartGetterFactory(digitCondition('day', 1)),
    'HH': digitModifier(hourExtractor(datePartGetterFactory(hour12Modify(digitCondition('hour', 2), false)))),
    'H': hourExtractor(datePartGetterFactory(hour12Modify(digitCondition('hour', 1), false))),
    'hh': digitModifier(hourExtractor(datePartGetterFactory(hour12Modify(digitCondition('hour', 2), true)))),
    'h': hourExtractor(datePartGetterFactory(hour12Modify(digitCondition('hour', 1), true))),
    'jj': datePartGetterFactory(digitCondition('hour', 2)),
    'j': datePartGetterFactory(digitCondition('hour', 1)),
    'mm': digitModifier(datePartGetterFactory(digitCondition('minute', 2))),
    'm': datePartGetterFactory(digitCondition('minute', 1)),
    'ss': digitModifier(datePartGetterFactory(digitCondition('second', 2))),
    's': datePartGetterFactory(digitCondition('second', 1)),
    // while ISO 8601 requires fractions to be prefixed with `.` or `,`
    // we can be just safely rely on using `sss` since we currently don't support single or two digit
    // fractions
    'sss': datePartGetterFactory(digitCondition('second', 3)),
    'EEEE': datePartGetterFactory(nameCondition('weekday', 4)),
    'EEE': datePartGetterFactory(nameCondition('weekday', 3)),
    'EE': datePartGetterFactory(nameCondition('weekday', 2)),
    'E': datePartGetterFactory(nameCondition('weekday', 1)),
    'a': hourClockExtractor(datePartGetterFactory(hour12Modify(digitCondition('hour', 1), true))),
    'Z': timeZoneGetter('short'),
    'z': timeZoneGetter('long'),
    'ww': datePartGetterFactory({}),
    // first Thursday of the year. not support ?
    'w': datePartGetterFactory({}),
    // of the year not support ?
    'G': datePartGetterFactory(nameCondition('era', 1)),
    'GG': datePartGetterFactory(nameCondition('era', 2)),
    'GGG': datePartGetterFactory(nameCondition('era', 3)),
    'GGGG': datePartGetterFactory(nameCondition('era', 4))
};
function digitModifier(inner) {
    return function (date, locale) {
        var result = inner(date, locale);
        return result.length == 1 ? '0' + result : result;
    };
}
function hourClockExtractor(inner) {
    return function (date, locale) { return inner(date, locale).split(' ')[1]; };
}
function hourExtractor(inner) {
    return function (date, locale) { return inner(date, locale).split(' ')[0]; };
}
function intlDateFormat(date, locale, options) {
    return new Intl.DateTimeFormat(locale, options).format(date).replace(/[\u200e\u200f]/g, '');
}
function timeZoneGetter(timezone) {
    // To workaround `Intl` API restriction for single timezone let format with 24 hours
    var options = { hour: '2-digit', hour12: false, timeZoneName: timezone };
    return function (date, locale) {
        var result = intlDateFormat(date, locale, options);
        // Then extract first 3 letters that related to hours
        return result ? result.substring(3) : '';
    };
}
function hour12Modify(options, value) {
    options.hour12 = value;
    return options;
}
function digitCondition(prop, len) {
    var result = {};
    result[prop] = len === 2 ? '2-digit' : 'numeric';
    return result;
}
function nameCondition(prop, len) {
    var result = {};
    if (len < 4) {
        result[prop] = len > 1 ? 'short' : 'narrow';
    }
    else {
        result[prop] = 'long';
    }
    return result;
}
function combine(options) {
    return options.reduce(function (merged, opt) { return (tslib_1.__assign({}, merged, opt)); }, {});
}
function datePartGetterFactory(ret) {
    return function (date, locale) { return intlDateFormat(date, locale, ret); };
}
var DATE_FORMATTER_CACHE = new Map();
function dateFormatter(format, date, locale) {
    var fn = PATTERN_ALIASES[format];
    if (fn)
        return fn(date, locale);
    var cacheKey = format;
    var parts = DATE_FORMATTER_CACHE.get(cacheKey);
    if (!parts) {
        parts = [];
        var match = void 0;
        DATE_FORMATS_SPLIT.exec(format);
        var _format = format;
        while (_format) {
            match = DATE_FORMATS_SPLIT.exec(_format);
            if (match) {
                parts = parts.concat(match.slice(1));
                _format = parts.pop();
            }
            else {
                parts.push(_format);
                _format = null;
            }
        }
        DATE_FORMATTER_CACHE.set(cacheKey, parts);
    }
    return parts.reduce(function (text, part) {
        var fn = DATE_FORMATS[part];
        return text + (fn ? fn(date, locale) : partToTime(part));
    }, '');
}
function partToTime(part) {
    return part === '\'\'' ? '\'' : part.replace(/(^'|'$)/g, '').replace(/''/g, '\'');
}
var DateFormatter = /** @class */ (function () {
    function DateFormatter() {
    }
    DateFormatter.format = function (date, locale, pattern) {
        return dateFormatter(pattern, date, locale);
    };
    return DateFormatter;
}());
export { DateFormatter };
//# sourceMappingURL=data:application/json;base64,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