/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolIntWrapper;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0016J\u0014\u00103\u001a\u00020\u00182\n\u00101\u001a\u0006\u0012\u0002\b\u000304H\u0016J\u0010\u00105\u001a\u00020\u00182\u0006\u00101\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00182\u0006\u00101\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u0010.\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00182\u0006\u00101\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00182\u0006\u0010A\u001a\u00020\u001dH\u0016J\u0010\u0010B\u001a\u00020\u00182\u0006\u00101\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00182\u0006\u00101\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00182\u0006\u00101\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00182\u0006\u00101\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00182\u0006\u00101\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u00182\u0006\u00101\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00182\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\u00182\u0006\u00101\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00182\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u00182\u0006\u00101\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u00182\u0006\u0010>\u001a\u00020YH\u0016J\n\u0010Z\u001a\u00020\u0018*\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "generateCall", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateExpression", "elem", "Lorg/jetbrains/kotlin/ir/IrElement;", "generateInstanceFieldAccess", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateStatement", "statement", "generateTypeRTT", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "tryToGenerateIntrinsicCall", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "tryToGenerateWasmOpIntrinsicCall", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "buildGetUnit", "backend.wasm"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmFunctionCodegenContext context;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;

    public BodyGenerator(@NotNull WasmFunctionCodegenContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.body = this.context.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IrSimpleFunction>(this){
            final /* synthetic */ BodyGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return MiscKt.findUnitGetInstanceFunction(BodyGenerator.access$getBackendContext$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final WasmFunctionCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$buildGetUnit, (String)"<this>");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(this.context.referenceFunction(this.getUnitGetInstance().getSymbol()))};
        $this$buildGetUnit.buildInstr(WasmOp.GET_UNIT, wasmImmediateArray);
    }

    private final void generateExpression(IrElement elem) {
        boolean bl;
        boolean bl2 = bl = elem instanceof IrExpression || elem instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        IrVisitorsKt.acceptVoid(elem, this);
        if (elem instanceof IrExpression && Intrinsics.areEqual((Object)((IrExpression)elem).getType(), (Object)this.irBuiltIns.getNothingType())) {
            this.body.buildUnreachable();
        }
    }

    private final void generateStatement(IrElement statement2) {
        boolean bl;
        boolean bl2 = bl = statement2 instanceof IrExpression || statement2 instanceof IrVariable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Unsupported statement kind";
            throw new AssertionError((Object)string2);
        }
        this.generateExpression(statement2);
        if (statement2 instanceof IrExpression && !Intrinsics.areEqual((Object)((IrExpression)statement2).getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.body.buildDrop();
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression(expression2.getValue());
        this.body.buildThrow(this.context.getTagIdx());
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.irBuiltIns);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "expected canonical try/catch";
            throw new AssertionError((Object)string2);
        }
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        this.body.buildTry(null, resultType);
        this.generateExpression(aTry.getTryResult());
        this.body.buildCatch(this.context.getTagIdx());
        IrVariableSymbol it = ((IrCatch)CollectionsKt.single(aTry.getCatches())).getCatchParameter().getSymbol();
        boolean bl3 = false;
        this.context.defineLocal(it);
        this.body.buildSetLocal(this.context.referenceLocal(it));
        this.generateExpression(((IrCatch)CollectionsKt.single(aTry.getCatches())).getResult());
        this.body.buildEnd();
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression(expression2.getArgument());
                break;
            }
            case 2: {
                this.generateStatement(expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string2 = "Other types of casts must be lowered";
                throw new AssertionError((Object)string2);
            }
        }
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        DeclarationGeneratorKt.generateConstExpression(expression2, this.body, this.context);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression(receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(field2))) {
                this.generateInstanceFieldAccess(field2);
            }
        } else {
            this.body.buildGetGlobal(this.context.referenceGlobal(field2.getSymbol()));
        }
    }

    private final void generateInstanceFieldAccess(IrField field2) {
        WasmImmediate[] wasmImmediateArray = field2.getType();
        WasmOp opcode = Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (((Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getBooleanType()) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getByteType())) ? true : Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getShortType())) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol())), new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field2))};
        this.body.buildInstr(opcode, wasmImmediateArray);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression(receiver);
            this.generateExpression(expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol()), this.context.getStructFieldRef(field2));
        } else {
            this.generateExpression(expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobal(expression2.getSymbol()));
        }
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.context.referenceLocal(0) : this.context.referenceLocal(valueSymbol));
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression(expression2.getValue());
        this.body.buildSetLocal(this.context.referenceLocal(expression2.getSymbol()));
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)expression2.getSymbol().getOwner());
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klass.getSymbol());
        if (AnnotationsKt.getWasmArrayAnnotation(klass) != null) {
            if (!(expression2.getValueArgumentsCount() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression(irExpression);
            this.body.buildRttCanon(wasmGcType);
            WasmImmediate[] $i$a$-require-BodyGenerator$visitConstructorCall$32 = new WasmImmediate[]{new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT_WITH_RTT, $i$a$-require-BodyGenerator$visitConstructorCall$32);
            return;
        }
        WasmSymbol<Integer> wasmClassId = this.context.referenceClassId(klass.getSymbol());
        List<IrField> irFields = ClassInfoKt.allFields(klass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index2 = n;
            boolean bl = false;
            if (index2 == 0) {
                this.body.buildConstI32Symbol(wasmClassId);
                continue;
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(field2.getType()), this.body);
        }
        this.body.buildGetGlobal(this.context.referenceClassRTT(klass.getSymbol()));
        this.body.buildStructNew(wasmGcType);
        this.generateCall(expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass(this.context.getIrFunction());
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(klass))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.context.referenceLocal(0));
        this.generateCall(expression2);
    }

    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        IrExpression it;
        if (Intrinsics.areEqual(call2.getSymbol(), (Object)this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType toType = irType;
            IrClass irClass2 = TypeTransformerKt.getGetRuntimeClass(toType);
            Intrinsics.checkNotNull((Object)irClass2);
            IrClass klass = irClass2;
            WasmSymbol<WasmTypeDeclaration> structTypeName = this.context.referenceGcType(klass.getSymbol());
            WasmSymbol<Integer> klassId = this.context.referenceClassId(klass.getSymbol());
            this.body.buildConstI32Symbol(klassId);
            this.body.buildConstI32(0);
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression(irExpression);
            this.body.buildGetGlobal(this.context.referenceClassRTT(klass.getSymbol()));
            this.body.buildStructNew(structTypeName);
            return;
        }
        if (Intrinsics.areEqual(call2.getSymbol(), (Object)this.getUnitGetInstance().getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (Intrinsics.areEqual(call2.getSymbol(), (Object)this.wasmSymbols.getRangeCheck()) && Intrinsics.areEqual((Object)this.backendContext.getConfiguration().getNotNull(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS), (Object)false)) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression != null) {
            it = irExpression;
            boolean bl = false;
            this.generateExpression(it);
        }
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl = false;
            this.generateExpression(it);
        }
        int structTypeName = call2.getValueArgumentsCount();
        for (int i = 0; i < structTypeName; ++i) {
            IrExpression valueArgument = call2.getValueArgument(i);
            if (valueArgument == null) {
                DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(function2.getValueParameters().get(i).getType()), this.body);
                continue;
            }
            this.generateExpression(valueArgument);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass(function2);
            if (!IrUtilsKt.isInterface(klass)) {
                int n;
                block16: {
                    ClassMetadata classMetadata = this.context.getClassMetadata(klass.getSymbol());
                    List<VirtualMethodMetadata> $this$indexOfFirst$iv = classMetadata.getVirtualMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<VirtualMethodMetadata> iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        VirtualMethodMetadata item$iv;
                        VirtualMethodMetadata it2 = item$iv = iterator2.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it2.getFunction(), (Object)function2)) {
                            n = index$iv;
                            break block16;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int vfSlot = n;
                IrExpression irExpression3 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression3);
                this.generateExpression(irExpression3);
                this.body.buildConstI32(vfSlot);
                this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getGetVirtualMethodId()));
                WasmExpressionBuilder.buildCallIndirect$default(this.body, this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()), null, 2, null);
            } else {
                IrExpression irExpression4 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression4);
                this.generateExpression(irExpression4);
                this.body.buildConstI32Symbol(this.context.referenceInterfaceId(klass.getSymbol()));
                this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getGetInterfaceImplId()));
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                WasmSymbolIntWrapper wasmSymbolIntWrapper = new WasmSymbolIntWrapper(this.context.referenceInterfaceTable(((IrSimpleFunction)function2).getSymbol()));
                WasmSymbol<WasmFunctionType> wasmSymbol = this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol());
                wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolIntWrapper);
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()));
        }
        if (Intrinsics.areEqual((Object)function2.getReturnType(), (Object)this.irBuiltIns.getUnitType())) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateTypeRTT(IrType type2) {
        Object object = TypeTransformerKt.getGetRuntimeClass(type2);
        if (object == null || (object = ((IrClass)object).getSymbol()) == null) {
            object = this.context.getBackendContext().getIrBuiltIns().getAnyClass();
        }
        Object rtClass = object;
        this.body.buildGetGlobal(this.context.referenceClassRTT((IrClassSymbol)rtClass));
    }

    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmClassId())) {
            boolean bl;
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass2 = IrTypesKt.getClass(irType);
            if (irClass2 == null) {
                throw new IllegalStateException("No class given for wasmClassId intrinsic".toString());
            }
            IrClass klass = irClass2;
            boolean bl2 = bl = !IrUtilsKt.isInterface(klass);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.body.buildConstI32Symbol(this.context.referenceClassId(klass.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmInterfaceId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass3 = IrTypesKt.getClass(irType);
            if (irClass3 == null) {
                throw new IllegalStateException("No interface given for wasmInterfaceId intrinsic".toString());
            }
            IrClass irInterface = irClass3;
            boolean bl = IrUtilsKt.isInterface(irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.body.buildConstI32Symbol(this.context.referenceInterfaceId(irInterface.getSymbol()));
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmRefCast())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType toType = irType;
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing(fromType)) {
                this.body.buildUnreachable();
                return true;
            }
            if (IrTypePredicatesKt.isNothing(IrTypesKt.makeNotNull(fromType))) {
                this.body.buildUnreachable();
                return true;
            }
            IrType irType2 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull((Object)irType2);
            IrType toType = irType2;
            IrClass irClass4 = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull((Object)irClass4);
            IrClass klass = irClass4;
            IrField field2 = InlineClassesKt.getInlineClassBackingField(klass);
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
            this.generateInstanceFieldAccess(field2);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildDrop();
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Iterable $this$forEach$iv = body2.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrElement p0 = (IrElement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List<IrStatement> statements = expression2.getStatements();
        if (statements.isEmpty()) {
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(statements, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            this.generateStatement(it);
        }
        this.generateExpression((IrElement)CollectionsKt.last(statements));
        if (!(CollectionsKt.last(statements) instanceof IrExpression) && !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.buildGetUnit(this.body);
        }
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK));
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE));
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType(expression2.getReturnTargetSymbol().getOwner(), this.backendContext), (Object)this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol().getOwner(), (Object)this.getUnitGetInstance())) {
            this.generateStatement(expression2.getValue());
        } else {
            this.generateExpression(expression2.getValue());
        }
        if (this.context.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.context.referenceLocal(0));
        }
        this.body.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        for (IrBranch irBranch : expression2.getBranches()) {
            if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(irBranch)) {
                this.generateExpression(irBranch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateExpression(irBranch.getResult());
                if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType())) {
                    this.body.buildUnreachable();
                }
                this.body.buildElse();
                ++ifCount;
                continue;
            }
            this.generateExpression(irBranch.getResult());
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType())) {
                this.body.buildUnreachable();
            }
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(resultType, this.body);
        }
        int n = 0;
        while (n < ifCount) {
            int n2 = n++;
            boolean bl = false;
            this.body.buildEnd();
        }
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder.buildLoop$default(this.body, label, null, 2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, "BREAK_" + label, null, 2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, "CONTINUE_" + label, null, 2, null);
        int wasmContinueBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            this.generateStatement(it);
        }
        this.body.buildEnd();
        this.generateExpression(loop2.getCondition());
        this.body.buildBrIf(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkNotNullParameter((Object)loop2, (String)"loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder.buildLoop$default(this.body, label, null, 2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, "BREAK_" + label, null, 2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression(loop2.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            this.generateStatement(it);
        }
        this.body.buildBr(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
        this.buildGetUnit(this.body);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.context.defineLocal(declaration.getSymbol());
        if (declaration.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression init2 = irExpression;
        this.generateExpression(init2);
        WasmLocal varName = this.context.referenceLocal(declaration.getSymbol());
        this.body.buildSetLocal(varName);
    }

    public final boolean tryToGenerateWasmOpIntrinsicCall(@NotNull IrFunctionAccessExpression call2, @NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation(function2);
        if (opString != null) {
            WasmOp op = WasmOp.valueOf(opString);
            boolean $i$f$emptyArray = false;
            WasmImmediate[] immediates = (WasmImmediate[])((Object[])new WasmImmediate[0]);
            switch (op.getImmediates().size()) {
                case 0: {
                    if (WhenMappings.$EnumSwitchMapping$1[op.ordinal()] != 1) break;
                    IrType irType = call2.getTypeArgument(0);
                    Intrinsics.checkNotNull((Object)irType);
                    IrType toIrType2 = irType;
                    this.generateTypeRTT(toIrType2);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$2[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                            Intrinsics.checkNotNull((Object)irValueParameter);
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irValueParameter.getType());
                            Intrinsics.checkNotNull((Object)irClassSymbol);
                            wasmImmediate = new WasmImmediate.GcType(this.context.referenceGcType(irClassSymbol));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + (Object)((Object)imm) + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    immediates = wasmImmediateArray;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            this.body.buildInstr(op, Arrays.copyOf(immediates, immediates.length));
            return true;
        }
        return false;
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    public static final /* synthetic */ WasmBackendContext access$getBackendContext$p(BodyGenerator $this) {
        return $this.backendContext;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmOp.values().length];
            nArray[WasmOp.REF_TEST.ordinal()] = 1;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

