/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.PsiSourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u0004H&J\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007H&J\f\u0010\b\u001a\u00020\t*\u00020\nH&J\f\u0010\u000b\u001a\u00020\t*\u00020\fH&J\f\u0010\r\u001a\u00020\t*\u00020\fH&J\f\u0010\u000e\u001a\u00020\t*\u00020\fH&\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "", "getRawIdentifier", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getRawName", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isCatchElementParameter", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "isInConstructorCallee", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isInTypeConstraint", "isRedundantNullable", "Companion", "checkers"})
public interface SourceNavigator {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator$Companion.$$INSTANCE;

    public boolean isInConstructorCallee(@NotNull FirTypeRef var1);

    public boolean isInTypeConstraint(@NotNull FirTypeRef var1);

    @Nullable
    public CharSequence getRawIdentifier(@NotNull KtSourceElement var1);

    @Nullable
    public String getRawName(@NotNull FirDeclaration var1);

    public boolean isCatchElementParameter(@NotNull FirValueParameterSymbol var1);

    public boolean isRedundantNullable(@NotNull FirTypeRef var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\nJ4\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\n2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J4\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\b2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\b\u000fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator$Companion;", "", "()V", "lightTreeInstance", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "forElement", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "e", "Lorg/jetbrains/kotlin/fir/FirElement;", "forSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "withNavigator", "R", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/KtSourceElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final LightTreeSourceNavigator lightTreeInstance;

        private Companion() {
        }

        @NotNull
        public final SourceNavigator forElement(@NotNull FirElement e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.forSource(e.getSource());
        }

        @NotNull
        public final SourceNavigator forSource(@Nullable KtSourceElement e) {
            SourceNavigator sourceNavigator;
            KtSourceElement ktSourceElement = e;
            if (ktSourceElement instanceof KtLightSourceElement) {
                sourceNavigator = lightTreeInstance;
            } else if (ktSourceElement instanceof KtPsiSourceElement) {
                sourceNavigator = PsiSourceNavigator.INSTANCE;
            } else if (ktSourceElement == null) {
                sourceNavigator = lightTreeInstance;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return sourceNavigator;
        }

        public final <R> R withNavigator(@NotNull FirElement $this$withNavigator, @NotNull Function1<? super SourceNavigator, ? extends R> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withNavigator, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withNavigator = false;
            return (R)block.invoke((Object)this.forSource($this$withNavigator.getSource()));
        }

        public final <R> R withNavigator(@NotNull KtSourceElement $this$withNavigator, @NotNull Function1<? super SourceNavigator, ? extends R> block) {
            Intrinsics.checkNotNullParameter((Object)$this$withNavigator, (String)"<this>");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$withNavigator = false;
            return (R)block.invoke((Object)this.forSource($this$withNavigator));
        }

        static {
            $$INSTANCE = new Companion();
            lightTreeInstance = new LightTreeSourceNavigator();
        }
    }
}

