# This file has been autogenerated by the pywayland scanner

# Copyright © 2019 Christopher Billington
# Copyright © 2020 Ilia Bozhinov
# Copyright © 2022 Victoria Brekenfeld
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_workspace_group_handle_v1 import ExtWorkspaceGroupHandleV1
from .ext_workspace_handle_v1 import ExtWorkspaceHandleV1


class ExtWorkspaceManagerV1(Interface):
    """List and control workspaces

    Workspaces, also called virtual desktops, are groups of surfaces. A
    compositor with a concept of workspaces may only show some such groups of
    surfaces (those of 'active' workspaces) at a time. 'Activating' a workspace
    is a request for the compositor to display that workspace's surfaces as
    normal, whereas the compositor may hide or otherwise de-emphasise surfaces
    that are associated only with 'inactive' workspaces. Workspaces are grouped
    by which sets of outputs they correspond to, and may contain surfaces only
    from those outputs. In this way, it is possible for each output to have its
    own set of workspaces, or for all outputs (or any other arbitrary grouping)
    to share workspaces. Compositors may optionally conceptually arrange each
    group of workspaces in an N-dimensional grid.

    The purpose of this protocol is to enable the creation of taskbars and
    docks by providing them with a list of workspaces and their properties, and
    allowing them to activate and deactivate workspaces.

    After a client binds the :class:`ExtWorkspaceManagerV1`, each workspace
    will be sent via the workspace event.
    """

    name = "ext_workspace_manager_v1"
    version = 1


class ExtWorkspaceManagerV1Proxy(Proxy[ExtWorkspaceManagerV1]):
    interface = ExtWorkspaceManagerV1

    @ExtWorkspaceManagerV1.request()
    def commit(self) -> None:
        """All requests about the workspaces have been sent

        The client must send this request after it has finished sending other
        requests. The compositor must process a series of requests preceding a
        commit request atomically.

        This allows changes to the workspace properties to be seen as atomic,
        even if they happen via multiple events, and even if they involve
        multiple
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`
        objects, for example, deactivating one workspace and activating
        another.
        """
        self._marshal(0)

    @ExtWorkspaceManagerV1.request()
    def stop(self) -> None:
        """Stop sending events

        Indicates the client no longer wishes to receive events for new
        workspace groups. However the compositor may emit further workspace
        events, until the finished event is emitted. The compositor is expected
        to send the finished event eventually once the stop request has been
        processed.

        The client must not send any requests after this one, doing so will
        raise a :class:`~pywayland.protocol.wayland.WlDisplay` invalid_object
        error.
        """
        self._marshal(1)


class ExtWorkspaceManagerV1Resource(Resource):
    interface = ExtWorkspaceManagerV1

    @ExtWorkspaceManagerV1.event(
        Argument(ArgumentType.NewId, interface=ExtWorkspaceGroupHandleV1),
    )
    def workspace_group(self, workspace_group: ExtWorkspaceGroupHandleV1) -> None:
        """A workspace group has been created

        This event is emitted whenever a new workspace group has been created.

        All initial details of the workspace group (outputs) will be sent
        immediately after this event via the corresponding events in
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceGroupHandleV1`
        and :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`.

        :param workspace_group:
        :type workspace_group:
            :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceGroupHandleV1`
        """
        self._post_event(0, workspace_group)

    @ExtWorkspaceManagerV1.event(
        Argument(ArgumentType.NewId, interface=ExtWorkspaceHandleV1),
    )
    def workspace(self, workspace: ExtWorkspaceHandleV1) -> None:
        """Workspace has been created

        This event is emitted whenever a new workspace has been created.

        All initial details of the workspace (name, coordinates, state) will be
        sent immediately after this event via the corresponding events in
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`.

        Workspaces start off unassigned to any workspace group.

        :param workspace:
        :type workspace:
            :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`
        """
        self._post_event(1, workspace)

    @ExtWorkspaceManagerV1.event()
    def done(self) -> None:
        """All information about the workspaces and workspace groups has been sent

        This event is sent after all changes in all workspaces and workspace
        groups have been sent.

        This allows changes to one or more
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceGroupHandleV1`
        properties and
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`
        properties to be seen as atomic, even if they happen via multiple
        events. In particular, an output moving from one workspace group to
        another sends an output_enter event and an output_leave event to the
        two
        :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceGroupHandleV1`
        objects in question. The compositor sends the done event only after
        updating the output information in both workspace groups.
        """
        self._post_event(2)

    @ExtWorkspaceManagerV1.event()
    def finished(self) -> None:
        """The compositor has finished with the workspace_manager

        This event indicates that the compositor is done sending events to the
        :class:`ExtWorkspaceManagerV1`. The server will destroy the object
        immediately after sending this request.
        """
        self._post_event(3)


class ExtWorkspaceManagerV1Global(Global):
    interface = ExtWorkspaceManagerV1


ExtWorkspaceManagerV1._gen_c()
ExtWorkspaceManagerV1.proxy_class = ExtWorkspaceManagerV1Proxy
ExtWorkspaceManagerV1.resource_class = ExtWorkspaceManagerV1Resource
ExtWorkspaceManagerV1.global_class = ExtWorkspaceManagerV1Global
