# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_ssh_openpgp_auth_global_optspecs
	string join \n h/help
end

function __fish_ssh_openpgp_auth_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_ssh_openpgp_auth_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_ssh_openpgp_auth_using_subcommand
	set -l cmd (__fish_ssh_openpgp_auth_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_needs_command" -s h -l help -d 'Print help'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_needs_command" -f -a "authenticate" -d 'Fetches OpenPGP host certificates, verifies it and prints host keys in SSH format on successful verification'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -s t -l time -d 'Certificate time. By default now. Example: 2021-11-21T11:11:11Z' -r
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -s c -l cert-store -d 'Certificate store. By default uses user\'s shared PGP certificate directory' -r -F
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -l nameserver -d 'Nameserver to use for DNS lookups (if enabled)' -r
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -l verify-dns-proof -d 'Verify Keyoxide DNS proofs of certificates'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -l verify-wot -d 'Verify the certificates using local Web of Trust network'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -l verbose -d 'Print details of the verification process. Useful for debugging'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -l store-verifications -d 'Store verification results in the OpenPGP certificate'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand authenticate" -s h -l help -d 'Print help'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from authenticate help" -f -a "authenticate" -d 'Fetches OpenPGP host certificates, verifies it and prints host keys in SSH format on successful verification'
complete -c ssh-openpgp-auth -n "__fish_ssh_openpgp_auth_using_subcommand help; and not __fish_seen_subcommand_from authenticate help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
