/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.res.StringManager;

public class TLSCertificateReloadListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(TLSCertificateReloadListener.class);
    private static final StringManager sm = StringManager.getManager(TLSCertificateReloadListener.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private int checkPeriod = 86400;
    private int daysBefore = 14;
    private Calendar nextCheck = Calendar.getInstance();

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(int n) {
        this.checkPeriod = n;
    }

    public int getDaysBefore() {
        return this.daysBefore;
    }

    public void setDaysBefore(int n) {
        this.daysBefore = n;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (lifecycleEvent.getType().equals("periodic")) {
            if (!(lifecycleEvent.getSource() instanceof Server)) {
                return;
            }
            Server server = (Server)lifecycleEvent.getSource();
            this.checkCertificatesForRenewal(server);
        } else if (lifecycleEvent.getType().equals("before_init") && !(lifecycleEvent.getLifecycle() instanceof Server)) {
            log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
        }
    }

    private void checkCertificatesForRenewal(Server server) {
        Service[] serviceArray;
        Calendar calendar = Calendar.getInstance();
        if (calendar.compareTo(this.nextCheck) <= 0) {
            return;
        }
        this.nextCheck.add(13, this.getCheckPeriod());
        calendar.add(5, this.getDaysBefore());
        for (Service service : serviceArray = server.findServices()) {
            Connector[] connectorArray;
            for (Connector connector : connectorArray = service.findConnectors()) {
                SSLHostConfig[] sSLHostConfigArray;
                for (SSLHostConfig sSLHostConfig : sSLHostConfigArray = connector.findSslHostConfigs()) {
                    if (sSLHostConfig.certificatesExpiringBefore(calendar.getTime()).isEmpty()) continue;
                    try {
                        connector.getProtocolHandler().addSslHostConfig(sSLHostConfig, true);
                        Set set = sSLHostConfig.certificatesExpiringBefore(calendar.getTime());
                        log.info((Object)sm.getString("tlsCertRenewalListener.reloadSuccess", new Object[]{connector, sSLHostConfig.getHostName()}));
                        if (set.isEmpty()) continue;
                        for (X509Certificate x509Certificate : set) {
                            log.warn((Object)sm.getString("tlsCertRenewalListener.notRenewed", new Object[]{connector, sSLHostConfig.getHostName(), x509Certificate.getSubjectX500Principal().getName(), this.dateFormat.format(x509Certificate.getNotAfter())}));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.error((Object)sm.getString("tlsCertRenewalListener.reloadFailed", new Object[]{connector, sSLHostConfig.getHostName()}), (Throwable)illegalArgumentException);
                    }
                }
            }
        }
    }
}

