"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupAuth = void 0;
var layerr_1 = require("layerr");
var digest_1 = require("./digest");
var basic_1 = require("./basic");
var oauth_1 = require("./oauth");
var types_1 = require("../types");
function setupAuth(context, username, password, oauthToken) {
    switch (context.authType) {
        case types_1.AuthType.Digest:
            context.digest = (0, digest_1.createDigestContext)(username, password);
            break;
        case types_1.AuthType.None:
            // Do nothing
            break;
        case types_1.AuthType.Password:
            context.headers.Authorization = (0, basic_1.generateBasicAuthHeader)(username, password);
            break;
        case types_1.AuthType.Token:
            context.headers.Authorization = (0, oauth_1.generateTokenAuthHeader)(oauthToken);
            break;
        default:
            throw new layerr_1.Layerr({
                info: {
                    code: types_1.ErrorCode.InvalidAuthType
                }
            }, "Invalid auth type: ".concat(context.authType));
    }
}
exports.setupAuth = setupAuth;
