/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.StrictErrorHandler;
import io.mola.galimatias.TestURL;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import org.fest.assertions.Assertions;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public class BadURLTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void parseNullURL() throws GalimatiasParseException {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("null input");
        URL.parse(null);
    }

    @Test
    public void parseEmptyURL() throws GalimatiasParseException {
        this.thrown.expect(GalimatiasParseException.class);
        this.thrown.expectMessage("Missing scheme");
        URL.parse("");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseURLwithoutScheme() throws GalimatiasParseException {
        URL.parse("//scheme-relative-stuff");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseOneToken() throws GalimatiasParseException {
        URL.parse("http");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseURLWithBadBase() throws GalimatiasParseException {
        URL.parse(URL.parse("mailto:user@example.com"), "/relative");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseURLWithMalformedScheme() throws GalimatiasParseException {
        URL.parse("+http://example.com");
    }

    @Test
    public void parseURLWithErrors() throws GalimatiasParseException {
        Assertions.assertThat((String)URL.parse("http://example.com\\foo\\bar").toString()).isEqualTo((Object)"http://example.com/foo/bar");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseURLWithErrorsStrict() throws GalimatiasParseException {
        URLParsingSettings settings = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
        Assertions.assertThat((String)URL.parse(settings, "http://example.com\\foo\\bar").toString()).isEqualTo((Object)"http://example.com/foo/bar");
    }

    @Theory
    public void withSchemeInvalidCharacter(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withScheme("http%%");
    }

    @Theory
    public void withSchemeStartingNotAlpha(@TestURL.TestURLs(dataset="/data/urltestdata_whatwg.txt") TestURL testURL) throws GalimatiasParseException {
        Assume.assumeNotNull((Object[])new Object[]{testURL.parsedURL});
        this.thrown.expect(GalimatiasParseException.class);
        testURL.parsedURL.withScheme("1foo");
    }

    @Test
    public void strictTabsInUser() throws GalimatiasParseException {
        Assertions.assertThat((Object)URL.parse("http://a\tb@example.com")).isEqualTo((Object)URL.parse("http://ab@example.com"));
        this.thrown.expect(GalimatiasParseException.class);
        URL.parse(URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance()), "http://a\tb@example.com");
    }

    @Test
    public void strictCarriageInUser() throws GalimatiasParseException {
        Assertions.assertThat((Object)URL.parse("http://a\rb@example.com")).isEqualTo((Object)URL.parse("http://ab@example.com"));
        this.thrown.expect(GalimatiasParseException.class);
        URL.parse(URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance()), "http://a\rb@example.com");
    }

    @Test
    public void strictNewlineInUser() throws GalimatiasParseException {
        Assertions.assertThat((Object)URL.parse("http://a\nb@example.com")).isEqualTo((Object)URL.parse("http://ab@example.com"));
        this.thrown.expect(GalimatiasParseException.class);
        URL.parse(URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance()), "http://a\nb@example.com");
    }

    @Test
    public void strictTabsNewlines() throws GalimatiasParseException {
        URLParsingSettings strictSettings = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
        for (String replacement : new String[]{"\t", "\n", "\r"}) {
            for (String url : new String[]{"http://a%sb@example.com", "http://a%sb:foo@example.com", "http://foo:a%sb@example.com", "http://a%sb.com", "http://ab.com:2%s2", "http://example.com/a%sb", "http://example.com/?a%sb", "http://exaple.com/#a%sb", "file://host%sname/path"}) {
                String urlString = String.format(url, replacement);
                Assertions.assertThat((Object)URL.parse(urlString)).isEqualTo((Object)URL.parse(String.format(url, "")));
                try {
                    URL.parse(strictSettings, urlString);
                    Assertions.assertThat((boolean)false);
                }
                catch (GalimatiasParseException ex) {
                    Assertions.assertThat((boolean)true);
                }
            }
        }
    }

    @Test
    public void strictUnencodedPercentage() throws GalimatiasParseException {
        URLParsingSettings strictSettings = URLParsingSettings.create().withErrorHandler(StrictErrorHandler.getInstance());
        for (String replacement : new String[]{"%%", "%1Z", "%Z1", "%ZZ"}) {
            for (String url : new String[]{"data:%s", "http://%s@example.com", "http://%s:foo@example.com", "http://foo:%s@example.com", "http://example.com/%s", "http://example.com/?%s", "http://exaple.com/#%s"}) {
                String urlString = String.format(url, replacement);
                URL.parse(urlString);
                try {
                    URL.parse(strictSettings, urlString);
                    Assertions.assertThat((boolean)false);
                }
                catch (GalimatiasParseException ex) {
                    Assertions.assertThat((boolean)true);
                }
            }
        }
    }
}

