/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;

public class OpeningHoursParser {
    private static final String[] daysStr;
    private static final String[] localDaysStr;
    private static final String[] monthsStr;
    private static final String[] localMothsStr;
    private static String sunrise;
    private static String sunset;
    private static String endOfDay;

    private static String[] getTwoLettersStringArray(String[] strings) {
        String[] newStrings = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            newStrings[i] = strings[i].length() > 2 ? strings[i].substring(0, 2) : strings[i];
        }
        return newStrings;
    }

    private static int getDayIndex(int i) {
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    public static OpeningHoursRule parseRule(String r) {
        int i;
        char ch;
        int k;
        r = r.toLowerCase();
        String[] daysStr = new String[]{"mo", "tu", "we", "th", "fr", "sa", "su"};
        String[] monthsStr = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        String[] holidayStr = new String[]{"ph", "sh"};
        String sunrise = "07:00";
        String sunset = "21:00";
        String endOfDay = "24:00";
        String localRuleString = r.replaceAll("sunset", sunset).replaceAll("sunrise", sunrise).replaceAll("\\+", "-" + endOfDay);
        int startDay = -1;
        int previousDay = -1;
        int startMonth = -1;
        int previousMonth = -1;
        BasicOpeningHourRule basic = new BasicOpeningHourRule();
        boolean[] days = basic.getDays();
        boolean[] months = basic.getMonths();
        if ("24/7".equals(localRuleString)) {
            Arrays.fill(days, true);
            Arrays.fill(months, true);
            basic.addTimeRange(0, 1440);
            return basic;
        }
        for (k = 0; !(k >= localRuleString.length() || Character.isDigit(ch = localRuleString.charAt(k)) || k + 2 < localRuleString.length() && localRuleString.substring(k, k + 3).equals("off")); ++k) {
            if (Character.isWhitespace(ch) || ch == ',') continue;
            if (ch == '-') {
                if (previousDay != -1) {
                    startDay = previousDay;
                    continue;
                }
                if (previousMonth != -1) {
                    startMonth = previousMonth;
                    continue;
                }
                return new UnparseableRule(r);
            }
            if (k < r.length() - 1) {
                int i2 = 0;
                for (String s : daysStr) {
                    if (s.charAt(0) == ch && s.charAt(1) == r.charAt(k + 1)) break;
                    ++i2;
                }
                if (i2 < daysStr.length) {
                    if (startDay != -1) {
                        int j;
                        for (j = startDay; j <= i2; ++j) {
                            days[j] = true;
                        }
                        if (startDay > i2) {
                            for (j = startDay; j <= 6; ++j) {
                                days[j] = true;
                            }
                            for (j = 0; j <= i2; ++j) {
                                days[j] = true;
                            }
                        }
                        startDay = -1;
                    } else {
                        days[i2] = true;
                    }
                    previousDay = i2;
                    continue;
                }
                int m = 0;
                for (String s : monthsStr) {
                    if (s.charAt(0) == ch && s.charAt(1) == r.charAt(k + 1) && s.charAt(2) == r.charAt(k + 2)) break;
                    ++m;
                }
                if (m < monthsStr.length) {
                    if (startMonth != -1) {
                        int j;
                        for (j = startMonth; j <= m; ++j) {
                            months[j] = true;
                        }
                        if (startMonth > m) {
                            for (j = startMonth; j <= 11; ++j) {
                                months[j] = true;
                            }
                            for (j = 0; j <= m; ++j) {
                                months[j] = true;
                            }
                        }
                        startMonth = -1;
                    } else {
                        months[m] = true;
                    }
                    previousMonth = m;
                }
                if (previousMonth != -1) continue;
                boolean h = false;
                for (String s : holidayStr) {
                    if (s.charAt(0) != ch || s.charAt(1) != r.charAt(k + 1)) continue;
                    return new UnparseableRule(r);
                }
                continue;
            }
            return new UnparseableRule(r);
        }
        if (previousDay == -1) {
            for (i = 0; i < 7; ++i) {
                days[i] = true;
            }
        }
        if (previousMonth == -1) {
            for (i = 0; i < 12; ++i) {
                months[i] = true;
            }
        }
        String timeSubstr = localRuleString.substring(k);
        String[] times = timeSubstr.split(",");
        boolean timesExist = true;
        for (int i3 = 0; i3 < times.length; ++i3) {
            int end;
            int st;
            String time = times[i3];
            if ((time = time.trim()).length() == 0) continue;
            if (time.equals("off")) break;
            if (time.equals("24/7")) {
                basic.addTimeRange(0, 1440);
                break;
            }
            String[] stEnd = time.split("-");
            if (stEnd.length != 2) {
                if (i3 != times.length - 1 || basic.getStartTime() != 0 || basic.getEndTime() != 0) continue;
                return new UnparseableRule(r);
            }
            timesExist = true;
            try {
                int endMin;
                int endHour;
                int startMin;
                int startHour;
                int i1 = stEnd[0].indexOf(58);
                int i2 = stEnd[1].indexOf(58);
                if (i1 == -1) {
                    startHour = Integer.parseInt(stEnd[0].trim());
                    startMin = 0;
                } else {
                    startHour = Integer.parseInt(stEnd[0].substring(0, i1).trim());
                    startMin = Integer.parseInt(stEnd[0].substring(i1 + 1).trim());
                }
                if (i2 == -1) {
                    endHour = Integer.parseInt(stEnd[1].trim());
                    endMin = 0;
                } else {
                    endHour = Integer.parseInt(stEnd[1].substring(0, i2).trim());
                    endMin = Integer.parseInt(stEnd[1].substring(i2 + 1).trim());
                }
                st = startHour * 60 + startMin;
                end = endHour * 60 + endMin;
            }
            catch (NumberFormatException e) {
                return new UnparseableRule(r);
            }
            basic.addTimeRange(st, end);
        }
        if (!timesExist) {
            return new UnparseableRule(r);
        }
        return basic;
    }

    public static OpeningHours parseOpenedHours(String format) {
        if (format == null) {
            return null;
        }
        String[] rules = format.split(";");
        OpeningHours rs = new OpeningHours();
        for (String r : rules) {
            OpeningHoursRule r1;
            boolean rule;
            if ((r = r.trim()).length() == 0 || !(rule = (r1 = OpeningHoursParser.parseRule(r)) instanceof BasicOpeningHourRule)) continue;
            rs.addRule(r1);
        }
        return rs;
    }

    public static OpeningHours parseOpenedHoursHandleErrors(String format) {
        if (format == null) {
            return null;
        }
        String[] rules = format.split(";");
        OpeningHours rs = new OpeningHours();
        for (String r : rules) {
            if ((r = r.trim()).length() == 0) continue;
            rs.addRule(OpeningHoursParser.parseRule(r));
        }
        return rs;
    }

    private static void formatTime(int h, int t, StringBuilder b) {
        if (h < 10) {
            b.append("0");
        }
        b.append(h).append(":");
        if (t < 10) {
            b.append("0");
        }
        b.append(t);
    }

    private static void testOpened(String time, OpeningHours hours, boolean expected) throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new SimpleDateFormat("dd.MM.yyyy HH:mm", Locale.US).parse(time));
        boolean calculated = hours.isOpenedForTime(cal);
        System.out.printf("  %sok: Expected %s: %b = %b (rule %s)\n", calculated != expected ? "NOT " : "", time, expected, calculated, hours.getCurrentRuleTime(cal));
        if (calculated != expected) {
            throw new IllegalArgumentException("BUG!!!");
        }
    }

    private static void testParsedAndAssembledCorrectly(String timeString, OpeningHours hours) {
        String assembledString = hours.toStringNoMonths();
        boolean isCorrect = assembledString.equalsIgnoreCase(timeString);
        System.out.printf("  %sok: Expected: \"%s\" got: \"%s\"\n", isCorrect ? "NOT " : "", timeString, assembledString);
        if (!isCorrect) {
            throw new IllegalArgumentException("BUG!!!");
        }
    }

    public static void main(String[] args) throws ParseException {
        OpeningHours hours = OpeningHoursParser.parseOpenedHours("Mo-Fr 08:30-14:40");
        System.out.println(hours);
        OpeningHoursParser.testOpened("09.08.2012 11:00", hours, true);
        OpeningHoursParser.testOpened("09.08.2012 16:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("mo-fr 07:00-19:00; sa 12:00-18:00");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Fr 11:30-15:00,17:30-23:00; Sa-Su,PH 11:30-23:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("7.09.2015 14:54", hours, true);
        OpeningHoursParser.testOpened("7.09.2015 15:05", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Mo-We, Fr 08:30-14:40,15:00-19:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("08.08.2012 14:00", hours, true);
        OpeningHoursParser.testOpened("08.08.2012 14:50", hours, false);
        OpeningHoursParser.testOpened("10.08.2012 15:00", hours, true);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Sa 08:30-14:40; Tu 08:00 - 14:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("07.08.2012 14:20", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Sa 09:00-18:25; Th off");
        System.out.println(hours);
        OpeningHoursParser.testOpened("08.08.2012 12:00", hours, true);
        OpeningHoursParser.testOpened("09.08.2012 12:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("24/7");
        System.out.println(hours);
        OpeningHoursParser.testOpened("08.08.2012 23:59", hours, true);
        OpeningHoursParser.testOpened("08.08.2012 12:23", hours, true);
        OpeningHoursParser.testOpened("08.08.2012 06:23", hours, true);
        hours = OpeningHoursParser.parseOpenedHours("Sa-Su 24/7");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Fr 9-19");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("09:00-17:00");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("sunrise-sunset");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("10:00+");
        System.out.println(hours);
        hours = OpeningHoursParser.parseOpenedHours("Su-Th sunset-24:00, 04:00-sunrise; Fr-Sa sunset-sunrise");
        System.out.println(hours);
        OpeningHoursParser.testOpened("12.08.2012 04:00", hours, true);
        OpeningHoursParser.testOpened("12.08.2012 23:00", hours, true);
        OpeningHoursParser.testOpened("08.08.2012 12:00", hours, false);
        OpeningHoursParser.testOpened("08.08.2012 05:00", hours, true);
        hours = OpeningHoursParser.parseOpenedHours("Mo 20:00-02:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("05.05.2013 10:30", hours, false);
        OpeningHoursParser.testOpened("05.05.2013 23:59", hours, false);
        OpeningHoursParser.testOpened("06.05.2013 10:30", hours, false);
        OpeningHoursParser.testOpened("06.05.2013 20:30", hours, true);
        OpeningHoursParser.testOpened("06.05.2013 23:59", hours, true);
        OpeningHoursParser.testOpened("07.05.2013 00:00", hours, true);
        OpeningHoursParser.testOpened("07.05.2013 00:30", hours, true);
        OpeningHoursParser.testOpened("07.05.2013 01:59", hours, true);
        OpeningHoursParser.testOpened("07.05.2013 20:30", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Su 10:00-10:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("05.05.2013 09:59", hours, false);
        OpeningHoursParser.testOpened("05.05.2013 10:00", hours, true);
        OpeningHoursParser.testOpened("05.05.2013 23:59", hours, true);
        OpeningHoursParser.testOpened("06.05.2013 00:00", hours, true);
        OpeningHoursParser.testOpened("06.05.2013 09:59", hours, true);
        OpeningHoursParser.testOpened("06.05.2013 10:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Tu-Th 07:00-2:00; Fr 17:00-4:00; Sa 18:00-05:00; Su,Mo off");
        System.out.println(hours);
        OpeningHoursParser.testOpened("05.05.2013 04:59", hours, true);
        OpeningHoursParser.testOpened("05.05.2013 05:00", hours, false);
        OpeningHoursParser.testOpened("05.05.2013 12:30", hours, false);
        OpeningHoursParser.testOpened("06.05.2013 10:30", hours, false);
        OpeningHoursParser.testOpened("07.05.2013 01:00", hours, false);
        OpeningHoursParser.testOpened("07.05.2013 20:25", hours, true);
        OpeningHoursParser.testOpened("07.05.2013 23:59", hours, true);
        OpeningHoursParser.testOpened("08.05.2013 00:00", hours, true);
        OpeningHoursParser.testOpened("08.05.2013 02:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Th 09:00-03:00; Fr-Sa 09:00-04:00; Su off");
        OpeningHoursParser.testOpened("11.05.2015 08:59", hours, false);
        OpeningHoursParser.testOpened("11.05.2015 09:01", hours, true);
        OpeningHoursParser.testOpened("12.05.2015 02:59", hours, true);
        OpeningHoursParser.testOpened("12.05.2015 03:00", hours, false);
        OpeningHoursParser.testOpened("16.05.2015 03:59", hours, true);
        OpeningHoursParser.testOpened("16.05.2015 04:01", hours, false);
        OpeningHoursParser.testOpened("17.05.2015 01:00", hours, true);
        OpeningHoursParser.testOpened("17.05.2015 04:01", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Tu-Th 07:00-2:00; Fr 17:00-4:00; Sa 18:00-05:00; Su,Mo off");
        OpeningHoursParser.testOpened("11.05.2015 08:59", hours, false);
        OpeningHoursParser.testOpened("11.05.2015 09:01", hours, false);
        OpeningHoursParser.testOpened("12.05.2015 02:59", hours, false);
        OpeningHoursParser.testOpened("12.05.2015 03:00", hours, false);
        OpeningHoursParser.testOpened("16.05.2015 03:59", hours, true);
        OpeningHoursParser.testOpened("16.05.2015 04:01", hours, false);
        OpeningHoursParser.testOpened("17.05.2015 01:00", hours, true);
        OpeningHoursParser.testOpened("17.05.2015 05:01", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("May: 07:00-19:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("05.05.2013 12:00", hours, true);
        OpeningHoursParser.testOpened("05.05.2013 05:00", hours, false);
        OpeningHoursParser.testOpened("05.05.2013 21:00", hours, false);
        OpeningHoursParser.testOpened("05.01.2013 12:00", hours, false);
        OpeningHoursParser.testOpened("05.01.2013 05:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Apr-Sep: 8:00-22:00; Oct-Mar: 10:00-18:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("05.03.2013 15:00", hours, true);
        OpeningHoursParser.testOpened("05.03.2013 20:00", hours, false);
        OpeningHoursParser.testOpened("05.05.2013 20:00", hours, true);
        OpeningHoursParser.testOpened("05.05.2013 23:00", hours, false);
        OpeningHoursParser.testOpened("05.10.2013 15:00", hours, true);
        OpeningHoursParser.testOpened("05.10.2013 20:00", hours, false);
        hours = OpeningHoursParser.parseOpenedHours("Mo-Fr: 9:00-13:00, 14:00-18:00");
        System.out.println(hours);
        OpeningHoursParser.testOpened("02.12.2015 12:00", hours, true);
        OpeningHoursParser.testOpened("02.12.2015 13:30", hours, false);
        OpeningHoursParser.testOpened("02.12.2015 16:00", hours, true);
        OpeningHoursParser.testOpened("05.12.2015 16:00", hours, false);
        String hoursString = "mo-fr 11:00-21:00; ph off";
        hours = OpeningHoursParser.parseOpenedHoursHandleErrors(hoursString);
        OpeningHoursParser.testParsedAndAssembledCorrectly(hoursString, hours);
    }

    static {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(Locale.US);
        monthsStr = dateFormatSymbols.getShortMonths();
        daysStr = OpeningHoursParser.getTwoLettersStringArray(dateFormatSymbols.getShortWeekdays());
        dateFormatSymbols = DateFormatSymbols.getInstance();
        localMothsStr = dateFormatSymbols.getShortMonths();
        localDaysStr = OpeningHoursParser.getTwoLettersStringArray(dateFormatSymbols.getShortWeekdays());
        sunrise = "07:00";
        sunset = "21:00";
        endOfDay = "24:00";
    }

    public static class UnparseableRule
    implements OpeningHoursRule {
        private String ruleString;

        public UnparseableRule(String ruleString) {
            this.ruleString = ruleString;
        }

        @Override
        public boolean isOpenedForTime(Calendar cal, boolean checkPrevious) {
            return false;
        }

        @Override
        public boolean containsPreviousDay(Calendar cal) {
            return false;
        }

        @Override
        public boolean containsDay(Calendar cal) {
            return false;
        }

        @Override
        public boolean containsMonth(Calendar cal) {
            return false;
        }

        @Override
        public String toRuleString(boolean avoidMonths) {
            return this.ruleString;
        }

        @Override
        public String toLocalRuleString() {
            return this.toRuleString(false);
        }

        public String toString() {
            return this.toRuleString(false);
        }
    }

    public static class BasicOpeningHourRule
    implements OpeningHoursRule {
        private boolean[] days = new boolean[7];
        private boolean[] months = new boolean[12];
        private TIntArrayList startTimes = new TIntArrayList();
        private TIntArrayList endTimes = new TIntArrayList();

        public boolean[] getDays() {
            return this.days;
        }

        public boolean[] getMonths() {
            return this.months;
        }

        public void setStartTime(int s) {
            BasicOpeningHourRule.setSingleValueForArrayList(this.startTimes, s);
            if (this.endTimes.size() != 1) {
                BasicOpeningHourRule.setSingleValueForArrayList(this.endTimes, 0);
            }
        }

        public void setEndTime(int e) {
            BasicOpeningHourRule.setSingleValueForArrayList(this.endTimes, e);
            if (this.startTimes.size() != 1) {
                BasicOpeningHourRule.setSingleValueForArrayList(this.startTimes, 0);
            }
        }

        public void setStartTime(int s, int position) {
            if (position == this.startTimes.size()) {
                this.startTimes.add(s);
                this.endTimes.add(0);
            } else {
                this.startTimes.set(position, s);
            }
        }

        public void setEndTime(int s, int position) {
            if (position == this.startTimes.size()) {
                this.endTimes.add(s);
                this.startTimes.add(0);
            } else {
                this.endTimes.set(position, s);
            }
        }

        public int getStartTime() {
            if (this.startTimes.size() == 0) {
                return 0;
            }
            return this.startTimes.get(0);
        }

        public int getStartTime(int position) {
            return this.startTimes.get(position);
        }

        public int getEndTime() {
            if (this.endTimes.size() == 0) {
                return 0;
            }
            return this.endTimes.get(0);
        }

        public int getEndTime(int position) {
            return this.endTimes.get(position);
        }

        public TIntArrayList getStartTimes() {
            return new TIntArrayList((TIntCollection)this.startTimes);
        }

        public TIntArrayList getEndTimes() {
            return new TIntArrayList((TIntCollection)this.endTimes);
        }

        @Override
        public boolean containsDay(Calendar cal) {
            int i = cal.get(7);
            int d = (i + 5) % 7;
            return this.days[d];
        }

        @Override
        public boolean containsPreviousDay(Calendar cal) {
            int i = cal.get(7);
            int p = (i + 4) % 7;
            return this.days[p];
        }

        @Override
        public boolean containsMonth(Calendar cal) {
            int i = cal.get(2);
            return this.months[i];
        }

        @Override
        public boolean isOpenedForTime(Calendar cal, boolean checkPrevious) {
            int i = cal.get(7);
            int d = (i + 5) % 7;
            int p = d - 1;
            if (p < 0) {
                p += 7;
            }
            int time = cal.get(11) * 60 + cal.get(12);
            for (i = 0; i < this.startTimes.size(); ++i) {
                int endTime;
                int startTime = this.startTimes.get(i);
                if (startTime < (endTime = this.endTimes.get(i)) || endTime == -1) {
                    if (!this.days[d] || checkPrevious || time < startTime || endTime != -1 && time > endTime) continue;
                    return true;
                }
                if (time >= startTime && this.days[d] && !checkPrevious) {
                    return true;
                }
                if (time >= endTime || !this.days[p] || !checkPrevious) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toRuleString(boolean avoidMonths) {
            return this.toRuleString(avoidMonths, daysStr, monthsStr);
        }

        private String toRuleString(boolean avoidMonths, String[] dayNames, String[] monthNames) {
            int i;
            StringBuilder b = new StringBuilder(25);
            boolean dash = false;
            boolean first = true;
            if (!avoidMonths) {
                for (int i2 = 0; i2 < 12; ++i2) {
                    if (!this.months[i2]) continue;
                    if (i2 > 0 && this.months[i2 - 1] && i2 < 11 && this.months[i2 + 1]) {
                        if (dash) continue;
                        dash = true;
                        b.append("-");
                        continue;
                    }
                    if (first) {
                        first = false;
                    } else if (!dash) {
                        b.append(", ");
                    }
                    b.append(monthNames[i2]);
                    dash = false;
                }
                if (b.length() != 0) {
                    b.append(": ");
                }
            }
            boolean open24_7 = true;
            for (i = 0; i < 7; ++i) {
                if (this.days[i]) continue;
                open24_7 = false;
                break;
            }
            this.appendDaysString(b, dayNames);
            if (this.startTimes == null || this.startTimes.size() == 0) {
                b.append(" off ");
            } else {
                for (i = 0; i < this.startTimes.size(); ++i) {
                    int startTime = this.startTimes.get(i);
                    int endTime = this.endTimes.get(i);
                    if (open24_7 && startTime == 0 && endTime / 60 == 24) {
                        return "24/7";
                    }
                    b.append(" ");
                    int stHour = startTime / 60;
                    int stTime = startTime - stHour * 60;
                    int enHour = endTime / 60;
                    int enTime = endTime - enHour * 60;
                    OpeningHoursParser.formatTime(stHour, stTime, b);
                    b.append("-");
                    OpeningHoursParser.formatTime(enHour, enTime, b);
                    b.append(",");
                }
            }
            return b.substring(0, b.length() - 1);
        }

        @Override
        public String toLocalRuleString() {
            return this.toRuleString(true, localDaysStr, localMothsStr);
        }

        public String toString() {
            return this.toRuleString(false);
        }

        public void appendDaysString(StringBuilder builder) {
            this.appendDaysString(builder, daysStr);
        }

        public void appendDaysString(StringBuilder builder, String[] daysNames) {
            boolean dash = false;
            boolean first = true;
            for (int i = 0; i < 7; ++i) {
                if (!this.days[i]) continue;
                if (i > 0 && this.days[i - 1] && i < 6 && this.days[i + 1]) {
                    if (dash) continue;
                    dash = true;
                    builder.append("-");
                    continue;
                }
                if (first) {
                    first = false;
                } else if (!dash) {
                    builder.append(", ");
                }
                builder.append(daysNames[OpeningHoursParser.getDayIndex(i)]);
                dash = false;
            }
        }

        public void addTimeRange(int startTime, int endTime) {
            this.startTimes.add(startTime);
            this.endTimes.add(endTime);
        }

        public int timesSize() {
            return this.startTimes.size();
        }

        public void deleteTimeRange(int position) {
            this.startTimes.removeAt(position);
            this.endTimes.removeAt(position);
        }

        private static void setSingleValueForArrayList(TIntArrayList arrayList, int s) {
            if (arrayList.size() > 0) {
                arrayList.remove(0, arrayList.size());
            }
            arrayList.add(s);
        }
    }

    public static interface OpeningHoursRule
    extends Serializable {
        public boolean isOpenedForTime(Calendar var1, boolean var2);

        public boolean containsPreviousDay(Calendar var1);

        public boolean containsDay(Calendar var1);

        public boolean containsMonth(Calendar var1);

        public String toRuleString(boolean var1);

        public String toLocalRuleString();
    }

    public static class OpeningHours
    implements Serializable {
        private ArrayList<OpeningHoursRule> rules;

        public OpeningHours(ArrayList<OpeningHoursRule> rules) {
            this.rules = rules;
        }

        public OpeningHours() {
            this.rules = new ArrayList();
        }

        public void addRule(OpeningHoursRule r) {
            this.rules.add(r);
        }

        public ArrayList<OpeningHoursRule> getRules() {
            return this.rules;
        }

        public boolean isOpenedForTime(Calendar cal) {
            boolean isOpenDay = false;
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsDay(cal) || !r.containsMonth(cal)) continue;
                isOpenDay = r.isOpenedForTime(cal, false);
            }
            boolean isOpenPrevious = false;
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsPreviousDay(cal) || !r.containsMonth(cal)) continue;
                isOpenPrevious = r.isOpenedForTime(cal, true);
            }
            return isOpenDay || isOpenPrevious;
        }

        public String getCurrentRuleTime(Calendar cal) {
            String ruleOpen = null;
            String ruleClosed = null;
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsPreviousDay(cal) || !r.containsMonth(cal)) continue;
                if (r.isOpenedForTime(cal, true)) {
                    ruleOpen = r.toRuleString(true);
                    continue;
                }
                ruleClosed = r.toRuleString(true);
            }
            for (OpeningHoursRule r : this.rules) {
                if (!r.containsDay(cal) || !r.containsMonth(cal)) continue;
                if (r.isOpenedForTime(cal, false)) {
                    ruleOpen = r.toRuleString(true);
                    continue;
                }
                ruleClosed = r.toRuleString(true);
            }
            if (ruleOpen != null) {
                return ruleOpen;
            }
            return ruleClosed;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.rules.isEmpty()) {
                return "";
            }
            for (OpeningHoursRule r : this.rules) {
                s.append(r.toString()).append("; ");
            }
            return s.substring(0, s.length() - 2);
        }

        public String toStringNoMonths() {
            StringBuilder s = new StringBuilder();
            if (this.rules.isEmpty()) {
                return "";
            }
            for (OpeningHoursRule r : this.rules) {
                s.append(r.toRuleString(true)).append("; ");
            }
            return s.substring(0, s.length() - 2);
        }

        public String toLocalStringNoMonths() {
            StringBuilder s = new StringBuilder();
            if (this.rules.isEmpty()) {
                return "";
            }
            for (OpeningHoursRule r : this.rules) {
                s.append(r.toLocalRuleString()).append("; ");
            }
            return s.substring(0, s.length() - 2);
        }
    }
}

