/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.VirtualUniverse;

class VertexArrayRenderMethod
implements RenderMethod {
    VertexArrayRenderMethod() {
    }

    public boolean render(RenderMolecule renderMolecule, Canvas3D canvas3D, RenderAtomListInfo renderAtomListInfo, int n) {
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
        geometryArrayRetained.setVertexFormat(renderMolecule.useAlpha && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.textureBin.attributeBin.ignoreVertexColors, canvas3D.ctx);
        if (renderMolecule.doInfinite) {
            canvas3D.updateState(n);
            while (renderAtomListInfo != null) {
                this.renderGeo(renderAtomListInfo, renderMolecule, canvas3D);
                renderAtomListInfo = renderAtomListInfo.next;
            }
            return true;
        }
        boolean bl = false;
        while (renderAtomListInfo != null) {
            if (canvas3D.ra == renderAtomListInfo.renderAtom) {
                if (canvas3D.raIsVisible) {
                    canvas3D.updateState(n);
                    this.renderGeo(renderAtomListInfo, renderMolecule, canvas3D);
                    bl = true;
                }
            } else {
                if (!VirtualUniverse.mc.viewFrustumCulling || renderAtomListInfo.renderAtom.localeVwcBounds.intersect(canvas3D.viewFrustum)) {
                    canvas3D.updateState(n);
                    canvas3D.raIsVisible = true;
                    this.renderGeo(renderAtomListInfo, renderMolecule, canvas3D);
                    bl = true;
                } else {
                    canvas3D.raIsVisible = false;
                }
                canvas3D.ra = renderAtomListInfo.renderAtom;
            }
            renderAtomListInfo = renderAtomListInfo.next;
        }
        geometryArrayRetained.disableGlobalAlpha(canvas3D.ctx, renderMolecule.useAlpha && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.textureBin.attributeBin.ignoreVertexColors);
        return bl;
    }

    void renderGeo(RenderAtomListInfo renderAtomListInfo, RenderMolecule renderMolecule, Canvas3D canvas3D) {
        boolean bl = renderMolecule.useAlpha;
        GeometryArrayRetained geometryArrayRetained = (GeometryArrayRetained)renderAtomListInfo.geometry();
        geometryArrayRetained.execute(canvas3D, renderAtomListInfo.renderAtom, renderMolecule.isNonUniformScale, bl && (geometryArrayRetained.vertexFormat & 4) != 0, renderMolecule.alpha, canvas3D.screen.screen, renderMolecule.textureBin.attributeBin.ignoreVertexColors);
    }
}

