/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.explorer;

import java.awt.BorderLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.explorer.ExplorerComponent;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ExplorerTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "ExplorerTopComponent";
    private static final Logger LOGGER = Logger.getLogger(ExplorerTopComponent.class.getName());
    static final String ICON_PATH = "org/graalvm/visualvm/core/ui/resources/explorer.png";
    private static ExplorerTopComponent instance;

    private ExplorerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ExplorerTopComponent.class, (String)"LBL_Applications"));
        this.setToolTipText(NbBundle.getMessage(ExplorerTopComponent.class, (String)"LBL_Applications"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ExplorerComponent.instance().requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add(ExplorerComponent.instance(), "Center");
    }

    public static synchronized ExplorerTopComponent getInstance() {
        if (instance == null) {
            instance = new ExplorerTopComponent();
        }
        return instance;
    }

    public static synchronized ExplorerTopComponent findInstance() {
        TopComponent explorerTopComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (explorerTopComponent == null) {
            return ExplorerTopComponent.getInstance();
        }
        if (explorerTopComponent instanceof ExplorerTopComponent) {
            return (ExplorerTopComponent)explorerTopComponent;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("There seem to be multiple components with the 'ExplorerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        }
        return ExplorerTopComponent.getInstance();
    }

    private boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode("explorer")) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }
}

