/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.eclipse.sisu.space.FileEntryIterator;
import org.eclipse.sisu.space.GlobberStrategy;
import org.eclipse.sisu.space.Streams;
import org.eclipse.sisu.space.ZipEntryIterator;

final class ResourceEnumeration
implements Enumeration<URL> {
    private static final Iterator<String> NO_ENTRIES = Collections.emptySet().iterator();
    private final URL[] urls;
    private final String subPath;
    private final GlobberStrategy globber;
    private final Object globPattern;
    private final boolean recurse;
    private int index;
    private URL currentURL;
    private boolean isFolder;
    private Iterator<String> entryNames = NO_ENTRIES;
    private String nextEntryName;

    ResourceEnumeration(String subPath, String glob, boolean recurse, URL[] urls) {
        this.subPath = ResourceEnumeration.normalizeSearchPath(subPath);
        this.globber = GlobberStrategy.selectFor(glob);
        this.globPattern = this.globber.compile(glob);
        this.recurse = recurse;
        this.urls = urls;
    }

    @Override
    public boolean hasMoreElements() {
        while (this.nextEntryName == null) {
            if (this.entryNames.hasNext()) {
                String name2 = this.entryNames.next();
                if (!this.matchesRequest(name2)) continue;
                this.nextEntryName = name2;
                continue;
            }
            if (this.index < this.urls.length) {
                this.currentURL = this.urls[this.index++];
                this.entryNames = this.scan(this.currentURL);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public URL nextElement() {
        if (this.hasMoreElements()) {
            String name2 = this.nextEntryName;
            this.nextEntryName = null;
            try {
                return this.findResource(name2);
            }
            catch (MalformedURLException e2) {
                throw new IllegalStateException(e2.toString());
            }
        }
        throw new NoSuchElementException();
    }

    static String normalizeSearchPath(String path2) {
        if (path2 == null || "/".equals(path2)) {
            return "";
        }
        boolean echoSlash = false;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int length = path2.length();
        while (i < length) {
            boolean isNotSlash;
            char c = path2.charAt(i);
            boolean bl = isNotSlash = '/' != c;
            if (echoSlash || isNotSlash) {
                echoSlash = isNotSlash;
                buf.append(c);
            }
            ++i;
        }
        if (echoSlash) {
            buf.append('/');
        }
        return buf.toString();
    }

    private Iterator<String> scan(URL url) {
        this.isFolder = url.getPath().endsWith("/");
        if (this.globber == GlobberStrategy.EXACT && !this.recurse) {
            try {
                this.nextEntryName = String.valueOf(this.subPath) + this.globPattern;
                Streams.open(this.findResource(this.nextEntryName)).close();
            }
            catch (Exception exception) {
                this.nextEntryName = null;
            }
            return NO_ENTRIES;
        }
        return this.isFolder ? new FileEntryIterator(url, this.subPath, this.recurse) : new ZipEntryIterator(url);
    }

    private URL findResource(String name2) throws MalformedURLException {
        if (this.isFolder) {
            return new URL(this.currentURL, name2);
        }
        if ("jar".equals(this.currentURL.getProtocol())) {
            return new URL(this.currentURL, "#" + name2, new NestedJarHandler());
        }
        return new URL("jar:" + this.currentURL + "!/" + name2);
    }

    private boolean matchesRequest(String entryName) {
        if (entryName.endsWith("/") || !entryName.startsWith(this.subPath)) {
            return false;
        }
        if (!this.recurse && entryName.indexOf(47, this.subPath.length()) > 0) {
            return false;
        }
        return this.globber.matches(this.globPattern, entryName);
    }

    static final class NestedJarConnection
    extends URLConnection {
        NestedJarConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            URL containingURL = new URL("jar", null, -1, this.url.getFile());
            ZipInputStream is2 = new ZipInputStream(Streams.open(containingURL));
            String entryName = this.url.getRef();
            ZipEntry entry = is2.getNextEntry();
            while (entry != null) {
                if (entryName.equals(entry.getName())) {
                    return is2;
                }
                entry = is2.getNextEntry();
            }
            throw new ZipException("No such entry: " + entryName + " in: " + containingURL);
        }
    }

    static final class NestedJarHandler
    extends URLStreamHandler {
        NestedJarHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new NestedJarConnection(url);
        }
    }
}

