/* gvnc-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Vnc", gir_namespace = "GVnc", gir_version = "1.0", lower_case_cprefix = "vnc_")]
namespace Vnc {
	[CCode (cheader_filename = "gvnc.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "vnc_audio_format_get_type ()")]
	[Compact]
	public class AudioFormat {
		public uint8 format;
		public uint32 frequency;
		public uint8 nchannels;
		[CCode (has_construct_function = false)]
		public AudioFormat ();
		public Vnc.AudioFormat copy ();
		public void free ();
	}
	[CCode (cheader_filename = "gvnc.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "vnc_audio_sample_get_type ()")]
	[Compact]
	public class AudioSample {
		public uint32 capacity;
		public uint8 data;
		public uint32 length;
		[CCode (has_construct_function = false)]
		public AudioSample (uint32 capacity);
		public Vnc.AudioSample copy ();
		public void free ();
	}
	[CCode (cheader_filename = "gvnc.h", type_id = "vnc_base_audio_get_type ()")]
	public class BaseAudio : GLib.Object, Vnc.Audio {
		[CCode (has_construct_function = false)]
		public BaseAudio ();
		[NoWrapper]
		public virtual bool playback_data (Vnc.AudioSample sample);
		[NoWrapper]
		public virtual bool playback_start (Vnc.AudioFormat format);
		[NoWrapper]
		public virtual bool playback_stop ();
		public signal void vnc_audio_playback_data (Vnc.AudioSample object);
		public signal void vnc_audio_playback_start (Vnc.AudioFormat object);
		public signal void vnc_audio_playback_stop ();
	}
	[CCode (cheader_filename = "gvnc.h", type_id = "vnc_base_framebuffer_get_type ()")]
	public class BaseFramebuffer : GLib.Object, Vnc.Framebuffer {
		[CCode (has_construct_function = false)]
		public BaseFramebuffer ([CCode (array_length = false)] uint8[] buffer, uint16 width, uint16 height, int rowstride, Vnc.PixelFormat localFormat, Vnc.PixelFormat remoteFormat);
		[NoAccessorMethod]
		public void* buffer { get; construct; }
		[NoAccessorMethod]
		public Vnc.ColorMap color_map { owned get; set; }
		[NoAccessorMethod]
		public int height { get; construct; }
		[NoAccessorMethod]
		public Vnc.PixelFormat local_format { owned get; construct; }
		[NoAccessorMethod]
		public Vnc.PixelFormat remote_format { owned get; construct; }
		[NoAccessorMethod]
		public int rowstride { get; construct; }
		[NoAccessorMethod]
		public int width { get; construct; }
	}
	[CCode (cheader_filename = "gvnc.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "vnc_color_map_get_type ()")]
	[Compact]
	public class ColorMap {
		public Vnc.ColorMapEntry colors;
		public uint16 offset;
		public uint16 size;
		[CCode (has_construct_function = false)]
		public ColorMap (uint16 offset, uint16 size);
		public Vnc.ColorMap copy ();
		public void free ();
		public bool lookup (uint16 idx, out uint16 red, out uint16 green, out uint16 blue);
		public bool @set (uint16 idx, uint16 red, uint16 green, uint16 blue);
	}
	[CCode (cheader_filename = "gvnc.h", type_id = "vnc_connection_get_type ()")]
	public class Connection : GLib.Object {
		[CCode (has_construct_function = false)]
		public Connection ();
		public bool audio_disable ();
		public bool audio_enable ();
		public bool client_cut_text (void* data, size_t length);
		public bool framebuffer_update_request (bool incremental, uint16 x, uint16 y, uint16 width, uint16 height);
		public bool get_abs_pointer ();
		public unowned Vnc.AudioFormat get_audio_format ();
		public unowned Vnc.Cursor get_cursor ();
		public bool get_ext_key_event ();
		public int get_height ();
		public int get_ledstate ();
		public unowned string get_name ();
		public unowned Vnc.PixelFormat get_pixel_format ();
		public bool get_power_control ();
		public bool get_shared ();
		public int get_width ();
		public bool has_error ();
		public bool is_initialized ();
		public bool is_open ();
		public bool key_event (bool down_flag, uint32 key, uint16 scancode);
		public bool open_addr (GLib.SocketAddress addr, string? hostname);
		public bool open_fd (int fd);
		public bool open_fd_with_hostname (int fd, string? hostname);
		public bool open_host (string host, string port);
		public bool pointer_event (uint8 button_mask, uint16 x, uint16 y);
		public bool power_control (Vnc.ConnectionPowerAction action);
		public bool set_audio (Vnc.Audio audio);
		public bool set_audio_format (Vnc.AudioFormat fmt);
		public bool set_auth_subtype (uint type);
		public bool set_auth_type (uint type);
		public bool set_credential (int type, string data);
		public bool set_encodings ([CCode (array_length_cname = "n_encoding", array_length_pos = 0.5)] int32[] encoding);
		public bool set_framebuffer (Vnc.Framebuffer fb);
		public bool set_pixel_format (Vnc.PixelFormat fmt);
		public bool set_shared (bool shared);
		public Vnc.ConnectionResizeStatus set_size (uint width, uint height);
		public void shutdown ();
		[NoAccessorMethod]
		public Vnc.Framebuffer framebuffer { owned get; set; }
		public virtual signal void vnc_auth_choose_subtype (uint type, GLib.ValueArray subtypes);
		public virtual signal void vnc_auth_choose_type (GLib.ValueArray types);
		public virtual signal void vnc_auth_credential (GLib.ValueArray creds);
		public virtual signal void vnc_auth_failure (string reason);
		public virtual signal void vnc_auth_unsupported (uint authType);
		public virtual signal void vnc_bell ();
		public virtual signal void vnc_connected ();
		public virtual signal void vnc_cursor_changed (Vnc.Cursor? cursor);
		public virtual signal void vnc_desktop_rename (string name);
		public virtual signal void vnc_desktop_resize (int width, int height);
		public virtual signal void vnc_disconnected ();
		public virtual signal void vnc_error (string message);
		public virtual signal void vnc_framebuffer_update (int x, int y, int width, int height);
		public virtual signal void vnc_initialized ();
		public virtual signal void vnc_led_state ();
		public virtual signal void vnc_pixel_format_changed (Vnc.PixelFormat format);
		public virtual signal void vnc_pointer_mode_changed (bool absPointer);
		public virtual signal void vnc_power_control_failed ();
		public virtual signal void vnc_power_control_initialized ();
		public virtual signal void vnc_server_cut_text (string text);
	}
	[CCode (cheader_filename = "gvnc.h", type_id = "vnc_cursor_get_type ()")]
	public class Cursor : GLib.Object {
		[CCode (has_construct_function = false)]
		public Cursor ([CCode (array_length = false)] uint8[] data, uint16 hotx, uint16 hoty, uint16 width, uint16 height);
		[CCode (array_length = false)]
		public unowned uint8[] get_data ();
		public uint16 get_height ();
		public uint16 get_hotx ();
		public uint16 get_hoty ();
		public uint16 get_width ();
		[NoAccessorMethod]
		public void* data { get; set construct; }
		[NoAccessorMethod]
		public int height { get; set construct; }
		[NoAccessorMethod]
		public int hotx { get; set construct; }
		[NoAccessorMethod]
		public int hoty { get; set construct; }
		[NoAccessorMethod]
		public int width { get; set construct; }
	}
	[CCode (cheader_filename = "gvnc.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "vnc_pixel_format_get_type ()")]
	[Compact]
	public class PixelFormat {
		public uint8 bits_per_pixel;
		public uint16 blue_max;
		public uint8 blue_shift;
		public uint16 byte_order;
		public uint8 depth;
		public uint16 green_max;
		public uint8 green_shift;
		public uint16 red_max;
		public uint8 red_shift;
		public uint8 true_color_flag;
		[CCode (has_construct_function = false)]
		public PixelFormat ();
		public Vnc.PixelFormat copy ();
		public void free ();
		public bool match (Vnc.PixelFormat other);
	}
	[CCode (cheader_filename = "gvnc.h", type_cname = "VncAudioInterface", type_id = "vnc_audio_get_type ()")]
	public interface Audio : GLib.Object {
		[NoWrapper]
		public abstract bool playback_data (Vnc.AudioSample sample);
		[NoWrapper]
		public abstract bool playback_start (Vnc.AudioFormat format);
		[NoWrapper]
		public abstract bool playback_stop ();
	}
	[CCode (cheader_filename = "gvnc.h", type_cname = "VncFramebufferInterface", type_id = "vnc_framebuffer_get_type ()")]
	public interface Framebuffer : GLib.Object {
		public abstract void blt (uint8 src, int rowstride, uint16 x, uint16 y, uint16 width, uint16 height);
		public abstract void copyrect (uint16 srcx, uint16 srcy, uint16 dstx, uint16 dsty, uint16 width, uint16 height);
		public abstract void fill ([CCode (array_length = false)] uint8[] src, uint16 x, uint16 y, uint16 width, uint16 height);
		[NoWrapper]
		public abstract uint8 get_buffer ();
		public abstract uint16 get_height ();
		public abstract unowned Vnc.PixelFormat get_local_format ();
		public abstract unowned Vnc.PixelFormat get_remote_format ();
		public abstract int get_rowstride ();
		public abstract uint16 get_width ();
		public abstract bool perfect_format_match ();
		public abstract void rgb24_blt ([CCode (array_length = false)] uint8[] src, int rowstride, uint16 x, uint16 y, uint16 width, uint16 height);
		public abstract void set_color_map (Vnc.ColorMap map);
		public abstract void set_pixel_at ([CCode (array_length = false)] uint8[] src, uint16 x, uint16 y);
	}
	[CCode (cheader_filename = "gvnc.h", has_type_id = false)]
	public struct ColorMapEntry {
		public uint16 red;
		public uint16 green;
		public uint16 blue;
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_AUDIO_FORMAT_RAW_", has_type_id = false)]
	public enum AudioFormatType {
		U8,
		S8,
		U16,
		S16,
		U32,
		S32
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_AUTH_", type_id = "vnc_connection_auth_get_type ()")]
	public enum ConnectionAuth {
		INVALID,
		NONE,
		VNC,
		RA2,
		RA2NE,
		TIGHT,
		ULTRA,
		TLS,
		VENCRYPT,
		SASL,
		ARD,
		MSLOGONII,
		MSLOGON
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_AUTH_VENCRYPT_", type_id = "vnc_connection_auth_vencrypt_get_type ()")]
	public enum ConnectionAuthVencrypt {
		PLAIN,
		TLSNONE,
		TLSVNC,
		TLSPLAIN,
		X509NONE,
		X509VNC,
		X509PLAIN,
		X509SASL,
		TLSSASL
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_CREDENTIAL_", type_id = "vnc_connection_credential_get_type ()")]
	public enum ConnectionCredential {
		PASSWORD,
		USERNAME,
		CLIENTNAME,
		CA_CERT_DATA
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_ENCODING_", type_id = "vnc_connection_encoding_get_type ()")]
	public enum ConnectionEncoding {
		RAW,
		COPY_RECT,
		RRE,
		CORRE,
		HEXTILE,
		TIGHT,
		ZRLE,
		TIGHT_JPEG0,
		TIGHT_JPEG1,
		TIGHT_JPEG2,
		TIGHT_JPEG3,
		TIGHT_JPEG4,
		TIGHT_JPEG5,
		TIGHT_JPEG6,
		TIGHT_JPEG7,
		TIGHT_JPEG8,
		TIGHT_JPEG9,
		DESKTOP_RESIZE,
		LAST_RECT,
		[CCode (cname = "VNC_CONNECTION_ENCODING_WMVi")]
		WMVI,
		CURSOR_POS,
		RICH_CURSOR,
		XCURSOR,
		POINTER_CHANGE,
		EXT_KEY_EVENT,
		AUDIO,
		LED_STATE,
		DESKTOP_NAME,
		EXTENDED_DESKTOP_RESIZE,
		XVP,
		ALPHA_CURSOR
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_POWER_ACTION_", type_id = "vnc_connection_power_action_get_type ()")]
	public enum ConnectionPowerAction {
		SHUTDOWN,
		REBOOT,
		RESET
	}
	[CCode (cheader_filename = "gvnc.h", cprefix = "VNC_CONNECTION_RESIZE_STATUS_", type_id = "vnc_connection_resize_status_get_type ()")]
	public enum ConnectionResizeStatus {
		UNSUPPORTED,
		OK,
		ADMIN_PROHIBITED,
		OUT_OF_RESOURCES,
		INVALID_LAOUT,
		FORWARDED
	}
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_LEDSTATE_CAPS_LOCK")]
	public const int LEDSTATE_CAPS_LOCK;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_LEDSTATE_NUM_LOCK")]
	public const int LEDSTATE_NUM_LOCK;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_LEDSTATE_SCROLL_LOCK")]
	public const int LEDSTATE_SCROLL_LOCK;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_PADDING")]
	public const int PADDING;
	[CCode (cheader_filename = "gvnc.h", cname = "VNC_PADDING_LARGE")]
	public const int PADDING_LARGE;
	[CCode (cheader_filename = "gvnc.h")]
	public static bool util_check_version (int major, int minor, int micro);
	[CCode (cheader_filename = "gvnc.h")]
	public static bool util_get_debug ();
	[CCode (cheader_filename = "gvnc.h")]
	public static int util_get_version ();
	[CCode (cheader_filename = "gvnc.h")]
	public static unowned string util_get_version_string ();
	[CCode (cheader_filename = "gvnc.h")]
	public static void util_set_debug (bool enabled);
}
